/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public interface ConfigurationRole {
    public String getName();

    public boolean isConsumable();

    public boolean isResolvable();

    public boolean isDeclarableAgainst();

    public boolean isConsumptionDeprecated();

    public boolean isResolutionDeprecated();

    public boolean isDeclarationAgainstDeprecated();

    default public String describeUsage() {
        return RoleDescriber.describeRole(this);
    }

    public static ConfigurationRole forUsage(String name, boolean consumable, boolean resolvable, boolean declarableAgainst, boolean consumptionDeprecated, boolean resolutionDeprecated, boolean declarationAgainstDeprecated, @Nullable String description, boolean warnOnCustomRole) {
        if (!consumable && consumptionDeprecated || !resolvable && resolutionDeprecated || !declarableAgainst && declarationAgainstDeprecated) {
            throw new IllegalArgumentException("Cannot create a role that deprecates a usage that is not allowed");
        }
        ConfigurationRole result = ConfigurationRoles.byUsage(consumable, resolvable, declarableAgainst, consumptionDeprecated, resolutionDeprecated, declarationAgainstDeprecated).map(ConfigurationRole.class::cast).orElse(new CustomConfigurationRole(name, consumable, resolvable, declarableAgainst, consumptionDeprecated, resolutionDeprecated, declarationAgainstDeprecated, description));
        if (warnOnCustomRole && !Arrays.asList(ConfigurationRoles.values()).contains(result)) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Custom configuration roles are deprecated.").withAdvice("Use one of the standard roles defined in ConfigurationRoles instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "custom_configuration_roles")).nagUser();
        }
        return result;
    }

    public static ConfigurationRole forUsage(boolean consumable, boolean resolvable, boolean declarableAgainst, boolean consumptionDeprecated, boolean resolutionDeprecated, boolean declarationAgainstDeprecated) {
        return ConfigurationRole.forUsage("Custom Role", consumable, resolvable, declarableAgainst, consumptionDeprecated, resolutionDeprecated, declarationAgainstDeprecated);
    }

    public static ConfigurationRole forUsage(boolean consumable, boolean resolvable, boolean declarableAgainst) {
        return ConfigurationRole.forUsage(consumable, resolvable, declarableAgainst, false, false, false);
    }

    public static ConfigurationRole forUsage(String name, boolean consumable, boolean resolvable, boolean declarableAgainst, boolean consumptionDeprecated, boolean resolutionDeprecated, boolean declarationAgainstDeprecated) {
        return ConfigurationRole.forUsage(name, consumable, resolvable, declarableAgainst, consumptionDeprecated, resolutionDeprecated, declarationAgainstDeprecated, null, false);
    }

    public static final class CustomConfigurationRole
    implements ConfigurationRole {
        private final String name;
        private final boolean consumable;
        private final boolean resolvable;
        private final boolean declarableAgainst;
        private final boolean consumptionDeprecated;
        private final boolean resolutionDeprecated;
        private final boolean declarationAgainstDeprecated;
        @Nullable
        private final String description;

        private CustomConfigurationRole(String name, boolean consumable, boolean resolvable, boolean declarableAgainst, boolean consumptionDeprecated, boolean resolutionDeprecated, boolean declarationAgainstDeprecated, @Nullable String description) {
            this.name = name;
            this.consumable = consumable;
            this.resolvable = resolvable;
            this.declarableAgainst = declarableAgainst;
            this.consumptionDeprecated = consumptionDeprecated;
            this.resolutionDeprecated = resolutionDeprecated;
            this.declarationAgainstDeprecated = declarationAgainstDeprecated;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isConsumable() {
            return this.consumable;
        }

        @Override
        public boolean isResolvable() {
            return this.resolvable;
        }

        @Override
        public boolean isDeclarableAgainst() {
            return this.declarableAgainst;
        }

        @Override
        public boolean isConsumptionDeprecated() {
            return this.consumptionDeprecated;
        }

        @Override
        public boolean isResolutionDeprecated() {
            return this.resolutionDeprecated;
        }

        @Override
        public boolean isDeclarationAgainstDeprecated() {
            return this.declarationAgainstDeprecated;
        }

        @Override
        public String describeUsage() {
            if (this.description != null) {
                return this.description;
            }
            return RoleDescriber.describeRole(this);
        }
    }

    public static abstract class RoleDescriber {
        private static final String DEFAULT_CUSTOM_ROLE_NAME = "Custom Role";
        private static final String CONSUMABLE = "Consumable - this configuration can be selected by another project as a dependency";
        private static final String RESOLVABLE = "Resolvable - this configuration can be resolved by this project to a set of files";
        private static final String DECLARABLE_AGAINST = "Declarable Against - this configuration can have dependencies added to it";
        private static final String UNUSABLE = "This configuration does not allow any usage";
        private static final String IS_DEPRECATED = "(but this behavior is marked deprecated)";

        private RoleDescriber() {
        }

        public static String describeRole(ConfigurationRole role) {
            ArrayList<String> descriptions = new ArrayList<String>();
            if (role.isConsumable()) {
                descriptions.add("\tConsumable - this configuration can be selected by another project as a dependency" + RoleDescriber.describeDeprecation(role.isConsumptionDeprecated()));
            }
            if (role.isResolvable()) {
                descriptions.add("\tResolvable - this configuration can be resolved by this project to a set of files" + RoleDescriber.describeDeprecation(role.isResolutionDeprecated()));
            }
            if (role.isDeclarableAgainst()) {
                descriptions.add("\tDeclarable Against - this configuration can have dependencies added to it" + RoleDescriber.describeDeprecation(role.isDeclarationAgainstDeprecated()));
            }
            if (descriptions.isEmpty()) {
                descriptions.add("\tThis configuration does not allow any usage");
            }
            return String.join((CharSequence)"\n", descriptions);
        }

        private static String describeDeprecation(boolean deprecated) {
            return deprecated ? " (but this behavior is marked deprecated)" : "";
        }
    }
}

