/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.internal.file.Chmod;
import org.gradle.util.internal.GFileUtils;

public abstract class AbstractArchiveFileTreeElement
extends AbstractFileTreeElement
implements FileVisitDetails {
    private final File expandedDir;
    private File file;
    private final AtomicBoolean stopFlag;

    protected AbstractArchiveFileTreeElement(Chmod chmod, File expandedDir, AtomicBoolean stopFlag) {
        super(chmod);
        this.expandedDir = expandedDir;
        this.stopFlag = stopFlag;
    }

    protected abstract ArchiveEntry getArchiveEntry();

    protected abstract String safeEntryName();

    public File getFile() {
        if (this.file == null) {
            this.file = new File(this.expandedDir, this.safeEntryName());
            if (!this.file.exists()) {
                GFileUtils.mkdirs((File)this.file.getParentFile());
                this.copyTo(this.file);
            }
        }
        return this.file;
    }

    public RelativePath getRelativePath() {
        return new RelativePath(!this.getArchiveEntry().isDirectory(), this.safeEntryName().split("/"));
    }

    public long getLastModified() {
        return this.getArchiveEntry().getLastModifiedDate().getTime();
    }

    public boolean isDirectory() {
        return this.getArchiveEntry().isDirectory();
    }

    public long getSize() {
        return this.getArchiveEntry().getSize();
    }

    public void stopVisiting() {
        this.stopFlag.set(true);
    }
}

