/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import groovy.io.FileType;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.GroovyFileInterceptors;
import org.gradle.internal.classpath.declarations.InterceptorDeclaration;
import org.gradle.internal.classpath.declarations.KotlinFileExtensionsInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.KotlinStdlibFileInterceptors;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;

class InterceptorDeclaration_GroovyInterceptorsImpl {
    InterceptorDeclaration_GroovyInterceptorsImpl() {
    }

    public static List<CallInterceptor> getCallInterceptors() {
        return Arrays.asList(new ExistsCallInterceptor(), new IsDirectoryCallInterceptor(), new IsFileCallInterceptor(), new LengthCallInterceptor(), new ListCallInterceptor(), new ListFilesCallInterceptor(), new GetBytesCallInterceptor(), new EachByteCallInterceptor(), new EachDirCallInterceptor(), new EachDirMatchCallInterceptor(), new EachFileCallInterceptor(), new EachFileMatchCallInterceptor(), new EachLineCallInterceptor(), new EachObjectCallInterceptor(), new GetTextCallInterceptor(), new NewDataInputStreamCallInterceptor(), new NewInputStreamCallInterceptor(), new NewObjectInputStreamCallInterceptor(), new NewReaderCallInterceptor(), new ReadBytesCallInterceptor(), new ReadLinesCallInterceptor(), new GetSizeCallInterceptor(), new SplitEachLineCallInterceptor(), new WithDataInputStreamCallInterceptor(), new WithInputStreamCallInterceptor(), new WithObjectInputStreamCallInterceptor(), new WithReaderCallInterceptor(), new EmptyStubToEnsureClassGenerationCallInterceptor(), new ReadTextCallInterceptor(), new ForEachBlockCallInterceptor(), new ForEachLineCallInterceptor(), new UseLinesCallInterceptor(), new IsRegularFileCallInterceptor(), new LinesCallInterceptor(), new NewBufferedReaderCallInterceptor(), new NewByteChannelCallInterceptor(), new NewDirectoryStreamCallInterceptor(), new NotExistsCallInterceptor(), new OpenCallInterceptor(), new ProbeContentTypeCallInterceptor(), new ReadAllBytesCallInterceptor(), new ReadAllLinesCallInterceptor(), new ReadStringCallInterceptor(), new FileInputStreamConstructorCallInterceptor());
    }

    private static class FileInputStreamConstructorCallInterceptor
    extends CallInterceptor {
        public FileInputStreamConstructorCallInterceptor() {
            super(InterceptScope.constructorsOf(FileInputStream.class));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object receiver = invocation.getReceiver();
            if (receiver.equals(FileInputStream.class) && invocation.getArgsCount() > 0) {
                Object arg0Typed;
                Object arg0 = invocation.getArgument(0);
                if (arg0 instanceof File) {
                    arg0Typed = (File)arg0;
                    if (invocation.getArgsCount() == 1) {
                        FileInputStream result = new FileInputStream((File)arg0Typed);
                        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor(result, (File)arg0Typed, consumer);
                        return result;
                    }
                }
                if (arg0 instanceof String) {
                    arg0Typed = (String)arg0;
                    if (invocation.getArgsCount() == 1) {
                        FileInputStream result = new FileInputStream((String)arg0Typed);
                        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor(result, (String)arg0Typed, consumer);
                        return result;
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ReadStringCallInterceptor
    extends CallInterceptor {
        public ReadStringCallInterceptor() {
            super(InterceptScope.methodsNamed("readString"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Object arg1;
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_readString(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    Charset arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return NioFileInterceptors.intercept_readString(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ReadAllLinesCallInterceptor
    extends CallInterceptor {
        public ReadAllLinesCallInterceptor() {
            super(InterceptScope.methodsNamed("readAllLines"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Object arg1;
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_readAllLines(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    Charset arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return NioFileInterceptors.intercept_readAllLines(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ReadAllBytesCallInterceptor
    extends CallInterceptor {
        public ReadAllBytesCallInterceptor() {
            super(InterceptScope.methodsNamed("readAllBytes"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_readAllBytes(arg0Typed, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ProbeContentTypeCallInterceptor
    extends CallInterceptor {
        public ProbeContentTypeCallInterceptor() {
            super(InterceptScope.methodsNamed("probeContentType"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_probeContentType(arg0Typed, consumer);
                }
            }
            if (receiver instanceof FileTypeDetector) {
                Object arg02;
                FileTypeDetector receiverTyped = (FileTypeDetector)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Path) {
                    Path arg0Typed = (Path)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return NioFileInterceptors.intercept_probeContentType(receiverTyped, arg0Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class OpenCallInterceptor
    extends CallInterceptor {
        public OpenCallInterceptor() {
            super(InterceptScope.methodsNamed("open"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(FileChannel.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Object arg1;
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Set) {
                    Set arg1Typed = (Set)arg1;
                    FileAttribute[] varargValues = new FileAttribute[invocation.getArgsCount() - 2];
                    boolean varargMatched = true;
                    for (int argIndex = 2; argIndex < invocation.getArgsCount(); ++argIndex) {
                        Object nextArg = invocation.getArgument(argIndex);
                        if (!(nextArg instanceof FileAttribute)) {
                            varargMatched = false;
                            break;
                        }
                        varargValues[argIndex - 2] = (FileAttribute)nextArg;
                    }
                    if (varargMatched) {
                        return NioFileInterceptors.intercept_open(arg0Typed, arg1Typed, varargValues, consumer);
                    }
                }
                OpenOption[] varargValues = new OpenOption[invocation.getArgsCount() - 1];
                boolean varargMatched = true;
                for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                    Object nextArg = invocation.getArgument(argIndex);
                    if (!(nextArg instanceof OpenOption)) {
                        varargMatched = false;
                        break;
                    }
                    varargValues[argIndex - 1] = (OpenOption)nextArg;
                }
                if (varargMatched) {
                    return NioFileInterceptors.intercept_open(arg0Typed, varargValues, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NotExistsCallInterceptor
    extends CallInterceptor {
        public NotExistsCallInterceptor() {
            super(InterceptScope.methodsNamed("notExists"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                LinkOption[] varargValues = new LinkOption[invocation.getArgsCount() - 1];
                boolean varargMatched = true;
                for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                    Object nextArg = invocation.getArgument(argIndex);
                    if (!(nextArg instanceof LinkOption)) {
                        varargMatched = false;
                        break;
                    }
                    varargValues[argIndex - 1] = (LinkOption)nextArg;
                }
                if (varargMatched) {
                    return NioFileInterceptors.intercept_notExists(arg0Typed, varargValues, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NewDirectoryStreamCallInterceptor
    extends CallInterceptor {
        public NewDirectoryStreamCallInterceptor() {
            super(InterceptScope.methodsNamed("newDirectoryStream"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_newDirectoryStream(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1) {
                    Object arg1Typed;
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof String) {
                        arg1Typed = (String)arg1;
                        if (invocation.getArgsCount() == 2) {
                            return NioFileInterceptors.intercept_newDirectoryStream(arg0Typed, (String)arg1Typed, consumer);
                        }
                    }
                    if (arg1 instanceof DirectoryStream.Filter) {
                        arg1Typed = (DirectoryStream.Filter)arg1;
                        if (invocation.getArgsCount() == 2) {
                            return NioFileInterceptors.intercept_newDirectoryStream(arg0Typed, arg1Typed, consumer);
                        }
                    }
                }
            }
            if (receiver instanceof FileSystemProvider) {
                Object arg02;
                FileSystemProvider receiverTyped = (FileSystemProvider)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Path) {
                    Object arg1;
                    Path arg0Typed = (Path)arg02;
                    if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof DirectoryStream.Filter) {
                        DirectoryStream.Filter arg1Typed = (DirectoryStream.Filter)arg1;
                        if (invocation.getArgsCount() == 2) {
                            return NioFileInterceptors.intercept_newDirectoryStream(receiverTyped, arg0Typed, arg1Typed, consumer);
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NewByteChannelCallInterceptor
    extends CallInterceptor {
        public NewByteChannelCallInterceptor() {
            super(InterceptScope.methodsNamed("newByteChannel"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Object arg1;
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Set) {
                    Set arg1Typed = (Set)arg1;
                    FileAttribute[] varargValues = new FileAttribute[invocation.getArgsCount() - 2];
                    boolean varargMatched = true;
                    for (int argIndex = 2; argIndex < invocation.getArgsCount(); ++argIndex) {
                        Object nextArg = invocation.getArgument(argIndex);
                        if (!(nextArg instanceof FileAttribute)) {
                            varargMatched = false;
                            break;
                        }
                        varargValues[argIndex - 2] = (FileAttribute)nextArg;
                    }
                    if (varargMatched) {
                        return NioFileInterceptors.intercept_newByteChannel(arg0Typed, arg1Typed, varargValues, consumer);
                    }
                }
                OpenOption[] varargValues = new OpenOption[invocation.getArgsCount() - 1];
                boolean varargMatched = true;
                for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                    Object nextArg = invocation.getArgument(argIndex);
                    if (!(nextArg instanceof OpenOption)) {
                        varargMatched = false;
                        break;
                    }
                    varargValues[argIndex - 1] = (OpenOption)nextArg;
                }
                if (varargMatched) {
                    return NioFileInterceptors.intercept_newByteChannel(arg0Typed, varargValues, consumer);
                }
            }
            if (receiver instanceof FileSystemProvider) {
                Object arg02;
                FileSystemProvider receiverTyped = (FileSystemProvider)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Path) {
                    Object arg1;
                    Path arg0Typed = (Path)arg02;
                    if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Set) {
                        Set arg1Typed = (Set)arg1;
                        FileAttribute[] varargValues = new FileAttribute[invocation.getArgsCount() - 2];
                        boolean varargMatched = true;
                        for (int argIndex = 2; argIndex < invocation.getArgsCount(); ++argIndex) {
                            Object nextArg = invocation.getArgument(argIndex);
                            if (!(nextArg instanceof FileAttribute)) {
                                varargMatched = false;
                                break;
                            }
                            varargValues[argIndex - 2] = (FileAttribute)nextArg;
                        }
                        if (varargMatched) {
                            return NioFileInterceptors.intercept_newByteChannel(receiverTyped, arg0Typed, arg1Typed, varargValues, consumer);
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NewBufferedReaderCallInterceptor
    extends CallInterceptor {
        public NewBufferedReaderCallInterceptor() {
            super(InterceptScope.methodsNamed("newBufferedReader"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Object arg1;
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_newBufferedReader(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    Charset arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return NioFileInterceptors.intercept_newBufferedReader(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class LinesCallInterceptor
    extends CallInterceptor {
        public LinesCallInterceptor() {
            super(InterceptScope.methodsNamed("lines"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Object arg1;
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_lines(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    Charset arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return NioFileInterceptors.intercept_lines(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class IsRegularFileCallInterceptor
    extends CallInterceptor {
        public IsRegularFileCallInterceptor() {
            super(InterceptScope.methodsNamed("isRegularFile"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                LinkOption[] varargValues = new LinkOption[invocation.getArgsCount() - 1];
                boolean varargMatched = true;
                for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                    Object nextArg = invocation.getArgument(argIndex);
                    if (!(nextArg instanceof LinkOption)) {
                        varargMatched = false;
                        break;
                    }
                    varargValues[argIndex - 1] = (LinkOption)nextArg;
                }
                if (varargMatched) {
                    return NioFileInterceptors.intercept_isRegularFile(arg0Typed, varargValues, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class UseLinesCallInterceptor
    extends CallInterceptor {
        public UseLinesCallInterceptor() {
            super(InterceptScope.methodsNamed("useLines"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(FilesKt.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    Object arg2;
                    Charset arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Function1) {
                        Function1 arg2Typed = (Function1)arg2;
                        if (invocation.getArgsCount() == 3) {
                            return KotlinStdlibFileInterceptors.intercept_useLines(arg0Typed, arg1Typed, arg2Typed, 0, consumer);
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ForEachLineCallInterceptor
    extends CallInterceptor {
        public ForEachLineCallInterceptor() {
            super(InterceptScope.methodsNamed("forEachLine"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(FilesKt.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    Object arg2;
                    Charset arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Function1) {
                        Function1 arg2Typed = (Function1)arg2;
                        if (invocation.getArgsCount() == 3) {
                            KotlinStdlibFileInterceptors.intercept_forEachLine(arg0Typed, arg1Typed, arg2Typed, 0, consumer);
                            return null;
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ForEachBlockCallInterceptor
    extends CallInterceptor {
        public ForEachBlockCallInterceptor() {
            super(InterceptScope.methodsNamed("forEachBlock"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(FilesKt.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Function2) {
                        Function2 arg1Typed = (Function2)arg1;
                        if (invocation.getArgsCount() == 2) {
                            KotlinStdlibFileInterceptors.intercept_forEachBlock(arg0Typed, arg1Typed, consumer);
                            return null;
                        }
                    }
                    if (arg1 instanceof Integer) {
                        Object arg2;
                        int arg1Typed = (Integer)arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Function2) {
                            Function2 arg2Typed = (Function2)arg2;
                            if (invocation.getArgsCount() == 3) {
                                KotlinStdlibFileInterceptors.intercept_forEachBlock(arg0Typed, arg1Typed, arg2Typed, consumer);
                                return null;
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ReadTextCallInterceptor
    extends CallInterceptor {
        public ReadTextCallInterceptor() {
            super(InterceptScope.methodsNamed("readText"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver.equals(FilesKt.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    Charset arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return KotlinFileExtensionsInterceptorsDeclaration.intercept_readText(arg0Typed, arg1Typed, 0, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EmptyStubToEnsureClassGenerationCallInterceptor
    extends CallInterceptor {
        public EmptyStubToEnsureClassGenerationCallInterceptor() {
            super(InterceptScope.methodsNamed("emptyStubToEnsureClassGeneration"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object receiver = invocation.getReceiver();
            if (receiver.equals(InterceptorDeclaration.class) && invocation.getArgsCount() == 0) {
                InterceptorDeclaration.stub();
                return null;
            }
            return invocation.callOriginal();
        }
    }

    private static class WithReaderCallInterceptor
    extends CallInterceptor {
        public WithReaderCallInterceptor() {
            super(InterceptScope.methodsNamed("withReader"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0) {
                    Object arg0Typed;
                    Object arg02 = invocation.getArgument(0);
                    if (arg02 instanceof Closure) {
                        arg0Typed = (Closure)arg02;
                        if (invocation.getArgsCount() == 1) {
                            return GroovyFileInterceptors.intercept_withReader(receiverTyped, arg0Typed, consumer);
                        }
                    }
                    if (arg02 instanceof String) {
                        Object arg1;
                        arg0Typed = (String)arg02;
                        if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                            Closure arg1Typed = (Closure)arg1;
                            if (invocation.getArgsCount() == 2) {
                                return GroovyFileInterceptors.intercept_withReader(receiverTyped, (String)arg0Typed, arg1Typed, consumer);
                            }
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Object arg1Typed;
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Closure) {
                        arg1Typed = (Closure)arg1;
                        if (invocation.getArgsCount() == 2) {
                            return GroovyFileInterceptors.intercept_withReader(arg0Typed, arg1Typed, consumer);
                        }
                    }
                    if (arg1 instanceof String) {
                        Object arg2;
                        arg1Typed = (String)arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                            Closure arg2Typed = (Closure)arg2;
                            if (invocation.getArgsCount() == 3) {
                                return GroovyFileInterceptors.intercept_withReader(arg0Typed, (String)arg1Typed, arg2Typed, consumer);
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class WithObjectInputStreamCallInterceptor
    extends CallInterceptor {
        public WithObjectInputStreamCallInterceptor() {
            super(InterceptScope.methodsNamed("withObjectInputStream"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0) {
                    Object arg0Typed;
                    Object arg02 = invocation.getArgument(0);
                    if (arg02 instanceof Closure) {
                        arg0Typed = (Closure)arg02;
                        if (invocation.getArgsCount() == 1) {
                            return GroovyFileInterceptors.intercept_withObjectInputStream(receiverTyped, arg0Typed, consumer);
                        }
                    }
                    if (arg02 instanceof ClassLoader) {
                        Object arg1;
                        arg0Typed = (ClassLoader)arg02;
                        if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                            Closure arg1Typed = (Closure)arg1;
                            if (invocation.getArgsCount() == 2) {
                                return GroovyFileInterceptors.intercept_withObjectInputStream(receiverTyped, (ClassLoader)arg0Typed, arg1Typed, consumer);
                            }
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Object arg1Typed;
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Closure) {
                        arg1Typed = (Closure)arg1;
                        if (invocation.getArgsCount() == 2) {
                            return GroovyFileInterceptors.intercept_withObjectInputStream(arg0Typed, arg1Typed, consumer);
                        }
                    }
                    if (arg1 instanceof ClassLoader) {
                        Object arg2;
                        arg1Typed = (ClassLoader)arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                            Closure arg2Typed = (Closure)arg2;
                            if (invocation.getArgsCount() == 3) {
                                return GroovyFileInterceptors.intercept_withObjectInputStream(arg0Typed, (ClassLoader)arg1Typed, arg2Typed, consumer);
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class WithInputStreamCallInterceptor
    extends CallInterceptor {
        public WithInputStreamCallInterceptor() {
            super(InterceptScope.methodsNamed("withInputStream"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Closure) {
                    Closure arg0Typed = (Closure)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return GroovyFileInterceptors.intercept_withInputStream(receiverTyped, arg0Typed, consumer);
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                    Closure arg1Typed = (Closure)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return GroovyFileInterceptors.intercept_withInputStream(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class WithDataInputStreamCallInterceptor
    extends CallInterceptor {
        public WithDataInputStreamCallInterceptor() {
            super(InterceptScope.methodsNamed("withDataInputStream"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Closure) {
                    Closure arg0Typed = (Closure)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return GroovyFileInterceptors.intercept_withDataInputStream(receiverTyped, arg0Typed, consumer);
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                    Closure arg1Typed = (Closure)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return GroovyFileInterceptors.intercept_withDataInputStream(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class SplitEachLineCallInterceptor
    extends CallInterceptor {
        public SplitEachLineCallInterceptor() {
            super(InterceptScope.methodsNamed("splitEachLine"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0) {
                    Closure arg2Typed;
                    Object arg2;
                    Object arg1Typed;
                    Object arg1;
                    Object arg0Typed;
                    Object arg02 = invocation.getArgument(0);
                    if (arg02 instanceof Pattern) {
                        arg0Typed = (Pattern)arg02;
                        if (invocation.getArgsCount() > 1) {
                            arg1 = invocation.getArgument(1);
                            if (arg1 instanceof Closure) {
                                arg1Typed = (Closure)arg1;
                                if (invocation.getArgsCount() == 2) {
                                    return GroovyFileInterceptors.intercept_splitEachLine(receiverTyped, (Pattern)arg0Typed, arg1Typed, consumer);
                                }
                            }
                            if (arg1 instanceof String) {
                                arg1Typed = (String)arg1;
                                if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                                    arg2Typed = (Closure)arg2;
                                    if (invocation.getArgsCount() == 3) {
                                        return GroovyFileInterceptors.intercept_splitEachLine(receiverTyped, (Pattern)arg0Typed, (String)arg1Typed, arg2Typed, consumer);
                                    }
                                }
                            }
                        }
                    }
                    if (arg02 instanceof String) {
                        arg0Typed = (String)arg02;
                        if (invocation.getArgsCount() > 1) {
                            arg1 = invocation.getArgument(1);
                            if (arg1 instanceof Closure) {
                                arg1Typed = (Closure)arg1;
                                if (invocation.getArgsCount() == 2) {
                                    return GroovyFileInterceptors.intercept_splitEachLine(receiverTyped, (String)arg0Typed, arg1Typed, consumer);
                                }
                            }
                            if (arg1 instanceof String) {
                                arg1Typed = (String)arg1;
                                if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                                    arg2Typed = (Closure)arg2;
                                    if (invocation.getArgsCount() == 3) {
                                        return GroovyFileInterceptors.intercept_splitEachLine(receiverTyped, (String)arg0Typed, (String)arg1Typed, arg2Typed, consumer);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Closure arg3Typed;
                    Object arg3;
                    Object arg2Typed;
                    Object arg2;
                    Object arg1Typed;
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Pattern) {
                        arg1Typed = (Pattern)arg1;
                        if (invocation.getArgsCount() > 2) {
                            arg2 = invocation.getArgument(2);
                            if (arg2 instanceof Closure) {
                                arg2Typed = (Closure)arg2;
                                if (invocation.getArgsCount() == 3) {
                                    return GroovyFileInterceptors.intercept_splitEachLine(arg0Typed, (Pattern)arg1Typed, arg2Typed, consumer);
                                }
                            }
                            if (arg2 instanceof String) {
                                arg2Typed = (String)arg2;
                                if (invocation.getArgsCount() > 3 && (arg3 = invocation.getArgument(3)) instanceof Closure) {
                                    arg3Typed = (Closure)arg3;
                                    if (invocation.getArgsCount() == 4) {
                                        return GroovyFileInterceptors.intercept_splitEachLine(arg0Typed, (Pattern)arg1Typed, (String)arg2Typed, arg3Typed, consumer);
                                    }
                                }
                            }
                        }
                    }
                    if (arg1 instanceof String) {
                        arg1Typed = (String)arg1;
                        if (invocation.getArgsCount() > 2) {
                            arg2 = invocation.getArgument(2);
                            if (arg2 instanceof Closure) {
                                arg2Typed = (Closure)arg2;
                                if (invocation.getArgsCount() == 3) {
                                    return GroovyFileInterceptors.intercept_splitEachLine(arg0Typed, (String)arg1Typed, arg2Typed, consumer);
                                }
                            }
                            if (arg2 instanceof String) {
                                arg2Typed = (String)arg2;
                                if (invocation.getArgsCount() > 3 && (arg3 = invocation.getArgument(3)) instanceof Closure) {
                                    arg3Typed = (Closure)arg3;
                                    if (invocation.getArgsCount() == 4) {
                                        return GroovyFileInterceptors.intercept_splitEachLine(arg0Typed, (String)arg1Typed, (String)arg2Typed, arg3Typed, consumer);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class GetSizeCallInterceptor
    extends CallInterceptor {
        public GetSizeCallInterceptor() {
            super(InterceptScope.readsOfPropertiesNamed("size"), InterceptScope.methodsNamed("getSize"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_size(receiverTyped, consumer);
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_size(arg0Typed, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ReadLinesCallInterceptor
    extends CallInterceptor {
        public ReadLinesCallInterceptor() {
            super(InterceptScope.methodsNamed("readLines"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg1Typed;
            Object arg1;
            File arg0Typed;
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_readLines(receiverTyped, consumer);
                }
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof String) {
                    String arg0Typed2 = (String)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return GroovyFileInterceptors.intercept_readLines(receiverTyped, arg0Typed2, consumer);
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_readLines(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof String) {
                    arg1Typed = (String)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return GroovyFileInterceptors.intercept_readLines(arg0Typed, (String)arg1Typed, consumer);
                    }
                }
            }
            if (receiver.equals(FilesKt.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Charset) {
                    arg1Typed = (Charset)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return KotlinStdlibFileInterceptors.intercept_readLines(arg0Typed, (Charset)arg1Typed, 0, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ReadBytesCallInterceptor
    extends CallInterceptor {
        public ReadBytesCallInterceptor() {
            super(InterceptScope.methodsNamed("readBytes"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            File arg0Typed;
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_readBytes(receiverTyped, consumer);
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_readBytes(arg0Typed, consumer);
                }
            }
            if (receiver.equals(FilesKt.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return KotlinStdlibFileInterceptors.intercept_readBytes(arg0Typed, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NewReaderCallInterceptor
    extends CallInterceptor {
        public NewReaderCallInterceptor() {
            super(InterceptScope.methodsNamed("newReader"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_newReader(receiverTyped, consumer);
                }
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof String) {
                    String arg0Typed = (String)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return GroovyFileInterceptors.intercept_newReader(receiverTyped, arg0Typed, consumer);
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_newReader(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof String) {
                    String arg1Typed = (String)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return GroovyFileInterceptors.intercept_newReader(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NewObjectInputStreamCallInterceptor
    extends CallInterceptor {
        public NewObjectInputStreamCallInterceptor() {
            super(InterceptScope.methodsNamed("newObjectInputStream"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_newObjectInputStream(receiverTyped, consumer);
                }
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof ClassLoader) {
                    ClassLoader arg0Typed = (ClassLoader)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return GroovyFileInterceptors.intercept_newObjectInputStream(receiverTyped, arg0Typed, consumer);
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_newObjectInputStream(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof ClassLoader) {
                    ClassLoader arg1Typed = (ClassLoader)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return GroovyFileInterceptors.intercept_newObjectInputStream(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NewInputStreamCallInterceptor
    extends CallInterceptor {
        public NewInputStreamCallInterceptor() {
            super(InterceptScope.methodsNamed("newInputStream"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Comparable<File> arg0Typed;
            Object arg0;
            Object receiverTyped;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_newInputStream((File)receiverTyped, consumer);
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_newInputStream(arg0Typed, consumer);
                }
            }
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                arg0Typed = (Path)arg0;
                OpenOption[] varargValues = new OpenOption[invocation.getArgsCount() - 1];
                boolean varargMatched = true;
                for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                    Object nextArg = invocation.getArgument(argIndex);
                    if (!(nextArg instanceof OpenOption)) {
                        varargMatched = false;
                        break;
                    }
                    varargValues[argIndex - 1] = (OpenOption)nextArg;
                }
                if (varargMatched) {
                    return NioFileInterceptors.intercept_newInputStream((Path)arg0Typed, varargValues, consumer);
                }
            }
            if (receiver instanceof FileSystemProvider) {
                Object arg02;
                receiverTyped = (FileSystemProvider)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Path) {
                    Path arg0Typed2 = (Path)arg02;
                    OpenOption[] varargValues = new OpenOption[invocation.getArgsCount() - 1];
                    boolean varargMatched = true;
                    for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                        Object nextArg = invocation.getArgument(argIndex);
                        if (!(nextArg instanceof OpenOption)) {
                            varargMatched = false;
                            break;
                        }
                        varargValues[argIndex - 1] = (OpenOption)nextArg;
                    }
                    if (varargMatched) {
                        return NioFileInterceptors.intercept_newInputStream((FileSystemProvider)receiverTyped, arg0Typed2, varargValues, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class NewDataInputStreamCallInterceptor
    extends CallInterceptor {
        public NewDataInputStreamCallInterceptor() {
            super(InterceptScope.methodsNamed("newDataInputStream"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_newDataInputStream(receiverTyped, consumer);
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_newDataInputStream(arg0Typed, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class GetTextCallInterceptor
    extends CallInterceptor {
        public GetTextCallInterceptor() {
            super(InterceptScope.readsOfPropertiesNamed("text"), InterceptScope.methodsNamed("getText"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_text(receiverTyped, consumer);
                }
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof String) {
                    String arg0Typed = (String)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return GroovyFileInterceptors.intercept_getText(receiverTyped, arg0Typed, consumer);
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_text(arg0Typed, consumer);
                }
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof String) {
                    String arg1Typed = (String)arg1;
                    if (invocation.getArgsCount() == 2) {
                        return GroovyFileInterceptors.intercept_getText(arg0Typed, arg1Typed, consumer);
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EachObjectCallInterceptor
    extends CallInterceptor {
        public EachObjectCallInterceptor() {
            super(InterceptScope.methodsNamed("eachObject"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Closure) {
                    Closure arg0Typed = (Closure)arg02;
                    if (invocation.getArgsCount() == 1) {
                        GroovyFileInterceptors.intercept_eachObject(receiverTyped, arg0Typed, consumer);
                        return null;
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                    Closure arg1Typed = (Closure)arg1;
                    if (invocation.getArgsCount() == 2) {
                        GroovyFileInterceptors.intercept_eachObject(arg0Typed, arg1Typed, consumer);
                        return null;
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EachLineCallInterceptor
    extends CallInterceptor {
        public EachLineCallInterceptor() {
            super(InterceptScope.methodsNamed("eachLine"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0) {
                    Closure arg1Typed;
                    Object arg1;
                    Object arg0Typed;
                    Object arg02 = invocation.getArgument(0);
                    if (arg02 instanceof Closure) {
                        arg0Typed = (Closure)arg02;
                        if (invocation.getArgsCount() == 1) {
                            GroovyFileInterceptors.intercept_eachLine(receiverTyped, arg0Typed, consumer);
                            return null;
                        }
                    }
                    if (arg02 instanceof String) {
                        arg0Typed = (String)arg02;
                        if (invocation.getArgsCount() > 1) {
                            arg1 = invocation.getArgument(1);
                            if (arg1 instanceof Closure) {
                                arg1Typed = (Closure)arg1;
                                if (invocation.getArgsCount() == 2) {
                                    GroovyFileInterceptors.intercept_eachLine(receiverTyped, (String)arg0Typed, arg1Typed, consumer);
                                    return null;
                                }
                            }
                            if (arg1 instanceof Integer) {
                                Object arg2;
                                int arg1Typed2 = (Integer)arg1;
                                if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                                    Closure arg2Typed = (Closure)arg2;
                                    if (invocation.getArgsCount() == 3) {
                                        GroovyFileInterceptors.intercept_eachLine(receiverTyped, (String)arg0Typed, arg1Typed2, arg2Typed, consumer);
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                    if (arg02 instanceof Integer) {
                        int arg0Typed2 = (Integer)arg02;
                        if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                            arg1Typed = (Closure)arg1;
                            if (invocation.getArgsCount() == 2) {
                                GroovyFileInterceptors.intercept_eachLine(receiverTyped, arg0Typed2, arg1Typed, consumer);
                                return null;
                            }
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Object arg2;
                    Object arg1Typed;
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Closure) {
                        arg1Typed = (Closure)arg1;
                        if (invocation.getArgsCount() == 2) {
                            GroovyFileInterceptors.intercept_eachLine(arg0Typed, arg1Typed, consumer);
                            return null;
                        }
                    }
                    if (arg1 instanceof String) {
                        arg1Typed = (String)arg1;
                        if (invocation.getArgsCount() > 2) {
                            arg2 = invocation.getArgument(2);
                            if (arg2 instanceof Closure) {
                                Closure arg2Typed = (Closure)arg2;
                                if (invocation.getArgsCount() == 3) {
                                    GroovyFileInterceptors.intercept_eachLine(arg0Typed, (String)arg1Typed, arg2Typed, consumer);
                                    return null;
                                }
                            }
                            if (arg2 instanceof Integer) {
                                Object arg3;
                                int arg2Typed = (Integer)arg2;
                                if (invocation.getArgsCount() > 3 && (arg3 = invocation.getArgument(3)) instanceof Closure) {
                                    Closure arg3Typed = (Closure)arg3;
                                    if (invocation.getArgsCount() == 4) {
                                        GroovyFileInterceptors.intercept_eachLine(arg0Typed, (String)arg1Typed, arg2Typed, arg3Typed, consumer);
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                    if (arg1 instanceof Integer) {
                        int arg1Typed3 = (Integer)arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                            Closure arg2Typed = (Closure)arg2;
                            if (invocation.getArgsCount() == 3) {
                                GroovyFileInterceptors.intercept_eachLine(arg0Typed, arg1Typed3, arg2Typed, consumer);
                                return null;
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EachFileMatchCallInterceptor
    extends CallInterceptor {
        public EachFileMatchCallInterceptor() {
            super(InterceptScope.methodsNamed("eachFileMatch"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0) {
                    Object arg1Typed;
                    Object arg1;
                    Object arg0Typed;
                    Object arg02 = invocation.getArgument(0);
                    if (arg02 instanceof Object) {
                        arg0Typed = arg02;
                        if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                            arg1Typed = (Closure)arg1;
                            if (invocation.getArgsCount() == 2) {
                                GroovyFileInterceptors.intercept_eachFileMatch(receiverTyped, arg0Typed, arg1Typed, consumer);
                                return null;
                            }
                        }
                    }
                    if (arg02 instanceof FileType) {
                        arg0Typed = (FileType)arg02;
                        if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Object) {
                            Object arg2;
                            arg1Typed = arg1;
                            if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                                Closure arg2Typed = (Closure)arg2;
                                if (invocation.getArgsCount() == 3) {
                                    GroovyFileInterceptors.intercept_eachFileMatch(receiverTyped, (FileType)arg0Typed, arg1Typed, arg2Typed, consumer);
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Object arg2Typed;
                    Object arg2;
                    Object arg1Typed;
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Object) {
                        arg1Typed = arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                            arg2Typed = (Closure)arg2;
                            if (invocation.getArgsCount() == 3) {
                                GroovyFileInterceptors.intercept_eachFileMatch(arg0Typed, arg1Typed, arg2Typed, consumer);
                                return null;
                            }
                        }
                    }
                    if (arg1 instanceof FileType) {
                        arg1Typed = (FileType)arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Object) {
                            Object arg3;
                            arg2Typed = arg2;
                            if (invocation.getArgsCount() > 3 && (arg3 = invocation.getArgument(3)) instanceof Closure) {
                                Closure arg3Typed = (Closure)arg3;
                                if (invocation.getArgsCount() == 4) {
                                    GroovyFileInterceptors.intercept_eachFileMatch(arg0Typed, (FileType)arg1Typed, arg2Typed, arg3Typed, consumer);
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EachFileCallInterceptor
    extends CallInterceptor {
        public EachFileCallInterceptor() {
            super(InterceptScope.methodsNamed("eachFile"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0) {
                    Closure arg0Typed;
                    Object arg02 = invocation.getArgument(0);
                    if (arg02 instanceof Closure) {
                        arg0Typed = (Closure)arg02;
                        if (invocation.getArgsCount() == 1) {
                            GroovyFileInterceptors.intercept_eachFile(receiverTyped, arg0Typed, consumer);
                            return null;
                        }
                    }
                    if (arg02 instanceof FileType) {
                        Object arg1;
                        arg0Typed = (FileType)arg02;
                        if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                            Closure arg1Typed = (Closure)arg1;
                            if (invocation.getArgsCount() == 2) {
                                GroovyFileInterceptors.intercept_eachFile(receiverTyped, (FileType)arg0Typed, arg1Typed, consumer);
                                return null;
                            }
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Closure arg1Typed;
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Closure) {
                        arg1Typed = (Closure)arg1;
                        if (invocation.getArgsCount() == 2) {
                            GroovyFileInterceptors.intercept_eachFile(arg0Typed, arg1Typed, consumer);
                            return null;
                        }
                    }
                    if (arg1 instanceof FileType) {
                        Object arg2;
                        arg1Typed = (FileType)arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                            Closure arg2Typed = (Closure)arg2;
                            if (invocation.getArgsCount() == 3) {
                                GroovyFileInterceptors.intercept_eachFile(arg0Typed, (FileType)arg1Typed, arg2Typed, consumer);
                                return null;
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EachDirMatchCallInterceptor
    extends CallInterceptor {
        public EachDirMatchCallInterceptor() {
            super(InterceptScope.methodsNamed("eachDirMatch"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Object) {
                    Object arg1;
                    Object arg0Typed = arg02;
                    if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                        Closure arg1Typed = (Closure)arg1;
                        if (invocation.getArgsCount() == 2) {
                            GroovyFileInterceptors.intercept_eachDirMatch(receiverTyped, arg0Typed, arg1Typed, consumer);
                            return null;
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Object) {
                    Object arg2;
                    Object arg1Typed = arg1;
                    if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                        Closure arg2Typed = (Closure)arg2;
                        if (invocation.getArgsCount() == 3) {
                            GroovyFileInterceptors.intercept_eachDirMatch(arg0Typed, arg1Typed, arg2Typed, consumer);
                            return null;
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EachDirCallInterceptor
    extends CallInterceptor {
        public EachDirCallInterceptor() {
            super(InterceptScope.methodsNamed("eachDir"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof Closure) {
                    Closure arg0Typed = (Closure)arg02;
                    if (invocation.getArgsCount() == 1) {
                        GroovyFileInterceptors.intercept_eachDir(receiverTyped, arg0Typed, consumer);
                        return null;
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                Object arg1;
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                    Closure arg1Typed = (Closure)arg1;
                    if (invocation.getArgsCount() == 2) {
                        GroovyFileInterceptors.intercept_eachDir(arg0Typed, arg1Typed, consumer);
                        return null;
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class EachByteCallInterceptor
    extends CallInterceptor {
        public EachByteCallInterceptor() {
            super(InterceptScope.methodsNamed("eachByte"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() > 0) {
                    Object arg02 = invocation.getArgument(0);
                    if (arg02 instanceof Closure) {
                        Closure arg0Typed = (Closure)arg02;
                        if (invocation.getArgsCount() == 1) {
                            GroovyFileInterceptors.intercept_eachByte(receiverTyped, arg0Typed, consumer);
                            return null;
                        }
                    }
                    if (arg02 instanceof Integer) {
                        Object arg1;
                        int arg0Typed = (Integer)arg02;
                        if (invocation.getArgsCount() > 1 && (arg1 = invocation.getArgument(1)) instanceof Closure) {
                            Closure arg1Typed = (Closure)arg1;
                            if (invocation.getArgsCount() == 2) {
                                GroovyFileInterceptors.intercept_eachByte(receiverTyped, arg0Typed, arg1Typed, consumer);
                                return null;
                            }
                        }
                    }
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() > 1) {
                    Object arg1 = invocation.getArgument(1);
                    if (arg1 instanceof Closure) {
                        Closure arg1Typed = (Closure)arg1;
                        if (invocation.getArgsCount() == 2) {
                            GroovyFileInterceptors.intercept_eachByte(arg0Typed, arg1Typed, consumer);
                            return null;
                        }
                    }
                    if (arg1 instanceof Integer) {
                        Object arg2;
                        int arg1Typed = (Integer)arg1;
                        if (invocation.getArgsCount() > 2 && (arg2 = invocation.getArgument(2)) instanceof Closure) {
                            Closure arg2Typed = (Closure)arg2;
                            if (invocation.getArgsCount() == 3) {
                                GroovyFileInterceptors.intercept_eachByte(arg0Typed, arg1Typed, arg2Typed, consumer);
                                return null;
                            }
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class GetBytesCallInterceptor
    extends CallInterceptor {
        public GetBytesCallInterceptor() {
            super(InterceptScope.readsOfPropertiesNamed("bytes"), InterceptScope.methodsNamed("getBytes"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return GroovyFileInterceptors.intercept_bytes(receiverTyped, consumer);
                }
            }
            if (receiver.equals(ResourceGroovyMethods.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof File) {
                File arg0Typed = (File)arg0;
                if (invocation.getArgsCount() == 1) {
                    return GroovyFileInterceptors.intercept_bytes(arg0Typed, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ListFilesCallInterceptor
    extends CallInterceptor {
        public ListFilesCallInterceptor() {
            super(InterceptScope.methodsNamed("listFiles"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return FileInterceptorsDeclaration.intercept_listFiles(receiverTyped, consumer);
                }
                if (invocation.getArgsCount() > 0) {
                    Object arg0Typed;
                    Object arg0 = invocation.getArgument(0);
                    if (arg0 instanceof FileFilter) {
                        arg0Typed = (FileFilter)arg0;
                        if (invocation.getArgsCount() == 1) {
                            return FileInterceptorsDeclaration.intercept_listFiles(receiverTyped, (FileFilter)arg0Typed, consumer);
                        }
                    }
                    if (arg0 instanceof FilenameFilter) {
                        arg0Typed = (FilenameFilter)arg0;
                        if (invocation.getArgsCount() == 1) {
                            return FileInterceptorsDeclaration.intercept_listFiles(receiverTyped, (FilenameFilter)arg0Typed, consumer);
                        }
                    }
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ListCallInterceptor
    extends CallInterceptor {
        public ListCallInterceptor() {
            super(InterceptScope.methodsNamed("list"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                Object arg02;
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return FileInterceptorsDeclaration.intercept_list(receiverTyped, consumer);
                }
                if (invocation.getArgsCount() > 0 && (arg02 = invocation.getArgument(0)) instanceof FilenameFilter) {
                    FilenameFilter arg0Typed = (FilenameFilter)arg02;
                    if (invocation.getArgsCount() == 1) {
                        return FileInterceptorsDeclaration.intercept_list(receiverTyped, arg0Typed, consumer);
                    }
                }
            }
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                if (invocation.getArgsCount() == 1) {
                    return NioFileInterceptors.intercept_list(arg0Typed, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class LengthCallInterceptor
    extends CallInterceptor {
        public LengthCallInterceptor() {
            super(InterceptScope.methodsNamed("length"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return FileInterceptorsDeclaration.intercept_length(receiverTyped, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class IsFileCallInterceptor
    extends CallInterceptor {
        public IsFileCallInterceptor() {
            super(InterceptScope.methodsNamed("isFile"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return FileInterceptorsDeclaration.intercept_isFile(receiverTyped, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class IsDirectoryCallInterceptor
    extends CallInterceptor {
        public IsDirectoryCallInterceptor() {
            super(InterceptScope.methodsNamed("isDirectory"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return FileInterceptorsDeclaration.intercept_isDirectory(receiverTyped, consumer);
                }
            }
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                LinkOption[] varargValues = new LinkOption[invocation.getArgsCount() - 1];
                boolean varargMatched = true;
                for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                    Object nextArg = invocation.getArgument(argIndex);
                    if (!(nextArg instanceof LinkOption)) {
                        varargMatched = false;
                        break;
                    }
                    varargValues[argIndex - 1] = (LinkOption)nextArg;
                }
                if (varargMatched) {
                    return NioFileInterceptors.intercept_isDirectory(arg0Typed, varargValues, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }

    private static class ExistsCallInterceptor
    extends CallInterceptor {
        public ExistsCallInterceptor() {
            super(InterceptScope.methodsNamed("exists"));
        }

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            Object arg0;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof File) {
                File receiverTyped = (File)receiver;
                if (invocation.getArgsCount() == 0) {
                    return FileInterceptorsDeclaration.intercept_exists(receiverTyped, consumer);
                }
            }
            if (receiver.equals(Files.class) && invocation.getArgsCount() > 0 && (arg0 = invocation.getArgument(0)) instanceof Path) {
                Path arg0Typed = (Path)arg0;
                LinkOption[] varargValues = new LinkOption[invocation.getArgsCount() - 1];
                boolean varargMatched = true;
                for (int argIndex = 1; argIndex < invocation.getArgsCount(); ++argIndex) {
                    Object nextArg = invocation.getArgument(argIndex);
                    if (!(nextArg instanceof LinkOption)) {
                        varargMatched = false;
                        break;
                    }
                    varargValues[argIndex - 1] = (LinkOption)nextArg;
                }
                if (varargMatched) {
                    return NioFileInterceptors.intercept_exists(arg0Typed, varargValues, consumer);
                }
            }
            return invocation.callOriginal();
        }
    }
}

