/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.TestSuiteName;
import org.gradle.api.attributes.TestSuiteTargetName;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.JvmTestSuiteTarget;
import org.gradle.api.plugins.jvm.internal.DefaultJvmTestSuite;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;
import org.gradle.util.internal.TextUtil;

@Incubating
public abstract class JvmTestSuitePlugin
implements Plugin<Project> {
    public static final String DEFAULT_TEST_SUITE_NAME = "test";
    private static final String TEST_RESULTS_ELEMENTS_VARIANT_PREFIX = "testResultsElementsFor";
    private final Map<String, TestSuite> testTypesInUse = new HashMap<String, TestSuite>(2);

    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.test-suite-base");
        project.getPluginManager().apply("org.gradle.java-base");
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        ExtensiblePolymorphicDomainObjectContainer testSuites = testing.getSuites();
        testSuites.registerBinding(JvmTestSuite.class, DefaultJvmTestSuite.class);
        project.getTasks().withType(Test.class).configureEach(test -> {
            test.getConventionMapping().map("testClassesDirs", () -> {
                ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)"Relying on the convention for Test.testClassesDirs in custom Test tasks").willBeRemovedInGradle9().withUpgradeGuideSection(8, "test_task_default_classpath")).nagUser();
                return JavaPluginHelper.getDefaultTestSuite(project).getSources().getOutput().getClassesDirs();
            });
            test.getConventionMapping().map("classpath", () -> {
                ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)"Relying on the convention for Test.classpath in custom Test tasks").willBeRemovedInGradle9().withUpgradeGuideSection(8, "test_task_default_classpath")).nagUser();
                return JavaPluginHelper.getDefaultTestSuite(project).getSources().getRuntimeClasspath();
            });
            test.getModularity().getInferModulePath().convention((Provider)java.getModularity().getInferModulePath());
        });
        testSuites.withType(JvmTestSuite.class).all(testSuite -> {
            testSuite.getTestType().convention((Object)this.getDefaultTestType((JvmTestSuite)testSuite));
            testSuite.getTargets().all(target -> target.getTestTask().configure(test -> {
                test.getConventionMapping().map("testClassesDirs", () -> testSuite.getSources().getOutput().getClassesDirs());
                test.getConventionMapping().map("classpath", () -> testSuite.getSources().getRuntimeClasspath());
            }));
        });
        this.configureTestDataElementsVariants((ProjectInternal)project);
    }

    private String getDefaultTestType(JvmTestSuite testSuite) {
        return DEFAULT_TEST_SUITE_NAME.equals(testSuite.getName()) ? "unit-test" : TextUtil.camelToKebabCase((String)testSuite.getName());
    }

    private void configureTestDataElementsVariants(ProjectInternal project) {
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        ExtensiblePolymorphicDomainObjectContainer testSuites = testing.getSuites();
        testSuites.withType(JvmTestSuite.class).configureEach(suite -> suite.getTargets().configureEach(target -> this.addTestResultsVariant(project, (JvmTestSuite)suite, (JvmTestSuiteTarget)target)));
    }

    private void addTestResultsVariant(ProjectInternal project, JvmTestSuite suite, JvmTestSuiteTarget target) {
        Configuration variant = project.getConfigurations().consumable(TEST_RESULTS_ELEMENTS_VARIANT_PREFIX + StringUtils.capitalize((String)target.getName()));
        variant.setDescription("Directory containing binary results of running tests for the " + suite.getName() + " Test Suite's " + target.getName() + " target.");
        variant.setVisible(false);
        ObjectFactory objects = project.getObjects();
        variant.attributes(attributes -> {
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "verification")));
            attributes.attribute(TestSuiteName.TEST_SUITE_NAME_ATTRIBUTE, (Object)((TestSuiteName)objects.named(TestSuiteName.class, suite.getName())));
            attributes.attribute(TestSuiteTargetName.TEST_SUITE_TARGET_NAME_ATTRIBUTE, (Object)((TestSuiteTargetName)objects.named(TestSuiteTargetName.class, target.getName())));
            attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, suite.getTestType().map(tt -> this.createNamedTestTypeAndVerifyUniqueness((Project)project, suite, (String)tt)));
            attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)objects.named(VerificationType.class, "test-results")));
        });
        variant.getOutgoing().artifact((Object)target.getTestTask().flatMap(AbstractTestTask::getBinaryResultsDirectory), artifact -> artifact.setType("directory"));
    }

    private TestSuiteType createNamedTestTypeAndVerifyUniqueness(Project project, TestSuite suite, String tt) {
        TestSuite other = this.testTypesInUse.putIfAbsent(tt, suite);
        if (null != other) {
            throw new BuildException("Could not configure suite: '" + suite.getName() + "'. Another test suite: '" + other.getName() + "' uses the type: '" + tt + "' and has already been configured in project: '" + project.getName() + "'.");
        }
        return (TestSuiteType)project.getObjects().named(TestSuiteType.class, tt);
    }
}

