/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.ObjectNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ThrowableInterner;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;

final class ObjectTree {
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final Set<Disposable> myRootObjects = new ReferenceOpenHashSet<Disposable>();
    private final Map<Disposable, ObjectNode> myObject2NodeMap = new Reference2ObjectOpenHashMap<Disposable, ObjectNode>();
    private final Map<Disposable, Object> myDisposedObjects = CollectionFactory.createWeakIdentityMap(100, 0.5f);
    private final Object treeLock = new Object();

    ObjectTree() {
    }

    private ObjectNode getNode(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(0);
        }
        return this.myObject2NodeMap.get(object);
    }

    private void putNode(@NotNull Disposable object, @Nullable(value="null means remove") @Nullable(value="null means remove") ObjectNode node) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(1);
        }
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final RuntimeException register(@NotNull Disposable parent2, @NotNull Disposable child) {
        if (parent2 == null) {
            ObjectTree.$$$reportNull$$$0(2);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(3);
        }
        if (parent2 == child) {
            return new IllegalArgumentException("Cannot register to itself: " + parent2);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode childNode;
            Object wasDisposed = this.getDisposalInfo(parent2);
            if (wasDisposed != null) {
                return new IncorrectOperationException("Sorry but parent: " + parent2 + " has already been disposed (see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            this.myDisposedObjects.remove(child);
            ObjectNode parentNode = this.getNode(parent2);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent2, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            RuntimeException e = ObjectTree.checkWasNotAddedAlready(parentNode, childNode);
            if (e != null) {
                return e;
            }
            parentNode.addChild(childNode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDisposalInfo(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(4);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private static RuntimeException checkWasNotAddedAlready(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) {
        if (childNode == null) {
            ObjectTree.$$$reportNull$$$0(5);
        }
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(6);
        }
        for (ObjectNode node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            return new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
        return null;
    }

    @NotNull
    private ObjectNode createNodeFor(@NotNull Disposable object, @Nullable ObjectNode parentNode) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(7);
        }
        ObjectNode newNode = new ObjectNode(this, parentNode, object);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode objectNode = newNode;
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(8);
        }
        return objectNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithTrace(@NotNull @NotNull Supplier<? extends @NotNull List<Disposable>> removeFromTreeAction) {
        List<Disposable> disposables;
        boolean needTrace;
        if (removeFromTreeAction == null) {
            ObjectTree.$$$reportNull$$$0(9);
        }
        boolean bl = needTrace = Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
        if (needTrace) {
            ourTopmostDisposeTrace.set(ThrowableInterner.intern(new Throwable()));
        }
        Object object = this.treeLock;
        synchronized (object) {
            disposables = removeFromTreeAction.get();
        }
        SmartList<Throwable> exceptions = null;
        for (int i = disposables.size() - 1; i >= 0; --i) {
            Disposable disposable = disposables.get(i);
            if (!(disposable instanceof Disposable.Parent)) continue;
            try {
                ((Disposable.Parent)disposable).beforeTreeDispose();
                continue;
            }
            catch (Throwable t) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(t);
            }
        }
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList();
                }
                exceptions.add(e);
            }
        }
        if (needTrace) {
            ourTopmostDisposeTrace.remove();
        }
        if (exceptions != null) {
            ObjectTree.handleExceptions(exceptions);
        }
    }

    void executeAll(@NotNull Disposable object, boolean processUnregistered) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(11);
        }
        this.runWithTrace(() -> {
            ObjectNode node = this.getNode(object);
            if (node == null && !processUnregistered) {
                return Collections.emptyList();
            }
            ArrayList<Disposable> disposables = new ArrayList<Disposable>();
            if (node == null) {
                if (this.rememberDisposedTrace(object) == null) {
                    disposables.add(object);
                }
            } else {
                node.getAndRemoveRecursively(disposables);
            }
            return disposables;
        });
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            ObjectTree.$$$reportNull$$$0(12);
        }
        if (!exceptions.isEmpty()) {
            for (Throwable throwable : exceptions) {
                if (throwable instanceof ProcessCanceledException) continue;
                ObjectTree.getLogger().error(throwable);
            }
            ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ObjectTree.class);
        if (logger == null) {
            ObjectTree.$$$reportNull$$$0(14);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object rememberDisposedTrace(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(15);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            return this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObjectFromTree(@NotNull ObjectNode node) {
        if (node == null) {
            ObjectTree.$$$reportNull$$$0(18);
        }
        Object object = this.treeLock;
        synchronized (object) {
            Disposable myObject = node.getObject();
            this.putNode(myObject, null);
            ObjectNode parent2 = node.getParent();
            if (parent2 == null) {
                this.myRootObjects.remove(myObject);
            } else {
                parent2.removeChild(node);
            }
            node.myParent = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeFromTreeAction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeFor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkWasNotAddedAlready";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNodeFor";
                break;
            }
            case 8: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWithTrace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAllChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAll";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleExceptions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferenceKeptInTree";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rememberDisposedTrace";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeObjectFromTree";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

