/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.base.Preconditions;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;

public enum ConfigurationRolesForMigration implements ConfigurationRole
{
    LEGACY_TO_INTENDED_RESOLVABLE_BUCKET(ConfigurationRoles.LEGACY, ConfigurationRoles.INTENDED_RESOLVABLE_BUCKET),
    LEGACY_TO_INTENDED_CONSUMABLE(ConfigurationRoles.LEGACY, ConfigurationRoles.INTENDED_CONSUMABLE),
    INTENDED_RESOLVABLE_BUCKET_TO_INTENDED_RESOLVABLE(ConfigurationRoles.INTENDED_RESOLVABLE_BUCKET, ConfigurationRoles.INTENDED_RESOLVABLE),
    INTENDED_CONSUMABLE_BUCKET_TO_INTENDED_CONSUMABLE(ConfigurationRoles.INTENDED_CONSUMABLE_BUCKET, ConfigurationRoles.INTENDED_CONSUMABLE);

    private final boolean consumable;
    private final boolean resolvable;
    private final boolean declarableAgainst;
    private final boolean consumptionDeprecated;
    private final boolean resolutionDeprecated;
    private final boolean declarationAgainstDeprecated;
    private final ConfigurationRole initialRole;
    private final ConfigurationRole eventualRole;

    private ConfigurationRolesForMigration(ConfigurationRoles initialRole, ConfigurationRoles eventualRole) {
        Preconditions.checkArgument((!initialRole.isConsumptionDeprecated() && !initialRole.isResolutionDeprecated() && !initialRole.isDeclarationAgainstDeprecated() ? 1 : 0) != 0, (Object)"The initial role must not contain deprecated usages.");
        this.consumable = initialRole.isConsumable();
        this.resolvable = initialRole.isResolvable();
        this.declarableAgainst = initialRole.isDeclarableAgainst();
        this.consumptionDeprecated = initialRole.isConsumable() && !eventualRole.isConsumable();
        this.resolutionDeprecated = initialRole.isResolvable() && !eventualRole.isResolvable();
        this.declarationAgainstDeprecated = initialRole.isDeclarableAgainst() && !eventualRole.isDeclarableAgainst();
        this.initialRole = initialRole;
        this.eventualRole = eventualRole;
    }

    @Override
    public String getName() {
        return this.initialRole.getName();
    }

    @Override
    public boolean isConsumable() {
        return this.consumable;
    }

    @Override
    public boolean isResolvable() {
        return this.resolvable;
    }

    @Override
    public boolean isDeclarableAgainst() {
        return this.declarableAgainst;
    }

    @Override
    public boolean isConsumptionDeprecated() {
        return this.consumptionDeprecated;
    }

    @Override
    public boolean isResolutionDeprecated() {
        return this.resolutionDeprecated;
    }

    @Override
    public boolean isDeclarationAgainstDeprecated() {
        return this.declarationAgainstDeprecated;
    }
}

