/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.ToPlannedNodeConverter;
import org.gradle.initialization.DefaultPlannedTask;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;
import org.gradle.internal.taskgraph.NodeIdentity;

public class ToPlannedTaskConverter
implements ToPlannedNodeConverter {
    @Override
    public Class<? extends Node> getSupportedNodeType() {
        return TaskNode.class;
    }

    public CalculateTaskGraphBuildOperationType.TaskIdentity getNodeIdentity(Node node) {
        TaskNode taskNode = (TaskNode)node;
        final TaskIdentity<?> delegate = taskNode.getTask().getTaskIdentity();
        return new CalculateTaskGraphBuildOperationType.TaskIdentity(){

            public NodeIdentity.NodeType getNodeType() {
                return NodeIdentity.NodeType.TASK;
            }

            public String getBuildPath() {
                return delegate.getBuildPath();
            }

            public String getTaskPath() {
                return delegate.getTaskPath();
            }

            public long getTaskId() {
                return delegate.getId();
            }

            public String toString() {
                return "Task " + delegate.getIdentityPath();
            }
        };
    }

    @Override
    public boolean isInSamePlan(Node node) {
        return node instanceof LocalTaskNode;
    }

    public CalculateTaskGraphBuildOperationType.PlannedTask convert(Node node, ToPlannedNodeConverter.DependencyLookup dependencyLookup) {
        if (!this.isInSamePlan(node)) {
            throw new IllegalArgumentException("Cannot convert task from another plan: " + node);
        }
        LocalTaskNode taskNode = (LocalTaskNode)node;
        List<? extends NodeIdentity> nodeDependencies = dependencyLookup.findNodeDependencies(taskNode);
        List<CalculateTaskGraphBuildOperationType.TaskIdentity> taskDependencies = dependencyLookup.findTaskDependencies(taskNode);
        return new DefaultPlannedTask(this.getNodeIdentity(taskNode), nodeDependencies, taskDependencies, this.getTaskIdentities(taskNode.getMustSuccessors()), this.getTaskIdentities(taskNode.getShouldSuccessors()), this.getTaskIdentities(taskNode.getFinalizers()));
    }

    private List<CalculateTaskGraphBuildOperationType.TaskIdentity> getTaskIdentities(Collection<Node> nodes) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return nodes.stream().filter(TaskNode.class::isInstance).map(TaskNode.class::cast).map(this::getNodeIdentity).collect(Collectors.toList());
    }

    public String toString() {
        return "ToPlannedTaskConverter(" + this.getSupportedNodeType().getSimpleName() + ")";
    }
}

