/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.cache.Cache;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterExecutionState;

public interface ExecutionEngine {
    public Request createRequest(UnitOfWork var1);

    public static enum ExecutionOutcome {
        UP_TO_DATE,
        FROM_CACHE,
        SHORT_CIRCUITED,
        EXECUTED_INCREMENTALLY,
        EXECUTED_NON_INCREMENTALLY;

    }

    public static interface Execution {
        public ExecutionOutcome getOutcome();

        @Nullable
        public Object getOutput();
    }

    public static interface Result {
        public Try<Execution> getExecution();

        public CachingState getCachingState();

        public ImmutableList<String> getExecutionReasons();

        public Optional<OriginMetadata> getReusedOutputOriginMetadata();

        @VisibleForTesting
        public Optional<AfterExecutionState> getAfterExecutionState();
    }

    public static interface Request {
        public void forceNonIncremental(String var1);

        public void withValidationContext(WorkValidationContext var1);

        public Result execute();

        public <T> Deferrable<Try<T>> executeDeferred(Cache<UnitOfWork.Identity, Try<T>> var1);
    }
}

