/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilder;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.util.internal.TextUtil;

public class DefaultJvmVariantBuilder
implements JvmVariantBuilder {
    private final String name;
    private final SourceSet sourceSet;
    private final JvmPluginServices jvmPluginServices;
    private final RoleBasedConfigurationContainerInternal configurations;
    private final TaskContainer tasks;
    private final SoftwareComponentContainer components;
    private final ProjectInternal project;
    private String displayName;
    private boolean javadocJar;
    private boolean sourcesJar;
    private boolean published;
    private boolean overrideDefaultCapability = true;
    private final List<Capability> capabilities = Lists.newArrayListWithExpectedSize((int)2);

    @Inject
    public DefaultJvmVariantBuilder(String name, SourceSet sourceSet, Capability defaultCapability, JvmPluginServices jvmPluginServices, ConfigurationContainer configurations, TaskContainer tasks, SoftwareComponentContainer components, ProjectInternal project) {
        this.name = name;
        this.sourceSet = sourceSet;
        this.jvmPluginServices = jvmPluginServices;
        this.configurations = (RoleBasedConfigurationContainerInternal)configurations;
        this.tasks = tasks;
        this.components = components;
        this.project = project;
        this.capabilities.add(defaultCapability);
    }

    @Override
    public JvmVariantBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public JvmVariantBuilder withJavadocJar() {
        this.javadocJar = true;
        return this;
    }

    @Override
    public JvmVariantBuilder withSourcesJar() {
        this.sourcesJar = true;
        return this;
    }

    @Override
    public JvmVariantBuilder capability(Capability capability) {
        if (capability.getVersion() == null) {
            throw new InvalidUserDataException("Capabilities declared on outgoing variants must have a version");
        }
        if (this.overrideDefaultCapability) {
            this.capabilities.clear();
            this.overrideDefaultCapability = false;
        }
        this.capabilities.add(capability);
        return this;
    }

    @Override
    public JvmVariantBuilder distinctCapability() {
        return this.capability((Capability)new ProjectDerivedCapability((Project)this.project, this.name));
    }

    @Override
    public JvmVariantBuilder published() {
        this.published = true;
        return this;
    }

    void build() {
        String runtimeOnlyConfigurationName;
        String compileOnlyApiConfigurationName;
        String compileOnlyConfigurationName;
        String runtimeElementsConfigurationName;
        String apiElementsConfigurationName;
        String implementationConfigurationName;
        String apiConfigurationName;
        boolean mainSourceSet = SourceSet.isMain((SourceSet)this.sourceSet);
        if (mainSourceSet) {
            apiConfigurationName = this.name + "Api";
            implementationConfigurationName = this.name + "Implementation";
            apiElementsConfigurationName = apiConfigurationName + "Elements";
            runtimeElementsConfigurationName = this.name + "RuntimeElements";
            compileOnlyConfigurationName = this.name + "CompileOnly";
            compileOnlyApiConfigurationName = this.name + "CompileOnlyApi";
            runtimeOnlyConfigurationName = this.name + "RuntimeOnly";
        } else {
            apiConfigurationName = this.sourceSet.getApiConfigurationName();
            implementationConfigurationName = this.sourceSet.getImplementationConfigurationName();
            apiElementsConfigurationName = this.sourceSet.getApiElementsConfigurationName();
            runtimeElementsConfigurationName = this.sourceSet.getRuntimeElementsConfigurationName();
            compileOnlyConfigurationName = this.sourceSet.getCompileOnlyConfigurationName();
            compileOnlyApiConfigurationName = this.sourceSet.getCompileOnlyApiConfigurationName();
            runtimeOnlyConfigurationName = this.sourceSet.getRuntimeOnlyConfigurationName();
        }
        String displayName = this.displayName == null ? this.name : this.displayName;
        Configuration implementation = this.bucket("Implementation", implementationConfigurationName, displayName);
        Configuration compileOnly = this.bucket("Compile-Only", compileOnlyConfigurationName, displayName);
        Configuration compileOnlyApi = this.bucket("Compile-Only API", compileOnlyApiConfigurationName, displayName);
        Configuration runtimeOnly = this.bucket("Runtime-Only", runtimeOnlyConfigurationName, displayName);
        TaskProvider<Task> jarTask = this.registerOrGetJarTask(this.sourceSet, displayName);
        Configuration api = this.bucket("API", apiConfigurationName, displayName);
        implementation.extendsFrom(new Configuration[]{api});
        ConfigurationRole elementsRole = ConfigurationRole.forUsage((boolean)true, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
        TaskProvider compileJava = this.tasks.named(this.sourceSet.getCompileJavaTaskName(), JavaCompile.class);
        Configuration apiElements = this.configurations.maybeCreateWithRole(apiElementsConfigurationName, elementsRole, false, false);
        apiElements.setVisible(false);
        this.jvmPluginServices.useDefaultTargetPlatformInference(apiElements, compileJava);
        this.jvmPluginServices.configureAsApiElements((HasConfigurableAttributes<?>)apiElements);
        apiElements.setDescription("API elements for " + displayName);
        apiElements.extendsFrom(new Configuration[]{api, compileOnlyApi});
        this.capabilities.forEach(arg_0 -> ((ConfigurationPublications)apiElements.getOutgoing()).capability(arg_0));
        this.jvmPluginServices.configureClassesDirectoryVariant(apiElements, this.sourceSet);
        apiElements.getOutgoing().artifact(jarTask);
        Configuration runtimeElements = this.configurations.maybeCreateWithRole(runtimeElementsConfigurationName, elementsRole, false, false);
        runtimeElements.setVisible(false);
        this.jvmPluginServices.useDefaultTargetPlatformInference(runtimeElements, compileJava);
        this.jvmPluginServices.configureAsRuntimeElements((HasConfigurableAttributes<?>)runtimeElements);
        runtimeElements.setDescription("Runtime elements for " + displayName);
        runtimeElements.extendsFrom(new Configuration[]{implementation, runtimeOnly});
        this.capabilities.forEach(arg_0 -> ((ConfigurationPublications)runtimeElements.getOutgoing()).capability(arg_0));
        runtimeElements.getOutgoing().artifact(jarTask);
        if (mainSourceSet) {
            this.configurations.getByName(this.sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{implementation, compileOnly});
            this.configurations.getByName(this.sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{implementation, runtimeOnly});
            this.configurations.getByName("testCompileClasspath").extendsFrom(new Configuration[]{implementation, compileOnlyApi});
            this.configurations.getByName("testRuntimeClasspath").extendsFrom(new Configuration[]{implementation, runtimeOnly});
        }
        AdhocComponentWithVariants component = this.findJavaComponent();
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.project.getExtensions().findByType(JavaPluginExtension.class);
        JvmPluginsHelper.configureJavaDocTask(this.name, this.sourceSet, this.tasks, javaPluginExtension);
        if (this.javadocJar) {
            Configuration javadocVariant = JvmPluginsHelper.createDocumentationVariantWithArtifact(this.sourceSet.getJavadocElementsConfigurationName(), mainSourceSet ? null : this.name, "javadoc", this.capabilities, this.sourceSet.getJavadocJarTaskName(), this.tasks.named(this.sourceSet.getJavadocTaskName()), this.project);
            if (component != null) {
                component.addVariantsFromConfiguration(javadocVariant, (Action)new JavaConfigurationVariantMapping("runtime", true));
            }
        }
        if (this.sourcesJar) {
            Configuration sourcesVariant = JvmPluginsHelper.createDocumentationVariantWithArtifact(this.sourceSet.getSourcesElementsConfigurationName(), mainSourceSet ? null : this.name, "sources", this.capabilities, this.sourceSet.getSourcesJarTaskName(), this.sourceSet.getAllSource(), this.project);
            if (component != null) {
                component.addVariantsFromConfiguration(sourcesVariant, (Action)new JavaConfigurationVariantMapping("runtime", true));
            }
        }
        if (this.published && component != null) {
            component.addVariantsFromConfiguration(apiElements, (Action)new JavaConfigurationVariantMapping("compile", true));
            component.addVariantsFromConfiguration(runtimeElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    private Configuration bucket(String kind, String configName, String displayName) {
        Configuration configuration = this.configurations.maybeCreateWithRole(configName, (ConfigurationRole)ConfigurationRoles.INTENDED_BUCKET, false, false);
        configuration.setDescription(kind + " dependencies for " + displayName);
        configuration.setVisible(false);
        return configuration;
    }

    private TaskProvider<Task> registerOrGetJarTask(SourceSet sourceSet, String displayName) {
        String jarTaskName = sourceSet.getJarTaskName();
        if (!this.tasks.getNames().contains(jarTaskName)) {
            this.tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the classes of the '" + displayName + "'.");
                jar.setGroup("build");
                jar.from(new Object[]{sourceSet.getOutput()});
                jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)this.name));
            });
        }
        return this.tasks.named(jarTaskName);
    }

    @Nullable
    public AdhocComponentWithVariants findJavaComponent() {
        SoftwareComponent component = (SoftwareComponent)this.components.findByName("java");
        if (component instanceof AdhocComponentWithVariants) {
            return (AdhocComponentWithVariants)component;
        }
        return null;
    }
}

