/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.TraceBasedCollector;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkContractAndRecordIfPresent", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkFeatureEnabled", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "parseContractAndReportErrors", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "isContractDescriptionCallPreciseCheck", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nContractParsingServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractParsingServices.kt\norg/jetbrains/kotlin/contracts/parsing/ContractParsingServices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class ContractParsingServices {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final StorageManager storageManager;

    public ContractParsingServices(@NotNull LanguageVersionSettings languageVersionSettings2, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.languageVersionSettings = languageVersionSettings2;
        this.storageManager = storageManager;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkContractAndRecordIfPresent(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull FunctionDescriptor ownerDescriptor) {
        ContractDescription resultingContractDescription;
        LazyContractProvider contractProviderIfAny;
        ContractCallContext callContext;
        block7: {
            LazyContractProvider lazyContractProvider;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)ownerDescriptor, (String)"ownerDescriptor");
            if (!KtPsiUtilKt.isContractDescriptionCallPsiCheck(expression2)) {
                return;
            }
            callContext = new ContractCallContext(expression2, ownerDescriptor, trace, this.languageVersionSettings);
            Object v = ownerDescriptor.getUserData(ContractProviderKey.INSTANCE);
            contractProviderIfAny = v instanceof LazyContractProvider ? (LazyContractProvider)v : null;
            resultingContractDescription = null;
            try {
                if (this.isContractDescriptionCallPreciseCheck(callContext)) break block7;
                lazyContractProvider = contractProviderIfAny;
            }
            catch (Throwable throwable) {
                LazyContractProvider lazyContractProvider2 = contractProviderIfAny;
                if (lazyContractProvider2 != null) {
                    lazyContractProvider2.setContractDescription(resultingContractDescription);
                }
                throw throwable;
            }
            if (lazyContractProvider != null) {
                lazyContractProvider.setContractDescription(resultingContractDescription);
            }
            return;
        }
        resultingContractDescription = this.parseContractAndReportErrors(callContext);
        LazyContractProvider lazyContractProvider = contractProviderIfAny;
        if (lazyContractProvider != null) {
            lazyContractProvider.setContractDescription(resultingContractDescription);
        }
    }

    private final boolean isContractDescriptionCallPreciseCheck(ContractCallContext $this$isContractDescriptionCallPreciseCheck) {
        return this.isContractDescriptionCallPreciseCheck($this$isContractDescriptionCallPreciseCheck.getContractCallExpression(), $this$isContractDescriptionCallPreciseCheck.getBindingContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ContractDescription parseContractAndReportErrors(ContractCallContext callContext) {
        TraceBasedCollector collector2 = new TraceBasedCollector(callContext);
        try {
            ContractDescription contractDescription;
            ContractDescription contractDescription2;
            this.checkFeatureEnabled(collector2);
            boolean contractNotAllowed = Intrinsics.areEqual(callContext.getBindingContext().get(BindingContext.CONTRACT_NOT_ALLOWED, callContext.getContractCallExpression()), (Object)true);
            if (collector2.hasErrors() || contractNotAllowed) {
                ContractDescription contractDescription3 = null;
                return contractDescription3;
            }
            ContractDescription parsedContract = new PsiContractParserDispatcher(collector2, callContext, this.storageManager).parseContract();
            if (parsedContract == null) {
                collector2.addFallbackErrorIfNecessary();
            }
            ContractDescription contractDescription4 = parsedContract;
            if (contractDescription4 != null) {
                ContractDescription it = contractDescription2 = contractDescription4;
                boolean bl = false;
                contractDescription = !collector2.hasErrors() ? contractDescription2 : null;
            } else {
                contractDescription = null;
            }
            contractDescription2 = contractDescription;
            return contractDescription2;
        }
        finally {
            collector2.flushDiagnostics();
        }
    }

    private final void checkFeatureEnabled(ContractParsingDiagnosticsCollector collector2) {
        boolean isFeatureTurnedOn = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions);
        if (!isFeatureTurnedOn) {
            collector2.unsupportedFeature(this.languageVersionSettings);
        }
    }

    private final boolean isContractDescriptionCallPreciseCheck(KtExpression $this$isContractDescriptionCallPreciseCheck, BindingContext context2) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$isContractDescriptionCallPreciseCheck, context2);
        return resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? PsiContractsUtilsKt.isContractCallDescriptor((DeclarationDescriptor)((Object)resolvedCall2)) : false;
    }
}

