/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.JsInteropFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#H\u0002J(\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020#H\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0019J\u000e\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020\u0019J\u000e\u00102\u001a\u00020.2\u0006\u00101\u001a\u00020\u0019J\u0010\u00103\u001a\u00020.2\u0006\u00104\u001a\u00020\rH\u0016J\u000e\u00105\u001a\u00020.2\u0006\u00101\u001a\u00020\u0019J\u000e\u00106\u001a\u00020.2\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\u0007J\u000e\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020.2\u0006\u0010(\u001a\u00020\u0015J.\u0010?\u001a\u00020.2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020%2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020#J\u0010\u0010B\u001a\u00020#2\u0006\u0010:\u001a\u00020CH\u0002J\u0018\u0010D\u001a\u00020.*\u00060Ej\u0002`F2\u0006\u00101\u001a\u00020\u0019H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0018\u0010\u001b\u001a\u00020\u001c*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0018\u0010\u001e\u001a\u00020\u001c*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001d\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "addedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getAddedDeclarations", "()Ljava/util/List;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCurrentFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "setCurrentFile", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "externalFunToTopLevelMapping", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getExternalFunToTopLevelMapping", "()Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "externalObjectToGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getExternalObjectToGetInstanceFunction", "isGetOperator", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isSetOperator", "createExternalJsFunction", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "suffix", "", "resultType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "jsCode", "createJsCodeForFunction", "function", "numDefaultParameters", "", "isConstructor", "jsFunctionReference", "generateExternalObjectInstanceGetter", "", "obj", "generateGetClassForExternalClass", "klass", "generateInstanceCheckForExternalClass", "lower", "irFile", "lowerExternalClass", "processExternalConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "processExternalDeclaration", "declaration", "processExternalProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "processExternalSimpleFunction", "processFunctionOrConstructor", "name", "returnType", "referenceTopLevelExternalDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "appendExternalClassReference", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,547:1\n1#2:548\n1726#3,3:549\n1855#3,2:552\n*S KotlinDebug\n*F\n+ 1 ComplexExternalDeclarationsToTopLevelFunctionsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsToTopLevelFunctionsLowering\n*L\n218#1:549,3\n340#1:552,2\n*E\n"})
public final class ComplexExternalDeclarationsToTopLevelFunctionsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    public IrFile currentFile;
    @NotNull
    private final List<IrDeclaration> addedDeclarations;
    @NotNull
    private final Mapping.Delegate<IrFunction, IrSimpleFunction> externalFunToTopLevelMapping;
    @NotNull
    private final Mapping.Delegate<IrClass, IrSimpleFunction> externalObjectToGetInstanceFunction;

    public ComplexExternalDeclarationsToTopLevelFunctionsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.addedDeclarations = new ArrayList();
        this.externalFunToTopLevelMapping = this.context.getMapping().getWasmNestedExternalToNewTopLevelFunction();
        this.externalObjectToGetInstanceFunction = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFile getCurrentFile() {
        IrFile irFile = this.currentFile;
        if (irFile != null) {
            return irFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentFile");
        return null;
    }

    public final void setCurrentFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"<set-?>");
        this.currentFile = irFile;
    }

    @NotNull
    public final List<IrDeclaration> getAddedDeclarations() {
        return this.addedDeclarations;
    }

    @NotNull
    public final Mapping.Delegate<IrFunction, IrSimpleFunction> getExternalFunToTopLevelMapping() {
        return this.externalFunToTopLevelMapping;
    }

    @NotNull
    public final Mapping.Delegate<IrClass, IrSimpleFunction> getExternalObjectToGetInstanceFunction() {
        return this.externalObjectToGetInstanceFunction;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.setCurrentFile(irFile);
        for (IrDeclaration declaration : irFile.getDeclarations()) {
            if (!IrUtilsKt.isEffectivelyExternal(declaration)) continue;
            this.processExternalDeclaration(declaration);
        }
        CollectionsKt.addAll((Collection)irFile.getDeclarations(), (Iterable)this.addedDeclarations);
        this.addedDeclarations.clear();
    }

    public final void processExternalDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrVisitorsKt.acceptVoid(declaration, new IrElementVisitorVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsToTopLevelFunctionsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                throw new IllegalStateException(("Unknown external element " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            }

            public void visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrVisitorsKt.acceptChildrenVoid(declaration, this);
                this.this$0.lowerExternalClass(declaration);
            }

            public void visitProperty(@NotNull IrProperty declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.this$0.processExternalProperty(declaration);
            }

            public void visitConstructor(@NotNull IrConstructor declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.this$0.processExternalConstructor(declaration);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.this$0.processExternalSimpleFunction(declaration);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
            }

            public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConst(@NotNull IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
            }

            public void visitField(@NotNull IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        });
    }

    public final void lowerExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.getKind() == ClassKind.OBJECT) {
            this.generateExternalObjectInstanceGetter(klass);
        }
        if (klass.getKind() != ClassKind.INTERFACE) {
            this.generateInstanceCheckForExternalClass(klass);
            this.generateGetClassForExternalClass(klass);
        }
    }

    public final void processExternalProperty(@NotNull IrProperty property) {
        block4: {
            IrSimpleFunction res2;
            String jsCode;
            IrValueParameter dispatchReceiver;
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            if (property.isFakeOverride()) {
                return;
            }
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(property).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
            String propName = string2;
            IrSimpleFunction irSimpleFunction = property.getGetter();
            if (irSimpleFunction != null) {
                IrSimpleFunction getter2 = irSimpleFunction;
                boolean bl = false;
                dispatchReceiver = getter2.getDispatchReceiverParameter();
                jsCode = dispatchReceiver == null ? "() => " + this.referenceTopLevelExternalDeclaration(property) : "(_this) => _this." + propName;
                res2 = this.createExternalJsFunction(property.getName(), "_$external_prop_getter", getter2.getReturnType(), jsCode);
                if (dispatchReceiver != null) {
                    DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
                }
                this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)getter2), res2);
            }
            IrSimpleFunction irSimpleFunction2 = property.getSetter();
            if (irSimpleFunction2 == null) break block4;
            IrSimpleFunction setter2 = irSimpleFunction2;
            boolean bl = false;
            dispatchReceiver = setter2.getDispatchReceiverParameter();
            jsCode = dispatchReceiver == null ? "(v) => " + this.referenceTopLevelExternalDeclaration(property) + " = v" : "(_this, v) => _this." + propName + " = v";
            res2 = this.createExternalJsFunction(property.getName(), "_$external_prop_setter", setter2.getReturnType(), jsCode);
            if (dispatchReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
            }
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "v", setter2.getValueParameters().get(0).getType(), null, 4, null);
            this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)setter2), res2);
        }
    }

    private final void appendExternalClassReference(StringBuilder $this$appendExternalClassReference, IrClass klass) {
        IrDeclarationParent parent2 = klass.getParent();
        if (parent2 instanceof IrClass) {
            if (IrUtilsKt.isInterface((IrClass)parent2)) {
                $this$appendExternalClassReference.append("({})");
                return;
            }
            this.appendExternalClassReference($this$appendExternalClassReference, (IrClass)parent2);
            if (klass.isCompanion()) {
                return;
            }
            $this$appendExternalClassReference.append('.');
            $this$appendExternalClassReference.append(AnnotationUtilsKt.getJsNameOrKotlinName(klass));
        } else {
            $this$appendExternalClassReference.append(this.referenceTopLevelExternalDeclaration(klass));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processExternalConstructor(@NotNull IrConstructor constructor2) {
        void $this$processExternalConstructor_u24lambda_u242;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        IrClass klass = AdditionalIrUtilsKt.getConstructedClass(constructor2);
        if (IrUtilsKt.isInterface(klass)) {
            return;
        }
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
        boolean bl = true;
        IrType irType = IrUtilsKt.getDefaultType(klass);
        Name name2 = klass.getName();
        IrFunction irFunction2 = constructor2;
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        boolean bl2 = false;
        this.appendExternalClassReference((StringBuilder)$this$processExternalConstructor_u24lambda_u242, klass);
        Unit unit2 = Unit.INSTANCE;
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        complexExternalDeclarationsToTopLevelFunctionsLowering2.processFunctionOrConstructor(irFunction2, name2, irType, bl, string2);
    }

    public final void processExternalSimpleFunction(@NotNull IrSimpleFunction function2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (AnnotationsKt.getWasmImportDescriptor(function2) != null) {
            return;
        }
        String jsFun = AnnotationsKt.getJsFunAnnotation(function2);
        if (jsFun != null) {
            boolean bl;
            block11: {
                Iterable $this$all$iv = function2.getValueParameters();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (it.getDefaultValue() == null && it.getVarargElementType() == null) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl && AnnotationUtilsKt.getJsQualifier(this.getCurrentFile()) == null && AnnotationUtilsKt.getJsModule(this.getCurrentFile()) == null) {
                return;
            }
        }
        if (function2.isFakeOverride()) {
            return;
        }
        if (jsFun != null) {
            string2 = '(' + jsFun + ')';
        } else if (AdditionalIrUtilsKt.isTopLevelDeclaration(function2)) {
            string2 = this.referenceTopLevelExternalDeclaration(function2);
        } else {
            String string3 = AnnotationUtilsKt.getJsNameOrKotlinName(function2).getIdentifier();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
        }
        String jsFunctionReference = string2;
        this.processFunctionOrConstructor(function2, function2.getName(), function2.getReturnType(), false, jsFunctionReference);
    }

    private final boolean isSetOperator(IrFunction $this$isSetOperator) {
        return $this$isSetOperator instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isSetOperator).isOperator() && Intrinsics.areEqual((Object)$this$isSetOperator.getName().asString(), (Object)"set");
    }

    private final boolean isGetOperator(IrFunction $this$isGetOperator) {
        return $this$isGetOperator instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isGetOperator).isOperator() && Intrinsics.areEqual((Object)$this$isGetOperator.getName().asString(), (Object)"get");
    }

    private final String createJsCodeForFunction(IrFunction function2, int numDefaultParameters, boolean isConstructor, String jsFunctionReference) {
        int it;
        int n;
        StringBuilder stringBuilder2;
        IrValueParameter dispatchReceiver = function2.getDispatchReceiverParameter();
        int numValueParameters = function2.getValueParameters().size();
        StringBuilder $this$createJsCodeForFunction_u24lambda_u246 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$createJsCodeForFunction_u24lambda_u246.append("(");
        if (dispatchReceiver != null) {
            $this$createJsCodeForFunction_u24lambda_u246.append("_this, ");
        }
        JsInteropFunctionsLoweringKt.appendParameterList$default($this$createJsCodeForFunction_u24lambda_u246, numValueParameters, null, numDefaultParameters == 0, 2, null);
        JsInteropFunctionsLoweringKt.appendParameterList($this$createJsCodeForFunction_u24lambda_u246, numDefaultParameters, "isDefault", true);
        $this$createJsCodeForFunction_u24lambda_u246.append(") => ");
        if (isConstructor) {
            $this$createJsCodeForFunction_u24lambda_u246.append("new ");
        }
        if (dispatchReceiver != null) {
            $this$createJsCodeForFunction_u24lambda_u246.append("_this.");
        }
        $this$createJsCodeForFunction_u24lambda_u246.append(jsFunctionReference);
        $this$createJsCodeForFunction_u24lambda_u246.append("(");
        int numNonDefaultParamters = numValueParameters - numDefaultParameters;
        for (n = 0; n < numNonDefaultParamters; ++n) {
            it = n;
            boolean bl2 = false;
            if (AdditionalIrUtilsKt.isVararg(function2.getValueParameters().get(it))) {
                $this$createJsCodeForFunction_u24lambda_u246.append("...");
            }
            $this$createJsCodeForFunction_u24lambda_u246.append("" + 'p' + it);
            if (numDefaultParameters == 0 && it + 1 >= numNonDefaultParamters) continue;
            $this$createJsCodeForFunction_u24lambda_u246.append(", ");
        }
        for (n = 0; n < numDefaultParameters; ++n) {
            it = n;
            boolean bl3 = false;
            if (AdditionalIrUtilsKt.isVararg(function2.getValueParameters().get(numNonDefaultParamters + it))) {
                $this$createJsCodeForFunction_u24lambda_u246.append("...");
            } else {
                $this$createJsCodeForFunction_u24lambda_u246.append("isDefault" + it + " ? undefined : ");
            }
            $this$createJsCodeForFunction_u24lambda_u246.append("" + 'p' + (numNonDefaultParamters + it) + ", ");
        }
        $this$createJsCodeForFunction_u24lambda_u246.append(")");
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final void processFunctionOrConstructor(@NotNull IrFunction function2, @NotNull Name name2, @NotNull IrType returnType2, boolean isConstructor, @NotNull String jsFunctionReference) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)jsFunctionReference, (String)"jsFunctionReference");
        IrValueParameter dispatchReceiver = function2.getDispatchReceiverParameter();
        int numDefaultParameters = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.access$numDefaultParametersForExternalFunction(function2);
        String jsCode = this.isSetOperator(function2) ? "(_this, i, value) => _this[i] = value" : (this.isGetOperator(function2) ? "(_this, i) => _this[i]" : this.createJsCodeForFunction(function2, numDefaultParameters, isConstructor, jsFunctionReference));
        IrSimpleFunction res2 = this.createExternalJsFunction(name2, "_$external_fun", returnType2, jsCode);
        if (dispatchReceiver != null) {
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "_this", dispatchReceiver.getType(), null, 4, null);
        }
        Iterable $this$forEach$iv = function2.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter irValueParameter;
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            IrValueParameter $this$processFunctionOrConstructor_u24lambda_u248_u24lambda_u247 = irValueParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, it.getName(), it.getType(), null, 4, null);
            boolean bl2 = false;
            $this$processFunctionOrConstructor_u24lambda_u248_u24lambda_u247.setVarargElementType(it.getVarargElementType());
        }
        int n = 0;
        while (n < numDefaultParameters) {
            int it = n++;
            boolean bl = false;
            DeclarationBuildersKt.addValueParameter$default((IrFunction)res2, "isDefault" + it, this.context.getIrBuiltIns().getIntType(), null, 4, null);
        }
        this.externalFunToTopLevelMapping.set((IrFunction)((IrDeclaration)function2), res2);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateExternalObjectInstanceGetter(@NotNull IrClass obj) {
        void $this$generateExternalObjectInstanceGetter_u24lambda_u2410;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
        IrType irType = IrUtilsKt.getDefaultType(obj);
        String string2 = "_$external_object_getInstance";
        Name name2 = obj.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrDeclaration irDeclaration2 = obj;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate2 = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
        boolean bl = false;
        $this$generateExternalObjectInstanceGetter_u24lambda_u2410.append("() => ");
        this.appendExternalClassReference((StringBuilder)$this$generateExternalObjectInstanceGetter_u24lambda_u2410, obj);
        Unit unit2 = Unit.INSTANCE;
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        delegate2.set((IrClass)irDeclaration2, complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string2, irType, string3));
    }

    /*
     * WARNING - void declaration
     */
    public final void generateInstanceCheckForExternalClass(@NotNull IrClass klass) {
        void it;
        Object $this$generateInstanceCheckForExternalClass_u24lambda_u2411;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Object object = new StringBuilder();
        StringBuilder stringBuilder2 = object;
        IrType irType = this.context.getIrBuiltIns().getBooleanType();
        String string2 = "_$external_class_instanceof";
        Name name2 = klass.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrDeclaration irDeclaration2 = klass;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate2 = this.context.getMapping().getWasmExternalClassToInstanceCheck();
        boolean bl = false;
        String jsPrimitiveType = AnnotationsKt.getJsPrimitiveType(klass);
        if (jsPrimitiveType != null) {
            ((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2411).append("(x) => typeof x === '" + jsPrimitiveType + '\'');
        } else {
            ((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2411).append("(x) => x instanceof ");
            this.appendExternalClassReference((StringBuilder)$this$generateInstanceCheckForExternalClass_u24lambda_u2411, klass);
        }
        Unit unit2 = Unit.INSTANCE;
        String string3 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        $this$generateInstanceCheckForExternalClass_u24lambda_u2411 = object = complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string2, irType, string3);
        boolean bl2 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)it, "x", this.context.getIrBuiltIns().getAnyType(), null, 4, null);
        complexExternalDeclarationsToTopLevelFunctionsLowering2 = Unit.INSTANCE;
        delegate2.set((IrClass)irDeclaration2, (IrSimpleFunction)object);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateGetClassForExternalClass(@NotNull IrClass klass) {
        void $this$generateGetClassForExternalClass_u24lambda_u2413;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
        IrType irType = IrTypesKt.makeNullable(this.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType());
        String string2 = "_$external_class_get";
        Name name2 = klass.getName();
        ComplexExternalDeclarationsToTopLevelFunctionsLowering complexExternalDeclarationsToTopLevelFunctionsLowering2 = this;
        IrDeclaration irDeclaration2 = klass;
        Mapping.Delegate<IrClass, IrSimpleFunction> delegate2 = this.context.getMapping().getWasmGetJsClass();
        boolean bl = false;
        $this$generateGetClassForExternalClass_u24lambda_u2413.append("() => ");
        this.appendExternalClassReference((StringBuilder)$this$generateGetClassForExternalClass_u24lambda_u2413, klass);
        Unit unit2 = Unit.INSTANCE;
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        delegate2.set((IrClass)irDeclaration2, complexExternalDeclarationsToTopLevelFunctionsLowering2.createExternalJsFunction(name2, string2, irType, string3));
    }

    private final IrSimpleFunction createExternalJsFunction(Name originalName, String suffix, IrType resultType, String jsCode) {
        IrSimpleFunction res2 = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this.context, originalName, suffix, resultType, jsCode);
        res2.setParent(this.getCurrentFile());
        ((Collection)this.addedDeclarations).add(res2);
        return res2;
    }

    private final String referenceTopLevelExternalDeclaration(IrDeclarationWithName declaration) {
        String string2;
        String string3;
        String module2;
        String it;
        String name2 = null;
        name2 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).getIdentifier();
        String qualifier2 = AnnotationUtilsKt.getJsQualifier(this.getCurrentFile());
        String string4 = AnnotationUtilsKt.getJsModule(this.getCurrentFile());
        if (string4 == null) {
            String string5 = AnnotationUtilsKt.getJsModule(declaration);
            if (string5 != null) {
                String string6;
                it = string6 = string5;
                boolean bl = false;
                name2 = declaration instanceof IrClass && IrUtilsKt.isObject((IrClass)declaration) ? null : "default";
                string4 = string6;
            } else {
                string4 = module2 = null;
            }
        }
        if (qualifier2 == null && module2 == null) {
            String string7 = name2;
            Intrinsics.checkNotNull((Object)string7);
            return string7;
        }
        JsModuleAndQualifierReference qualifieReference = new JsModuleAndQualifierReference(module2, qualifier2);
        ((Collection)this.context.getJsModuleAndQualifierReferences()).add(qualifieReference);
        StringBuilder stringBuilder2 = new StringBuilder().append(qualifieReference.getJsVariableName());
        String string8 = name2;
        if (string8 != null) {
            it = string8;
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl = false;
            string3 = '.' + it;
            stringBuilder2 = stringBuilder3;
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = "";
        }
        return stringBuilder2.append(string2).toString();
    }
}

