/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.internal.CacheCleanupBuildOperationType;
import org.gradle.cache.internal.CacheCleanupExecutor;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheCleanupExecutor
implements CacheCleanupExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheCleanupExecutor.class);
    private final CleanableStore cleanableStore;
    private final File gcFile;
    private final CacheCleanupStrategy cacheCleanupStrategy;
    private final BuildOperationRunner buildOperationRunner;

    public DefaultCacheCleanupExecutor(CleanableStore cleanableStore, File gcFile, CacheCleanupStrategy cacheCleanupStrategy, BuildOperationRunner buildOperationRunner) {
        this.cleanableStore = cleanableStore;
        this.gcFile = gcFile;
        this.cacheCleanupStrategy = cacheCleanupStrategy;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public void cleanup() {
        this.getLastCleanupTime().ifPresent(this::performCleanupIfNecessary);
    }

    private void performCleanupIfNecessary(final Instant lastCleanupTime) {
        if (LOGGER.isDebugEnabled()) {
            Duration timeSinceLastCleanup = Duration.between(lastCleanupTime, Instant.now());
            LOGGER.debug("{} has last been fully cleaned up {} hours ago", (Object)this.cleanableStore.getDisplayName(), (Object)timeSinceLastCleanup.toHours());
        }
        if (!this.cacheCleanupStrategy.getCleanupFrequency().requiresCleanup(lastCleanupTime)) {
            LOGGER.debug("Skipping cleanup for {} as it is not yet due", (Object)this.cleanableStore.getDisplayName());
            return;
        }
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                DefaultCleanupProgressMonitor progressMonitor = new DefaultCleanupProgressMonitor(context);
                Timer timer = Time.startTimer();
                try {
                    DefaultCacheCleanupExecutor.this.cacheCleanupStrategy.getCleanupAction().clean(DefaultCacheCleanupExecutor.this.cleanableStore, progressMonitor);
                    FileUtils.touch((File)DefaultCacheCleanupExecutor.this.gcFile);
                    LOGGER.info("{} cleaned up in {}.", (Object)DefaultCacheCleanupExecutor.this.cleanableStore.getDisplayName(), (Object)timer.getElapsed());
                    context.setResult((Object)new CacheCleanupResult(progressMonitor.getDeleted(), lastCleanupTime));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Clean up " + DefaultCacheCleanupExecutor.this.cleanableStore.getDisplayName())).details((Object)new CacheCleanupDetails(DefaultCacheCleanupExecutor.this.cleanableStore.getBaseDir()));
            }
        });
    }

    private Optional<Instant> getLastCleanupTime() {
        if (this.cacheCleanupStrategy == CacheCleanupStrategy.NO_CLEANUP) {
            return Optional.empty();
        }
        File dir = this.cleanableStore.getBaseDir();
        if (!dir.exists()) {
            return Optional.empty();
        }
        if (!this.gcFile.exists()) {
            try {
                FileUtils.touch((File)this.gcFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(this.gcFile.lastModified()));
    }

    private static class CacheCleanupResult
    implements CacheCleanupBuildOperationType.Result {
        private final long deletedEntriesCount;
        private final Instant previousCleanupTime;

        private CacheCleanupResult(long deletedEntriesCount, Instant previousCleanupTime) {
            this.deletedEntriesCount = deletedEntriesCount;
            this.previousCleanupTime = previousCleanupTime;
        }

        @Override
        public long getDeletedEntriesCount() {
            return this.deletedEntriesCount;
        }

        @Override
        public Instant getPreviousCleanupTime() {
            return this.previousCleanupTime;
        }
    }

    private static class CacheCleanupDetails
    implements CacheCleanupBuildOperationType.Details {
        private final File cacheLocation;

        public CacheCleanupDetails(File cacheLocation) {
            this.cacheLocation = cacheLocation;
        }

        @Override
        public File getCacheLocation() {
            return this.cacheLocation;
        }
    }
}

