/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.VariantIdentityUniquenessVerifier;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalVariantMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.local.model.DefaultLocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.VariantMetadataFactory;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class LocalComponentGraphResolveStateFactory {
    private final AttributeDesugaring attributeDesugaring;
    private final ComponentIdGenerator idGenerator;
    private final LocalVariantMetadataBuilder metadataBuilder;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public LocalComponentGraphResolveStateFactory(AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, LocalVariantMetadataBuilder metadataBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.attributeDesugaring = attributeDesugaring;
        this.idGenerator = idGenerator;
        this.metadataBuilder = metadataBuilder;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    public LocalComponentGraphResolveState realizedStateFor(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, String status, AttributesSchemaInternal schema, List<? extends LocalVariantGraphResolveMetadata> variants) {
        VariantsListMetadataFactory configurationFactory = new VariantsListMetadataFactory(variants);
        return this.createLocalComponentState(componentIdentifier, moduleVersionId, status, schema, false, configurationFactory);
    }

    public LocalComponentGraphResolveState stateFor(ModelContainer<?> model, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, ConfigurationsProvider configurations, String status, AttributesSchemaInternal schema) {
        return this.lazyStateFor(model, componentIdentifier, configurations, moduleVersionId, status, schema, false);
    }

    public LocalComponentGraphResolveState adHocStateFor(ModelContainer<?> model, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, ConfigurationsProvider configurations, String status, AttributesSchemaInternal schema) {
        return this.lazyStateFor(model, componentIdentifier, configurations, moduleVersionId, status, schema, true);
    }

    private LocalComponentGraphResolveState lazyStateFor(ModelContainer<?> model, ComponentIdentifier componentIdentifier, ConfigurationsProvider configurations, ModuleVersionIdentifier moduleVersionId, String status, AttributesSchemaInternal schema, boolean adHoc) {
        ConfigurationsProviderMetadataFactory variantsFactory = new ConfigurationsProviderMetadataFactory(componentIdentifier, configurations, this.metadataBuilder, model, this.calculatedValueContainerFactory);
        return this.createLocalComponentState(componentIdentifier, moduleVersionId, status, schema, adHoc, variantsFactory);
    }

    private DefaultLocalComponentGraphResolveState createLocalComponentState(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionId, String status, AttributesSchemaInternal schema, boolean adHoc, VariantMetadataFactory variantsFactory) {
        LocalComponentGraphResolveMetadata metadata = new LocalComponentGraphResolveMetadata(moduleVersionId, componentIdentifier, status, schema);
        return new DefaultLocalComponentGraphResolveState(this.idGenerator.nextComponentId(), metadata, this.attributeDesugaring, this.idGenerator, adHoc, variantsFactory, this.calculatedValueContainerFactory, null);
    }

    private static class ConfigurationsProviderMetadataFactory
    implements VariantMetadataFactory {
        private final ComponentIdentifier componentId;
        private final ConfigurationsProvider configurationsProvider;
        private final LocalVariantMetadataBuilder metadataBuilder;
        private final ModelContainer<?> model;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final LocalVariantMetadataBuilder.DependencyCache cache;

        public ConfigurationsProviderMetadataFactory(ComponentIdentifier componentId, ConfigurationsProvider configurationsProvider, LocalVariantMetadataBuilder metadataBuilder, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.componentId = componentId;
            this.configurationsProvider = configurationsProvider;
            this.metadataBuilder = metadataBuilder;
            this.model = model;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
            this.cache = new LocalVariantMetadataBuilder.DependencyCache();
        }

        @Override
        public void visitConsumableVariants(Consumer<LocalVariantGraphResolveMetadata> visitor) {
            this.model.applyToMutableState(p -> {
                VariantIdentityUniquenessVerifier.buildReport(this.configurationsProvider).assertNoConflicts();
                this.configurationsProvider.visitAll(configuration -> {
                    if (configuration.isCanBeConsumed()) {
                        visitor.accept(this.createVariantMetadata((ConfigurationInternal)configuration));
                    }
                });
            });
        }

        @Override
        public void invalidate() {
            this.cache.invalidate();
        }

        @Override
        @Nullable
        public LocalVariantGraphResolveMetadata getVariantByConfigurationName(String name) {
            return (LocalVariantGraphResolveMetadata)this.model.fromMutableState(p -> {
                ConfigurationInternal configuration = this.configurationsProvider.findByName(name);
                if (configuration == null) {
                    return null;
                }
                return this.createVariantMetadata(configuration);
            });
        }

        private LocalVariantGraphResolveMetadata createVariantMetadata(ConfigurationInternal configuration) {
            return this.metadataBuilder.create(configuration, this.configurationsProvider, this.componentId, this.cache, this.model, this.calculatedValueContainerFactory);
        }
    }

    private static class VariantsListMetadataFactory
    implements VariantMetadataFactory {
        private final List<? extends LocalVariantGraphResolveMetadata> variants;

        public VariantsListMetadataFactory(List<? extends LocalVariantGraphResolveMetadata> variants) {
            this.variants = variants;
        }

        @Override
        public void visitConsumableVariants(Consumer<LocalVariantGraphResolveMetadata> visitor) {
            for (LocalVariantGraphResolveMetadata localVariantGraphResolveMetadata : this.variants) {
                visitor.accept(localVariantGraphResolveMetadata);
            }
        }

        @Override
        public void invalidate() {
        }

        @Override
        public LocalVariantGraphResolveMetadata getVariantByConfigurationName(String name) {
            return this.variants.stream().filter(variant -> name.equals(variant.getConfigurationName())).findFirst().orElse(null);
        }
    }
}

