/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.exception;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.component.resolution.failure.interfaces.ResolutionFailure;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.exceptions.StyledException;

@Contextual
public abstract class AbstractResolutionFailureException
extends StyledException
implements ResolutionProvider {
    private static final Logger LOGGER = Logging.getLogger(AbstractResolutionFailureException.class);
    private final ImmutableList<String> resolutions;
    protected final ResolutionFailure failure;

    public AbstractResolutionFailureException(String message, ResolutionFailure failure, List<String> resolutions) {
        this(message, failure, resolutions, null);
    }

    public AbstractResolutionFailureException(String message, ResolutionFailure failure, List<String> resolutions, @Nullable Throwable cause) {
        super(message, cause);
        this.failure = failure;
        this.resolutions = ImmutableList.copyOf(resolutions);
        LOGGER.info("Variant Selection Exception: {} caused by Resolution Failure: {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.getFailure().getClass().getName());
    }

    public abstract ResolutionFailure getFailure();

    public ImmutableList<String> getResolutions() {
        return this.resolutions;
    }
}

