/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.io.File;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.internal.initialization.BuildLogicBuildQueue;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.DefaultLockOptions;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;

public class DefaultBuildLogicBuildQueue
implements BuildLogicBuildQueue {
    private final FileLockManager fileLockManager;
    private final BuildTreeWorkGraphController buildTreeWorkGraphController;
    private final ProjectCacheDir projectCacheDir;
    private final ReentrantLock lock = new ReentrantLock();

    public DefaultBuildLogicBuildQueue(FileLockManager fileLockManager, BuildTreeWorkGraphController buildTreeWorkGraphController, ProjectCacheDir projectCacheDir) {
        this.fileLockManager = fileLockManager;
        this.buildTreeWorkGraphController = buildTreeWorkGraphController;
        this.projectCacheDir = projectCacheDir;
    }

    @Override
    public <T> T build(BuildState requester, List<TaskIdentifier.TaskBasedTaskIdentifier> tasks, Supplier<T> continuationUnderLock) {
        return (T)(tasks.isEmpty() ? continuationUnderLock.get() : this.withBuildLogicQueueLock(() -> this.doBuild(tasks, continuationUnderLock)));
    }

    @Override
    public <T> T buildBuildSrc(StandAloneNestedBuild buildSrcBuild, Function<BuildTreeLifecycleController, T> continuationUnderLock) {
        return (T)this.withBuildLogicQueueLock(() -> buildSrcBuild.run(controller -> continuationUnderLock.apply((BuildTreeLifecycleController)controller)));
    }

    private <T> T doBuild(List<TaskIdentifier.TaskBasedTaskIdentifier> tasks, Supplier<T> continuationUnderLock) {
        this.buildTreeWorkGraphController.withNewWorkGraph(graph -> {
            graph.scheduleWork(builder -> builder.scheduleTasks(tasks)).runWork().rethrow();
            return null;
        });
        return continuationUnderLock.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withBuildLogicQueueLock(Supplier<T> buildAction) {
        boolean firstLockHolder;
        this.lock.lock();
        boolean bl = firstLockHolder = this.lock.getHoldCount() == 1;
        if (firstLockHolder) {
            FileLock ignored = this.lockBuildLogicQueueFile();
            T t = buildAction.get();
            return t;
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        T t = buildAction.get();
        return t;
        finally {
            this.lock.unlock();
        }
    }

    private FileLock lockBuildLogicQueueFile() {
        return this.fileLockManager.lock(new File(this.projectCacheDir.getDir(), "noVersion/buildLogic"), (LockOptions)DefaultLockOptions.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive), "build logic queue");
    }
}

