/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.DefaultLockOptions;
import org.gradle.internal.classpath.ClasspathFileHasher;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactory;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class CustomClasspathFileTransformer
implements ClasspathFileTransformer {
    private static final int CACHE_FORMAT = 6;
    private final FileLockManager fileLockManager;
    private final ClasspathFileHasher fileHasher;
    private final ClasspathElementTransformFactory classpathElementTransformFactory;
    private final ClassTransform transform;

    public CustomClasspathFileTransformer(FileLockManager fileLockManager, ClasspathFileHasher classpathFileHasher, ClasspathElementTransformFactory classpathElementTransformFactory, ClassTransform transform) {
        this.fileLockManager = fileLockManager;
        this.fileHasher = CustomClasspathFileTransformer.createFileHasherWithConfig(CustomClasspathFileTransformer.configHashFor(classpathElementTransformFactory, transform), classpathFileHasher);
        this.classpathElementTransformFactory = classpathElementTransformFactory;
        this.transform = transform;
    }

    private static HashCode configHashFor(ClasspathElementTransformFactory classpathElementTransformFactory, ClassTransform transform) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putInt(6);
        hasher.putInt(23);
        classpathElementTransformFactory.applyConfigurationTo(hasher);
        transform.applyConfigurationTo(hasher);
        return hasher.hash();
    }

    private static ClasspathFileHasher createFileHasherWithConfig(HashCode configHash, ClasspathFileHasher fileHasher) {
        return sourceSnapshot -> {
            Hasher hasher = Hashing.newHasher();
            hasher.putHash(configHash);
            hasher.putHash(fileHasher.hashOf(sourceSnapshot));
            if (sourceSnapshot.getType() == FileType.Directory) {
                hasher.putBoolean(true);
            }
            return hasher.hash();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File transform(File source, FileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        String destDirName = this.hashOf(sourceSnapshot);
        File destDir = new File(cacheDir, destDirName);
        String destFileName = source.getName();
        File receipt = new File(destDir, destFileName + ".receipt");
        File transformed = new File(destDir, destFileName);
        if (receipt.isFile()) {
            return transformed;
        }
        File lockFile = new File(destDir, destFileName + ".lock");
        try (FileLock fileLock = this.exclusiveLockFor(lockFile);){
            if (receipt.isFile()) {
                File file = transformed;
                return file;
            }
            this.transform(source, transformed);
            try {
                receipt.createNewFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create receipt for instrumented classpath file '%s/%s'.", destDirName, destFileName), (Throwable)e);
            }
            File file = transformed;
            return file;
        }
    }

    @Override
    public ClasspathFileHasher getFileHasher() {
        return this.fileHasher;
    }

    private FileLock exclusiveLockFor(File file) {
        return this.fileLockManager.lock(file, (LockOptions)DefaultLockOptions.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation(), "transformed jar cache");
    }

    private String hashOf(FileSystemLocationSnapshot sourceSnapshot) {
        return this.fileHasher.hashOf(sourceSnapshot).toString();
    }

    private void transform(File source, File dest) {
        this.classpathElementTransformFactory.createTransformer(source, this.transform).transform(dest);
    }
}

