/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import javax.inject.Inject;
import org.gradle.api.internal.attributes.ConcurrentIdentityCache;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.internal.attributes.matching.CachingAttributeSelectionSchema;
import org.gradle.api.internal.attributes.matching.DefaultAttributeMatcher;
import org.gradle.api.internal.attributes.matching.DefaultAttributeSelectionSchema;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class AttributeSchemaServices {
    private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
    private final ConcurrentIdentityCache<ImmutableAttributesSchema, AttributeMatcher> matchers = new ConcurrentIdentityCache();

    @Inject
    public AttributeSchemaServices(ImmutableAttributesSchemaFactory attributesSchemaFactory) {
        this.attributesSchemaFactory = attributesSchemaFactory;
    }

    public ImmutableAttributesSchemaFactory getSchemaFactory() {
        return this.attributesSchemaFactory;
    }

    public AttributeMatcher getMatcher(ImmutableAttributesSchema consumer, ImmutableAttributesSchema producer) {
        ImmutableAttributesSchema merged = this.attributesSchemaFactory.concat(consumer, producer);
        return this.matchers.computeIfAbsent(merged, key -> new DefaultAttributeMatcher(new CachingAttributeSelectionSchema(new DefaultAttributeSelectionSchema((ImmutableAttributesSchema)key))));
    }
}

