/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import java.util.Collection;
import java.util.List;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;

public interface AttributeMatcher {
    public boolean isMatchingCandidate(ImmutableAttributes var1, ImmutableAttributes var2);

    public boolean areMutuallyCompatible(ImmutableAttributes var1, ImmutableAttributes var2);

    public <T> boolean isMatchingValue(Attribute<T> var1, T var2, T var3);

    public <T extends HasAttributes> List<T> matchMultipleCandidates(Collection<? extends T> var1, ImmutableAttributes var2, AttributeMatchingExplanationBuilder var3);

    public List<MatchingDescription<?>> describeMatching(ImmutableAttributes var1, ImmutableAttributes var2);

    public static class MatchingDescription<T> {
        private final Attribute<T> requestedAttribute;
        private final AttributeValue<T> requestedValue;
        private final AttributeValue<T> found;
        private final boolean match;

        public MatchingDescription(Attribute<T> requestedAttribute, AttributeValue<T> requestedValue, AttributeValue<T> found, boolean match) {
            this.requestedAttribute = requestedAttribute;
            this.requestedValue = requestedValue;
            this.found = found;
            this.match = match;
        }

        public Attribute<T> getRequestedAttribute() {
            return this.requestedAttribute;
        }

        public AttributeValue<T> getRequestedValue() {
            return this.requestedValue;
        }

        public AttributeValue<T> getFound() {
            return this.found;
        }

        public boolean isMatch() {
            return this.match;
        }
    }
}

