/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.buildtree.ProblemStream;

public class DefaultProblemReporter
implements InternalProblemReporter {
    private final Collection<ProblemEmitter> emitters;
    private final ProblemStream problemStream;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final Multimap<Throwable, Problem> problems;
    private final AdditionalDataBuilderFactory additionalDataBuilderFactory;

    public DefaultProblemReporter(Collection<ProblemEmitter> emitters, ProblemStream problemStream, CurrentBuildOperationRef currentBuildOperationRef, Multimap<Throwable, Problem> problems, AdditionalDataBuilderFactory additionalDataBuilderFactory) {
        this.emitters = emitters;
        this.problemStream = problemStream;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.problems = problems;
        this.additionalDataBuilderFactory = additionalDataBuilderFactory;
    }

    @Override
    public void reporting(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = new DefaultProblemBuilder(this.problemStream, this.additionalDataBuilderFactory);
        spec.execute((Object)problemBuilder);
        this.report(problemBuilder.build());
    }

    @Override
    public RuntimeException throwing(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = new DefaultProblemBuilder(this.problemStream, this.additionalDataBuilderFactory);
        spec.execute((Object)problemBuilder);
        Problem problem = problemBuilder.build();
        Throwable exception = problem.getException();
        if (exception == null) {
            throw new IllegalStateException("Exception must be non-null");
        }
        throw this.throwError(exception, problem);
    }

    private RuntimeException throwError(Throwable exception, Problem problem) {
        this.report(problem);
        this.problems.put((Object)exception, (Object)problem);
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    @Override
    public Problem create(Action<InternalProblemSpec> action) {
        DefaultProblemBuilder defaultProblemBuilder = new DefaultProblemBuilder(this.problemStream, this.additionalDataBuilderFactory);
        action.execute((Object)defaultProblemBuilder);
        return defaultProblemBuilder.build();
    }

    @Override
    public void report(Problem problem) {
        OperationIdentifier id;
        Throwable exception = problem.getException();
        if (exception != null) {
            this.problems.put((Object)exception, (Object)problem);
        }
        if ((id = this.currentBuildOperationRef.getId()) != null) {
            this.report(problem, id);
        }
    }

    @Override
    public void report(Problem problem, OperationIdentifier id) {
        for (ProblemEmitter emitter : this.emitters) {
            emitter.emit(problem, id);
        }
    }
}

