/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.io.Closeable;
import java.util.function.Function;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.buildtree.BuildTreeModelControllerServices;
import org.gradle.internal.buildtree.BuildTreeScopeServices;
import org.gradle.internal.buildtree.DefaultBuildTreeContext;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.work.ProjectParallelExecutionController;

@ServiceScope(value={Scope.BuildTree.class})
public class BuildTreeState
implements Closeable {
    private final ServiceRegistry services;
    private final DefaultBuildTreeContext context;

    public BuildTreeState(BuildInvocationScopeId buildInvocationScopeId, ServiceRegistry parent, BuildTreeModelControllerServices.Supplier modelServices) {
        this.services = ServiceRegistryBuilder.builder().scope(Scope.BuildTree.class).displayName("build tree services").parent(parent).provider((ServiceRegistrationProvider)new BuildTreeScopeServices(buildInvocationScopeId, this, modelServices)).build();
        this.context = new DefaultBuildTreeContext(this.services);
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Function<? super BuildTreeContext, T> action) {
        BuildModelParameters modelParameters = (BuildModelParameters)this.services.get(BuildModelParameters.class);
        ProjectParallelExecutionController parallelExecutionController = (ProjectParallelExecutionController)this.services.get(ProjectParallelExecutionController.class);
        parallelExecutionController.startProjectExecution(modelParameters.isParallelProjectExecution());
        try {
            T t = action.apply(this.context);
            return t;
        }
        finally {
            parallelExecutionController.finishProjectExecution();
        }
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.services}).stop();
    }
}

