/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.daemon.services;

import org.gradle.api.internal.tasks.userinput.DefaultUserInputReader;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.daemon.serialization.DaemonSidePayloadClassLoaderFactory;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderCache;
import org.gradle.tooling.internal.provider.serialization.DefaultPayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.ModelClassLoaderFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.WellKnownClassLoaderRegistry;

public class DaemonServices
extends AbstractGradleModuleServices {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.add(UserInputReader.class, DefaultUserInputReader.class);
        registration.add(ClassLoaderCache.class, ClassLoaderCache.class);
    }

    public void registerGradleUserHomeServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new DaemonGradleUserHomeServices());
    }

    private static class DaemonGradleUserHomeServices
    implements ServiceRegistrationProvider {
        private DaemonGradleUserHomeServices() {
        }

        @Provides
        PayloadClassLoaderFactory createClassLoaderFactory(CachedClasspathTransformer cachedClasspathTransformer) {
            return new DaemonSidePayloadClassLoaderFactory((PayloadClassLoaderFactory)new ModelClassLoaderFactory(), cachedClasspathTransformer);
        }

        @Provides
        PayloadSerializer createPayloadSerializer(ClassLoaderCache classLoaderCache, PayloadClassLoaderFactory classLoaderFactory) {
            return new PayloadSerializer((PayloadClassLoaderRegistry)new WellKnownClassLoaderRegistry((PayloadClassLoaderRegistry)new DefaultPayloadClassLoaderRegistry(classLoaderCache, classLoaderFactory)));
        }
    }
}

