/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.TypeValidationData;
import org.gradle.api.problems.internal.TypeValidationDataSpec;
import org.gradle.internal.reflect.validation.DefaultPluginId;
import org.gradle.internal.reflect.validation.DelegatingProblemBuilder;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;

@NonNullApi
public class DefaultTypeAwareProblemBuilder
extends DelegatingProblemBuilder
implements TypeAwareProblemBuilder {
    private AdditionalDataBuilderFactory additionalDataBuilderFactory;
    private String parentPropertyAdditionalData = null;

    public DefaultTypeAwareProblemBuilder(InternalProblemBuilder problemBuilder, AdditionalDataBuilderFactory additionalDataBuilderFactory) {
        super(problemBuilder);
        this.additionalDataBuilderFactory = additionalDataBuilderFactory;
    }

    @Override
    public TypeAwareProblemBuilder withAnnotationType(@Nullable Class<?> classWithAnnotationAttached) {
        if (classWithAnnotationAttached != null) {
            this.additionalData(TypeValidationDataSpec.class, data -> data.typeName(classWithAnnotationAttached.getName().replaceAll("\\$", ".")));
        }
        return this;
    }

    @Override
    public TypeAwareProblemBuilder forProperty(String propertyName) {
        this.additionalData(TypeValidationDataSpec.class, data -> data.propertyName(propertyName));
        return this;
    }

    @Override
    public TypeAwareProblemBuilder parentProperty(@Nullable String parentProperty) {
        if (parentProperty == null) {
            return this;
        }
        String pp = this.getParentProperty(parentProperty);
        this.additionalData(TypeValidationDataSpec.class, data -> data.parentPropertyName(pp));
        this.parentPropertyAdditionalData = pp;
        return this;
    }

    @Override
    public Problem build() {
        Problem problem = super.build();
        Optional<TypeValidationData> additionalData = Optional.ofNullable((TypeValidationData)problem.getAdditionalData());
        String prefix = DefaultTypeAwareProblemBuilder.introductionFor(additionalData, DefaultTypeAwareProblemBuilder.isTypeIrrelevantInErrorMessage(problem.getDefinition().getId()));
        String text = Optional.ofNullable(problem.getContextualLabel()).orElseGet(() -> problem.getDefinition().getId().getDisplayName());
        return problem.toBuilder(this.additionalDataBuilderFactory).contextualLabel(prefix + text).build();
    }

    private static boolean isTypeIrrelevantInErrorMessage(ProblemId problemId) {
        if (!problemId.getGroup().equals(GradleCoreProblemGroup.validation().property())) {
            return false;
        }
        List<String> candidates = Arrays.asList("unknown-implementation", "unknown-implementation-nested", "implicit-dependency");
        return candidates.contains(problemId.getName());
    }

    public static String introductionFor(Optional<TypeValidationData> additionalData, boolean typeIrrelevantInErrorMessage) {
        Object property;
        boolean typeRelevant;
        Optional<String> rootType = additionalData.map(TypeValidationData::getTypeName).map(Object::toString).filter(DefaultTypeAwareProblemBuilder::shouldRenderType);
        Optional<DefaultPluginId> pluginId = additionalData.map(TypeValidationData::getPluginId).map(Object::toString).map(DefaultPluginId::new);
        StringBuilder builder = new StringBuilder();
        boolean bl = typeRelevant = rootType.isPresent() && !typeIrrelevantInErrorMessage;
        if (typeRelevant) {
            if (pluginId.isPresent()) {
                builder.append("In plugin '").append(pluginId.get()).append("' type '");
            } else {
                builder.append("Type '");
            }
            builder.append(rootType.get()).append("' ");
        }
        if ((property = additionalData.map(TypeValidationData::getPropertyName).orElse(null)) != null) {
            if (typeRelevant) {
                builder.append("property '");
            } else if (pluginId.isPresent()) {
                builder.append("In plugin '").append(pluginId.get()).append("' property '");
            } else {
                builder.append("Property '");
            }
            additionalData.map(TypeValidationData::getParentPropertyName).ifPresent(parentProperty -> {
                builder.append((String)parentProperty);
                builder.append('.');
            });
            builder.append((Object)property).append("' ");
        }
        return builder.toString();
    }

    private static boolean shouldRenderType(String className) {
        return !"org.gradle.api.DefaultTask".equals(className);
    }

    private String getParentProperty(String parentProperty) {
        String existingParentProperty = this.parentPropertyAdditionalData;
        if (existingParentProperty == null) {
            return parentProperty;
        }
        return existingParentProperty + "." + parentProperty;
    }
}

