/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import org.gradle.cache.Cache;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.impl.DefaultWorkValidationContext;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.ExecutionRequestContext;

public class DefaultExecutionEngine
implements ExecutionEngine {
    private final DeferredExecutionAwareStep<? super ExecutionRequestContext, ? extends ExecutionEngine.Result> executeStep;

    public DefaultExecutionEngine(DeferredExecutionAwareStep<? super ExecutionRequestContext, ? extends ExecutionEngine.Result> executeStep) {
        this.executeStep = executeStep;
    }

    @Override
    public ExecutionEngine.Request createRequest(final UnitOfWork work) {
        return new ExecutionEngine.Request(){
            private String nonIncrementalReason;
            private WorkValidationContext validationContext;

            private ExecutionRequestContext createExecutionRequestContext() {
                WorkValidationContext validationContext = this.validationContext != null ? this.validationContext : new DefaultWorkValidationContext(work.getTypeOriginInspector());
                return new ExecutionRequestContext(this.nonIncrementalReason, validationContext);
            }

            @Override
            public void forceNonIncremental(String nonIncremental) {
                this.nonIncrementalReason = nonIncremental;
            }

            @Override
            public void withValidationContext(WorkValidationContext validationContext) {
                this.validationContext = validationContext;
            }

            @Override
            public ExecutionEngine.Result execute() {
                return (ExecutionEngine.Result)DefaultExecutionEngine.this.executeStep.execute(work, this.createExecutionRequestContext());
            }

            @Override
            public <T> Deferrable<Try<T>> executeDeferred(Cache<UnitOfWork.Identity, ExecutionEngine.IdentityCacheResult<T>> cache) {
                return DefaultExecutionEngine.this.executeStep.executeDeferred(work, this.createExecutionRequestContext(), cache);
            }
        };
    }
}

