/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.NonNullApi;

@NonNullApi
public enum JavaInstallationCapability {
    JAVA_COMPILER,
    JAVADOC_TOOL,
    J9_VIRTUAL_MACHINE;

    public static final Set<JavaInstallationCapability> JDK_CAPABILITIES;

    public final String toDisplayName() {
        switch (this) {
            case JAVA_COMPILER: {
                return "executable 'javac'";
            }
            case JAVADOC_TOOL: {
                return "executable 'javadoc'";
            }
            case J9_VIRTUAL_MACHINE: {
                return "J9 virtual machine";
            }
        }
        throw new IllegalStateException("Unknown capability: " + (Object)((Object)this));
    }

    static {
        JDK_CAPABILITIES = Sets.immutableEnumSet((Enum)JAVA_COMPILER, (Enum[])new JavaInstallationCapability[]{JAVADOC_TOOL});
    }
}

