/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.FunctionSemantics;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.AssignmentRecord;
import org.gradle.internal.declarativedsl.analysis.DefaultAnalysisSchemaKt;
import org.gradle.internal.declarativedsl.analysis.ErrorCollector;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.ExpressionResolver;
import org.gradle.internal.declarativedsl.analysis.NamedReferenceResolver;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.PropertyReferenceResolution;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.analysis.StatementResolver;
import org.gradle.internal.declarativedsl.analysis.UtilsKt;
import org.gradle.internal.declarativedsl.language.Assignment;
import org.gradle.internal.declarativedsl.language.Expr;
import org.gradle.internal.declarativedsl.language.FunctionCall;
import org.gradle.internal.declarativedsl.language.LocalValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u001b\u001a\u00020\u0010*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/StatementResolverImpl;", "Lorg/gradle/internal/declarativedsl/analysis/StatementResolver;", "namedReferenceResolver", "Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;", "expressionResolver", "Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;", "errorCollector", "Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "(Lorg/gradle/internal/declarativedsl/analysis/NamedReferenceResolver;Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;)V", "doResolveAssignment", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentRecord;", "context", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "assignment", "Lorg/gradle/internal/declarativedsl/language/Assignment;", "doResolveExpressionStatement", "", "expr", "Lorg/gradle/internal/declarativedsl/language/Expr;", "doResolveLocalValue", "localValue", "Lorg/gradle/internal/declarativedsl/language/LocalValue;", "isDanglingPureCall", "", "obj", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$FunctionOrigin;", "doAnalyzeAssignment", "doAnalyzeLocal", "declarative-dsl-core"})
public final class StatementResolverImpl
implements StatementResolver {
    @NotNull
    private final NamedReferenceResolver namedReferenceResolver;
    @NotNull
    private final ExpressionResolver expressionResolver;
    @NotNull
    private final ErrorCollector errorCollector;

    public StatementResolverImpl(@NotNull NamedReferenceResolver namedReferenceResolver, @NotNull ExpressionResolver expressionResolver, @NotNull ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)namedReferenceResolver, (String)"namedReferenceResolver");
        Intrinsics.checkNotNullParameter((Object)expressionResolver, (String)"expressionResolver");
        Intrinsics.checkNotNullParameter((Object)errorCollector, (String)"errorCollector");
        this.namedReferenceResolver = namedReferenceResolver;
        this.expressionResolver = expressionResolver;
        this.errorCollector = errorCollector;
    }

    @Override
    @Nullable
    public AssignmentRecord doResolveAssignment(@NotNull AnalysisContext context, @NotNull Assignment assignment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        return this.doAnalyzeAssignment(context, assignment);
    }

    @Override
    public void doResolveLocalValue(@NotNull AnalysisContext context, @NotNull LocalValue localValue2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localValue2, (String)"localValue");
        this.doAnalyzeLocal(context, localValue2);
    }

    @Override
    public void doResolveExpressionStatement(@NotNull AnalysisContext context, @NotNull Expr expr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        ObjectOrigin resolvedExpr = this.expressionResolver.doResolveExpression(context, expr, null);
        if (expr instanceof FunctionCall) {
            if (resolvedExpr instanceof ObjectOrigin.FunctionOrigin && this.isDanglingPureCall((ObjectOrigin.FunctionOrigin)resolvedExpr)) {
                this.errorCollector.collect(new ResolutionError(expr, ErrorReason.DanglingPureExpression.INSTANCE));
            }
        } else {
            this.errorCollector.collect(new ResolutionError(expr, ErrorReason.DanglingPureExpression.INSTANCE));
        }
    }

    private final AssignmentRecord doAnalyzeAssignment(AnalysisContext $this$doAnalyzeAssignment, Assignment assignment) {
        AssignmentRecord assignmentRecord;
        PropertyReferenceResolution lhsResolution = this.namedReferenceResolver.doResolveNamedReferenceToAssignable($this$doAnalyzeAssignment, assignment.getLhs());
        if (lhsResolution == null) {
            $this$doAnalyzeAssignment.getErrorCollector().collect(new ResolutionError(assignment.getLhs(), new ErrorReason.UnresolvedReference(assignment.getLhs())));
            $this$doAnalyzeAssignment.getErrorCollector().collect(new ResolutionError(assignment, ErrorReason.UnresolvedAssignmentLhs.INSTANCE));
            assignmentRecord = null;
        } else {
            ObjectOrigin rhsResolution;
            boolean hasErrors = false;
            if (DefaultAnalysisSchemaKt.isReadOnly(lhsResolution.getProperty())) {
                $this$doAnalyzeAssignment.getErrorCollector().collect(new ResolutionError(assignment, new ErrorReason.ReadOnlyPropertyAssignment(lhsResolution.getProperty())));
                hasErrors = true;
            }
            if ((rhsResolution = this.expressionResolver.doResolveExpression($this$doAnalyzeAssignment, assignment.getRhs(), lhsResolution.getProperty().getValueType())) == null) {
                $this$doAnalyzeAssignment.getErrorCollector().collect(new ResolutionError(assignment, ErrorReason.UnresolvedAssignmentRhs.INSTANCE));
                assignmentRecord = null;
            } else {
                DataType rhsType = UtilsKt.getDataType($this$doAnalyzeAssignment, rhsResolution);
                DataType lhsExpectedType = $this$doAnalyzeAssignment.resolveRef(lhsResolution.getProperty().getValueType());
                if (rhsType instanceof DataType.UnitType) {
                    $this$doAnalyzeAssignment.getErrorCollector().collect(new ResolutionError(assignment, ErrorReason.UnitAssignment.INSTANCE));
                    hasErrors = true;
                }
                if (!UtilsKt.checkIsAssignable(rhsType, lhsExpectedType)) {
                    $this$doAnalyzeAssignment.getErrorCollector().collect(new ResolutionError(assignment, new ErrorReason.AssignmentTypeMismatch(lhsExpectedType, rhsType)));
                    hasErrors = true;
                }
                assignmentRecord = !hasErrors ? $this$doAnalyzeAssignment.recordAssignment(lhsResolution, rhsResolution, AssignmentMethod.Property.INSTANCE, assignment) : null;
            }
        }
        return assignmentRecord;
    }

    private final void doAnalyzeLocal(AnalysisContext $this$doAnalyzeLocal, LocalValue localValue2) {
        ObjectOrigin rhs = this.expressionResolver.doResolveExpression($this$doAnalyzeLocal, localValue2.getRhs(), null);
        if (rhs == null) {
            $this$doAnalyzeLocal.getErrorCollector().collect(new ResolutionError(localValue2, ErrorReason.UnresolvedAssignmentRhs.INSTANCE));
        } else {
            if (UtilsKt.getDataType($this$doAnalyzeLocal, rhs) instanceof DataType.UnitType) {
                $this$doAnalyzeLocal.getErrorCollector().collect(new ResolutionError(localValue2, ErrorReason.UnitAssignment.INSTANCE));
            }
            ((AnalysisScope)CollectionsKt.last($this$doAnalyzeLocal.getCurrentScopes())).declareLocal(localValue2, rhs, $this$doAnalyzeLocal.getErrorCollector());
        }
    }

    private final boolean isDanglingPureCall(ObjectOrigin.FunctionOrigin obj) {
        return obj.getFunction().getSemantics() instanceof FunctionSemantics.Pure ? true : (obj instanceof ObjectOrigin.BuilderReturnedReceiver ? !StatementResolverImpl.isDanglingPureCall$isPotentiallyPersistentReceiver(((ObjectOrigin.BuilderReturnedReceiver)obj).getReceiver()) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isDanglingPureCall$isPotentiallyPersistentReceiver(ObjectOrigin objectOrigin) {
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.AccessAndConfigureReceiver) {
            return true;
        }
        if (objectOrigin2 instanceof ObjectOrigin.ImplicitThisReceiver) {
            return true;
        }
        if (objectOrigin2 instanceof ObjectOrigin.FromLocalValue) {
            return true;
        }
        if (!(objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin)) {
            if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.EnumConstantOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.External) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.FunctionOrigin) {
                FunctionSemantics semantics = ((ObjectOrigin.FunctionOrigin)objectOrigin).getFunction().getSemantics();
                FunctionSemantics functionSemantics = semantics;
                if (functionSemantics instanceof FunctionSemantics.Builder) {
                    throw new IllegalStateException("should be impossible?".toString());
                }
                if (functionSemantics instanceof FunctionSemantics.AccessAndConfigure) {
                    return true;
                }
                if (functionSemantics instanceof FunctionSemantics.AddAndConfigure) {
                    return true;
                }
                if (!(functionSemantics instanceof FunctionSemantics.Pure)) throw new NoWhenBranchMatchedException();
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
                return false;
            }
            if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
                return true;
            }
            if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
                return true;
            }
            if (!(objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor)) throw new NoWhenBranchMatchedException();
            return true;
        }
        boolean bl = StatementResolverImpl.isDanglingPureCall$isPotentiallyPersistentReceiver(((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        return bl;
    }
}

