/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CapabilitySerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.resolve.caching.DesugaringAttributeContainerSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;

public class CompleteComponentResultSerializer
implements ComponentResultSerializer {
    private final ComponentSelectionReasonSerializer reasonSerializer;
    private final Serializer<ModuleVersionIdentifier> moduleVersionIdSerializer;
    private final Serializer<AttributeContainer> attributeContainerSerializer;
    private final Serializer<ComponentIdentifier> componentIdSerializer;
    private final Serializer<List<Capability>> capabilitySerializer;

    @Inject
    public CompleteComponentResultSerializer(ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ImmutableAttributesFactory immutableAttributesFactory, NamedObjectInstantiator namedObjectInstantiator) {
        this.reasonSerializer = new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory);
        this.moduleVersionIdSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        this.attributeContainerSerializer = new DesugaringAttributeContainerSerializer(immutableAttributesFactory, namedObjectInstantiator);
        this.componentIdSerializer = new ComponentIdentifierSerializer();
        this.capabilitySerializer = new ListSerializer((Serializer)new CapabilitySerializer());
    }

    @Override
    public void writeComponentResult(Encoder encoder, ResolvedGraphComponent component, boolean includeAllSelectableVariantResults) throws Exception {
        encoder.writeSmallLong(component.getResultId());
        this.reasonSerializer.write(encoder, component.getSelectionReason());
        encoder.writeNullableString((CharSequence)component.getRepositoryName());
        ComponentGraphResolveState componentState = component.getResolveState();
        this.componentIdSerializer.write(encoder, (Object)componentState.getId());
        this.moduleVersionIdSerializer.write(encoder, (Object)componentState.getMetadata().getModuleVersionId());
        List<ResolvedGraphVariant> selectedVariants = component.getSelectedVariants();
        encoder.writeSmallInt(selectedVariants.size());
        for (ResolvedGraphVariant variant : selectedVariants) {
            this.writeVariantResult(variant, componentState, encoder);
        }
    }

    private void writeVariantResult(ResolvedGraphVariant variant, ComponentGraphResolveState component, Encoder encoder) throws Exception {
        encoder.writeSmallLong(variant.getNodeId());
        ResolvedVariantResult variantResult = component.getPublicViewFor(variant.getResolveState(), null);
        this.componentIdSerializer.write(encoder, (Object)variantResult.getOwner());
        encoder.writeString((CharSequence)variantResult.getDisplayName());
        this.attributeContainerSerializer.write(encoder, (Object)variantResult.getAttributes());
        this.capabilitySerializer.write(encoder, (Object)variantResult.getCapabilities());
    }

    @Override
    public void readComponentResult(Decoder decoder, ResolvedComponentVisitor visitor) throws Exception {
        long resultId = decoder.readSmallLong();
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        String repo = decoder.readNullableString();
        visitor.startVisitComponent(resultId, reason, repo);
        ComponentIdentifier componentIdentifier = (ComponentIdentifier)this.componentIdSerializer.read(decoder);
        ModuleVersionIdentifier moduleVersionIdentifier = (ModuleVersionIdentifier)this.moduleVersionIdSerializer.read(decoder);
        visitor.visitComponentDetails(componentIdentifier, moduleVersionIdentifier);
        visitor.visitComponentVariants((List<ResolvedVariantResult>)ImmutableList.of());
        int variantCount = decoder.readSmallInt();
        for (int i = 0; i < variantCount; ++i) {
            this.readVariantResult(decoder, visitor);
        }
        visitor.endVisitComponent();
    }

    private void readVariantResult(Decoder decoder, ResolvedComponentVisitor visitor) throws Exception {
        long nodeId = decoder.readSmallLong();
        ComponentIdentifier ownerId = (ComponentIdentifier)this.componentIdSerializer.read(decoder);
        String displayName = decoder.readString();
        AttributeContainer attributes = (AttributeContainer)this.attributeContainerSerializer.read(decoder);
        List capabilities = (List)this.capabilitySerializer.read(decoder);
        visitor.visitSelectedVariant(nodeId, new DefaultResolvedVariantResult(ownerId, Describables.of((Object)displayName), attributes, ImmutableCapabilities.of(capabilities), null));
    }
}

