/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gradle.cache.internal.CacheVersion;
import org.gradle.util.GradleVersion;

public class CacheVersionMapping {
    private static final Function<Map.Entry<GradleVersion, CacheVersion>, CacheVersion> TO_VALUE = new Function<Map.Entry<GradleVersion, CacheVersion>, CacheVersion>(){

        public CacheVersion apply(Map.Entry<GradleVersion, CacheVersion> input) {
            return input.getValue();
        }
    };
    private final NavigableMap<GradleVersion, CacheVersion> versions;

    private CacheVersionMapping(NavigableMap<GradleVersion, CacheVersion> versions) {
        Preconditions.checkArgument((!versions.isEmpty() ? 1 : 0) != 0, (Object)"versions must not be empty");
        this.versions = new TreeMap<GradleVersion, CacheVersion>((SortedMap<GradleVersion, CacheVersion>)versions);
    }

    public CacheVersion getLatestVersion() {
        return (CacheVersion)this.versions.get(this.versions.lastKey());
    }

    public Optional<CacheVersion> getVersionUsedBy(GradleVersion gradleVersion) {
        GradleVersion versionToFind = gradleVersion.isSnapshot() ? gradleVersion.getBaseVersion() : gradleVersion;
        return Optional.fromNullable(this.versions.floorEntry(versionToFind)).transform(TO_VALUE);
    }

    public static Builder introducedIn(String gradleVersion) {
        return new Builder().changedTo(1, gradleVersion);
    }

    public static class Builder {
        private final NavigableMap<GradleVersion, Integer> versions = new TreeMap<GradleVersion, Integer>();

        private Builder() {
        }

        public Builder incrementedIn(String minGradleVersion) {
            return this.changedTo((Integer)this.versions.get(this.versions.lastKey()) + 1, minGradleVersion);
        }

        public Builder retiredIn(String gradleVersion) {
            return this.changedTo(Integer.MAX_VALUE, gradleVersion);
        }

        public Builder changedTo(int cacheVersion, String minGradleVersion) {
            GradleVersion parsedGradleVersion = GradleVersion.version((String)minGradleVersion);
            if (!this.versions.isEmpty()) {
                Preconditions.checkArgument((parsedGradleVersion.compareTo((GradleVersion)this.versions.lastKey()) > 0 ? 1 : 0) != 0, (String)"Gradle version (%s) must be greater than all previous versions: %s", (Object)parsedGradleVersion.getVersion(), this.versions.keySet());
                GradleVersion currentBaseVersion = GradleVersion.current().getBaseVersion();
                Preconditions.checkArgument((parsedGradleVersion.getBaseVersion().compareTo(currentBaseVersion) <= 0 ? 1 : 0) != 0, (String)"Base version of Gradle version (%s) must not be greater than base version of current Gradle version: %s", (Object)parsedGradleVersion.getVersion(), (Object)currentBaseVersion);
                Preconditions.checkArgument((cacheVersion > (Integer)this.versions.get(this.versions.lastKey()) ? 1 : 0) != 0, (String)"cache version (%s) must be greater than all previous versions: %s", (int)cacheVersion, this.versions.values());
            }
            this.versions.put(parsedGradleVersion, cacheVersion);
            return this;
        }

        public Builder changedToWithConflict(int cacheVersion, String minGradleVersion) {
            GradleVersion parsedGradleVersion = GradleVersion.version((String)minGradleVersion);
            Preconditions.checkArgument((cacheVersion == 100 && minGradleVersion.equals("8.0-milestone-5") ? 1 : 0) != 0);
            this.versions.put(parsedGradleVersion, cacheVersion);
            return this;
        }

        public CacheVersionMapping build() {
            return this.build(CacheVersion.empty());
        }

        public CacheVersionMapping build(CacheVersion parentVersion) {
            TreeMap<GradleVersion, CacheVersion> convertedVersions = new TreeMap<GradleVersion, CacheVersion>();
            for (Map.Entry entry : this.versions.entrySet()) {
                convertedVersions.put((GradleVersion)entry.getKey(), parentVersion.append(((Integer)entry.getValue()).intValue()));
            }
            return new CacheVersionMapping(convertedVersions);
        }
    }
}

