/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import org.gradle.fileevents.FileEvents;
import org.gradle.fileevents.FileWatchEvent;
import org.gradle.fileevents.FileWatcher;
import org.gradle.fileevents.internal.LinuxFileEventFunctions;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.NonHierarchicalFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;

public class LinuxFileWatcherRegistryFactory
extends AbstractFileWatcherRegistryFactory<LinuxFileEventFunctions, LinuxFileEventFunctions.LinuxFileWatcher> {
    public LinuxFileWatcherRegistryFactory(Predicate<String> immutableLocationsFilter) throws NativeIntegrationUnavailableException {
        super((LinuxFileEventFunctions)FileEvents.get(LinuxFileEventFunctions.class), immutableLocationsFilter);
    }

    @Override
    protected LinuxFileEventFunctions.LinuxFileWatcher createFileWatcher(BlockingQueue<FileWatchEvent> fileEvents) throws InterruptedException {
        return (LinuxFileEventFunctions.LinuxFileWatcher)((LinuxFileEventFunctions)this.fileEventFunctions).newWatcher(fileEvents).start();
    }

    @Override
    protected FileWatcherUpdater createFileWatcherUpdater(LinuxFileEventFunctions.LinuxFileWatcher watcher, FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies) {
        return new NonHierarchicalFileWatcherUpdater((FileWatcher)watcher, probeRegistry, watchableHierarchies, new LinuxMovedDirectoryHandler(watcher, watchableHierarchies));
    }

    private static class LinuxMovedDirectoryHandler
    implements AbstractFileWatcherUpdater.MovedDirectoryHandler {
        private final LinuxFileEventFunctions.LinuxFileWatcher watcher;
        private final WatchableHierarchies watchableHierarchies;

        public LinuxMovedDirectoryHandler(LinuxFileEventFunctions.LinuxFileWatcher watcher, WatchableHierarchies watchableHierarchies) {
            this.watcher = watcher;
            this.watchableHierarchies = watchableHierarchies;
        }

        @Override
        public Collection<File> stopWatchingMovedDirectories(SnapshotHierarchy vfsRoot) {
            Collection directoriesToCheck = vfsRoot.rootSnapshots().filter(snapshot -> snapshot.getType() != FileType.Missing).filter(this.watchableHierarchies::shouldWatch).map(snapshot -> {
                switch (snapshot.getType()) {
                    case RegularFile: {
                        return new File(snapshot.getAbsolutePath()).getParentFile();
                    }
                    case Directory: {
                        return new File(snapshot.getAbsolutePath());
                    }
                }
                throw new IllegalArgumentException("Unexpected file type:" + snapshot.getType());
            }).collect(Collectors.toList());
            return this.watcher.stopWatchingMovedPaths(directoriesToCheck);
        }
    }
}

