/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.DefaultRootTestEventReporter;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.LifecycleTrackingGroupTestEventReporter;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.logging.SimpleTestEventLogger;
import org.gradle.api.internal.tasks.testing.logging.TestEventProgressListener;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.GroupTestEventReporter;
import org.gradle.api.tasks.testing.TestEventReporterFactory;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

@NonNullApi
public final class DefaultTestEventReporterFactory
implements TestEventReporterFactory {
    private final ListenerManager listenerManager;
    private final StyledTextOutputFactory textOutputFactory;
    private final ProgressLoggerFactory progressLoggerFactory;

    public DefaultTestEventReporterFactory(ListenerManager listenerManager, StyledTextOutputFactory textOutputFactory, ProgressLoggerFactory progressLoggerFactory) {
        this.listenerManager = listenerManager;
        this.textOutputFactory = textOutputFactory;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public GroupTestEventReporter createTestEventReporter(String rootName) {
        AnonymousListenerBroadcast testListenerInternalBroadcaster = this.listenerManager.createAnonymousBroadcaster(TestListenerInternal.class);
        testListenerInternalBroadcaster.add((Object)new SimpleTestEventLogger(this.textOutputFactory));
        testListenerInternalBroadcaster.add((Object)new TestEventProgressListener(this.progressLoggerFactory));
        LongIdGenerator idGenerator = new LongIdGenerator();
        return new LifecycleTrackingGroupTestEventReporter(new DefaultRootTestEventReporter((TestListenerInternal)testListenerInternalBroadcaster.getSource(), (IdGenerator<?>)idGenerator, (TestDescriptorInternal)new DefaultTestSuiteDescriptor(idGenerator.generateId(), rootName)));
    }
}

