/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.lang.invoke.SerializedLambda;
import javax.annotation.Nullable;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.ClassImplementationSnapshot;
import org.gradle.internal.snapshot.impl.LambdaImplementationSnapshot;
import org.gradle.internal.snapshot.impl.SerializedLambdaQueries;
import org.gradle.internal.snapshot.impl.UnknownImplementationSnapshot;

public abstract class ImplementationSnapshot
implements ValueSnapshot {
    protected final String classIdentifier;

    public static ImplementationSnapshot of(Class<?> type, ClassLoaderHierarchyHasher classLoaderHasher) {
        String className = type.getName();
        HashCode classLoaderHash = classLoaderHasher.getClassLoaderHash(type.getClassLoader());
        return ImplementationSnapshot.of(className, classLoaderHash, SerializedLambdaQueries.isLambdaClass(type), null);
    }

    public static ImplementationSnapshot of(String className, @Nullable HashCode classLoaderHash) {
        return ImplementationSnapshot.of(className, classLoaderHash, SerializedLambdaQueries.isLambdaClassName(className), null);
    }

    public static ImplementationSnapshot of(String className, Object value, @Nullable HashCode classLoaderHash) {
        return ImplementationSnapshot.of(className, classLoaderHash, SerializedLambdaQueries.isLambdaClass(value.getClass()), value);
    }

    private static ImplementationSnapshot of(String classIdentifier, @Nullable HashCode classLoaderHash, boolean isLambda, @Nullable Object value) {
        if (classLoaderHash == null) {
            return new UnknownImplementationSnapshot(classIdentifier, UnknownImplementationSnapshot.UnknownReason.UNKNOWN_CLASSLOADER);
        }
        if (isLambda) {
            return SerializedLambdaQueries.serializedLambdaFor(value).map(it -> new LambdaImplementationSnapshot(classLoaderHash, (SerializedLambda)it)).orElseGet(() -> new UnknownImplementationSnapshot(classIdentifier, UnknownImplementationSnapshot.UnknownReason.UNTRACKED_LAMBDA));
        }
        return new ClassImplementationSnapshot(classIdentifier, classLoaderHash);
    }

    protected ImplementationSnapshot(String classIdentifier) {
        this.classIdentifier = classIdentifier;
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    @Nullable
    public abstract HashCode getClassLoaderHash();

    @Override
    public ValueSnapshot snapshot(@Nullable Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot other = snapshotter.snapshot(value);
        if (this.isSameSnapshot(other)) {
            return this;
        }
        return other;
    }

    protected abstract boolean isSameSnapshot(@Nullable Object var1);
}

