/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Namer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAuthenticationContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.toolchain.JavaToolchainRepository;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRepository;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryHandlerInternal;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryInternal;

public class DefaultJavaToolchainRepositoryHandler
implements JavaToolchainRepositoryHandlerInternal {
    private final DefaultNamedDomainObjectList<JavaToolchainRepository> repositories;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;
    private final AuthenticationSchemeRegistry authenticationSchemeRegistry;
    private boolean mutable = true;

    @Inject
    public DefaultJavaToolchainRepositoryHandler(Instantiator instantiator, ObjectFactory objectFactory, ProviderFactory providerFactory, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
        this.repositories = new DefaultNamedDomainObjectList<JavaToolchainRepository>(JavaToolchainRepository.class, instantiator, (Namer)new RepositoryNamer(), CollectionCallbackActionDecorator.NOOP){

            public String getTypeDisplayName() {
                return "repository";
            }
        };
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        this.authenticationSchemeRegistry = authenticationSchemeRegistry;
    }

    @Override
    public void repository(String name, Action<? super JavaToolchainRepository> configureAction) {
        this.assertMutable();
        DefaultAuthenticationContainer authenticationContainer = new DefaultAuthenticationContainer(this.instantiator, CollectionCallbackActionDecorator.NOOP);
        for (Map.Entry e : this.authenticationSchemeRegistry.getRegisteredSchemes().entrySet()) {
            authenticationContainer.registerBinding((Class)e.getKey(), (Class)e.getValue());
        }
        AuthenticationSupporter authenticationSupporter = new AuthenticationSupporter(this.instantiator, this.objectFactory, (AuthenticationContainer)authenticationContainer, this.providerFactory);
        DefaultJavaToolchainRepository repository = (DefaultJavaToolchainRepository)this.objectFactory.newInstance(DefaultJavaToolchainRepository.class, new Object[]{name, authenticationContainer, authenticationSupporter, this.providerFactory});
        configureAction.execute((Object)repository);
        boolean isNew = this.repositories.add((Object)repository);
        if (!isNew) {
            throw new GradleException("Duplicate configuration for repository '" + name + "'.");
        }
    }

    @Override
    public List<JavaToolchainRepository> getAsList() {
        ArrayList copy = this.repositories.stream().map(it -> (JavaToolchainRepositoryInternal)it).map(ImmutableJavaToolchainRepository::new).collect(Collectors.toCollection(ArrayList::new));
        return Collections.unmodifiableList(copy);
    }

    @Override
    public int size() {
        return this.repositories.size();
    }

    @Override
    public boolean remove(String name) {
        this.assertMutable();
        JavaToolchainRepository repository = (JavaToolchainRepository)this.repositories.findByName(name);
        if (repository == null) {
            return false;
        }
        return this.repositories.remove((Object)repository);
    }

    public void preventFromFurtherMutation() {
        this.mutable = false;
    }

    private void assertMutable() {
        if (!this.mutable) {
            throw new InvalidUserCodeException("Mutation of toolchain repositories declared in settings is only allowed during settings evaluation");
        }
    }

    private static class RepositoryNamer
    implements Namer<JavaToolchainRepository> {
        private RepositoryNamer() {
        }

        public String determineName(JavaToolchainRepository repository) {
            return repository.getName();
        }
    }

    private static class ImmutableJavaToolchainRepository
    implements JavaToolchainRepositoryInternal {
        private final JavaToolchainRepositoryInternal delegate;

        public ImmutableJavaToolchainRepository(JavaToolchainRepositoryInternal delegate) {
            this.delegate = delegate;
        }

        @Override
        public Collection<Authentication> getConfiguredAuthentication() {
            return this.delegate.getConfiguredAuthentication();
        }

        public PasswordCredentials getCredentials() {
            return this.delegate.getCredentials();
        }

        public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
            return (T)this.delegate.getCredentials(credentialsType);
        }

        public void credentials(Action<? super PasswordCredentials> action) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        public void credentials(Class<? extends Credentials> credentialsType) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        public void authentication(Action<? super AuthenticationContainer> action) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        public AuthenticationContainer getAuthentication() {
            return this.delegate.getAuthentication();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Property<Class<? extends JavaToolchainResolver>> getResolverClass() {
            return this.delegate.getResolverClass();
        }
    }
}

