/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestFailureDetails;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.util.internal.TextUtil;

@NonNullApi
public class SimpleTestEventLogger
implements TestListenerInternal {
    private final StyledTextOutputFactory textOutputFactory;

    public SimpleTestEventLogger(StyledTextOutputFactory textOutputFactory) {
        this.textOutputFactory = textOutputFactory;
    }

    @Override
    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
    }

    @Override
    public void completed(TestDescriptorInternal descriptor, TestResult result, TestCompleteEvent completeEvent) {
        if (!descriptor.isComposite()) {
            if (result.getResultType() == TestResult.ResultType.FAILURE) {
                StyledTextOutput output = this.textOutputFactory.create(SimpleTestEventLogger.class);
                output.println().append((CharSequence)this.toEventPath((TestDescriptor)descriptor)).append((CharSequence)" ");
                output.withStyle(StyledTextOutput.Style.Failure).println((Object)"FAILED");
                for (TestFailure failure : result.getFailures()) {
                    TestFailureDetails details = failure.getDetails();
                    if (TextUtil.isBlank((String)details.getMessage())) continue;
                    if (details.isAssertionFailure()) {
                        output.append((CharSequence)"    ").withStyle(StyledTextOutput.Style.Failure).println((Object)details.getMessage());
                        continue;
                    }
                    if (details.isFileComparisonFailure()) {
                        output.append((CharSequence)"    Expected: ").withStyle(StyledTextOutput.Style.Failure).println((Object)details.getExpected());
                        output.append((CharSequence)"    Actual: ").withStyle(StyledTextOutput.Style.Success).println((Object)details.getActual());
                        continue;
                    }
                    output.append((CharSequence)"    ").withStyle(StyledTextOutput.Style.Identifier).append((CharSequence)details.getClassName());
                    output.append((CharSequence)": ").println((Object)details.getMessage());
                }
            }
        } else if (descriptor.getParent() == null && result.getFailedTestCount() > 0L) {
            StyledTextOutput output = this.textOutputFactory.create(SimpleTestEventLogger.class);
            output.println();
            if (result.getTestCount() == 1L) {
                output.append((CharSequence)"1 test completed");
            } else {
                output.format("%d tests completed", new Object[]{result.getTestCount()});
            }
            if (result.getSuccessfulTestCount() > 0L) {
                output.format(", %d succeeded", new Object[]{result.getSuccessfulTestCount()});
            }
            if (result.getFailedTestCount() > 0L) {
                output.format(", %d failed", new Object[]{result.getFailedTestCount()});
            }
            if (result.getSkippedTestCount() > 0L) {
                output.format(", %d skipped", new Object[]{result.getSkippedTestCount()});
            }
            output.println();
        }
    }

    @Override
    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
    }

    private String toEventPath(TestDescriptor descriptor) {
        ArrayList<String> names = new ArrayList<String>();
        for (TestDescriptor current = descriptor; current != null; current = current.getParent()) {
            names.add(current.getDisplayName());
        }
        return Joiner.on((String)" > ").join((Iterable)Lists.reverse(names));
    }
}

