/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.evaluation.EvaluationScopeContext;

public class FlatMapProvider<S, T>
extends AbstractMinimalProvider<S> {
    private final ProviderInternal<? extends T> provider;
    private final Transformer<? extends Provider<? extends S>, ? super T> transformer;

    FlatMapProvider(ProviderInternal<? extends T> provider, Transformer<? extends Provider<? extends S>, ? super T> transformer) {
        this.provider = provider;
        this.transformer = transformer;
    }

    @Override
    @Nullable
    public Class<S> getType() {
        return null;
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext context = this.openScope();){
            boolean bl = this.backingProvider(context, consumer).calculatePresence(consumer);
            return bl;
        }
    }

    @Override
    protected ValueSupplier.Value<? extends S> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext context = this.openScope();){
            ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
            if (value.isMissing()) {
                ValueSupplier.Value value2 = value.asType();
                return value2;
            }
            ValueSupplier.Value<S> value3 = this.doMapValue(context, value).calculateValue(consumer);
            return value3;
        }
    }

    private ProviderInternal<? extends S> doMapValue(EvaluationScopeContext context, ValueSupplier.Value<? extends T> value) {
        T unpackedValue = value.getWithoutSideEffect();
        Provider transformedProvider = (Provider)this.transformer.transform(unpackedValue);
        if (transformedProvider == null) {
            return Providers.notDefined();
        }
        return Providers.internal(transformedProvider).withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
    }

    private ProviderInternal<? extends S> backingProvider(EvaluationScopeContext context, ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
        if (value.isMissing()) {
            return Providers.notDefined();
        }
        return this.doMapValue(context, value);
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        try (EvaluationScopeContext context = this.openScope();){
            ValueSupplier.ValueProducer valueProducer = this.backingProvider(context, ValueSupplier.ValueConsumer.IgnoreUnsafeRead).getProducer();
            return valueProducer;
        }
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends S> calculateExecutionTimeValue() {
        try (EvaluationScopeContext context = this.openScope();){
            ValueSupplier.ExecutionTimeValue<S> executionTimeValue = this.backingProvider(context, ValueSupplier.ValueConsumer.IgnoreUnsafeRead).calculateExecutionTimeValue();
            return executionTimeValue;
        }
    }

    @Override
    protected String toStringNoReentrance() {
        return "flatmap(" + this.provider + ")";
    }
}

