/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.util.ArrayList;
import java.util.Optional;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.DefaultFilePropertyFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.archive.DecompressionCoordinator;
import org.gradle.api.internal.file.archive.DefaultDecompressionCoordinator;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.temp.GradleUserHomeTemporaryFileProvider;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.provider.DefaultProviderFactory;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.scopes.ScopedCacheBuilderFactory;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.impl.DefaultDeleter;
import org.gradle.internal.hash.DefaultFileHasher;
import org.gradle.internal.hash.DefaultStreamHasher;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.jvm.inspection.DefaultJavaInstallationRegistry;
import org.gradle.internal.jvm.inspection.DefaultJvmMetadataDetector;
import org.gradle.internal.jvm.inspection.JavaInstallationRegistry;
import org.gradle.internal.jvm.inspection.JvmInstallationProblemReporter;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.resource.ExternalResourceFactory;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.time.Clock;
import org.gradle.jvm.toolchain.internal.AsdfInstallationSupplier;
import org.gradle.jvm.toolchain.internal.DefaultOsXJavaHomeCommand;
import org.gradle.jvm.toolchain.internal.IntellijInstallationSupplier;
import org.gradle.jvm.toolchain.internal.JabbaInstallationSupplier;
import org.gradle.jvm.toolchain.internal.JavaToolchainQueryService;
import org.gradle.jvm.toolchain.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.LinuxInstallationSupplier;
import org.gradle.jvm.toolchain.internal.OsXInstallationSupplier;
import org.gradle.jvm.toolchain.internal.OsXJavaHomeCommand;
import org.gradle.jvm.toolchain.internal.SdkmanInstallationSupplier;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.gradle.jvm.toolchain.internal.WindowsInstallationSupplier;
import org.gradle.jvm.toolchain.internal.install.DefaultJdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainHttpRedirectVerifierFactory;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.install.SecureFileDownloader;
import org.gradle.launcher.daemon.toolchain.DaemonJavaToolchainProvisioningService;
import org.gradle.launcher.daemon.toolchain.DaemonToolchainExternalResourceFactory;
import org.gradle.launcher.daemon.toolchain.ToolchainDownloadUrlProvider;
import org.gradle.platform.internal.CurrentBuildPlatform;
import org.gradle.process.internal.ClientExecHandleBuilderFactory;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;

public class DaemonClientToolchainServices
implements ServiceRegistrationProvider {
    private final ToolchainConfiguration toolchainConfiguration;
    private final ToolchainDownloadUrlProvider toolchainDownloadUrlProvider;
    private final Optional<InternalBuildProgressListener> buildProgressListener;

    public DaemonClientToolchainServices(ToolchainConfiguration toolchainConfiguration, ToolchainDownloadUrlProvider toolchainDownloadUrlProvider, Optional<InternalBuildProgressListener> buildProgressListener) {
        this.toolchainConfiguration = toolchainConfiguration;
        this.toolchainDownloadUrlProvider = toolchainDownloadUrlProvider;
        this.buildProgressListener = buildProgressListener;
    }

    @Provides
    protected Lazy<JavaToolchainQueryService> createJavaToolchainQueryService(JvmMetadataDetector jvmMetadataDetector, FileSystem fileSystem, ListenerManager listenerManager, ProgressLoggerFactory progressLoggerFactory, Clock clock, BuildOperationIdFactory operationIdFactory, GradleUserHomeDirProvider gradleUserHomeDirProvider, TemporaryFileProvider temporaryFileProvider, FileLockManager fileLockManager, ClientExecHandleBuilderFactory execHandleFactory, GradleUserHomeTemporaryFileProvider gradleUserHomeTemporaryFileProvider, FileResolver fileResolver, PropertyHost propertyHost, FileCollectionFactory fileCollectionFactory, DirectoryFileTreeFactory directoryFileTreeFactory, PropertyFactory propertyFactory, DocumentationRegistry documentationRegistry, WindowsRegistry windowsRegistry, OperatingSystem os, SystemInfo systemInfo, ScopedCacheBuilderFactory scopedCacheBuilderFactory) {
        return Lazy.unsafe().of(() -> {
            ArrayList<Object> installationSuppliers = new ArrayList<Object>(8);
            installationSuppliers.add(new AsdfInstallationSupplier(this.toolchainConfiguration));
            installationSuppliers.add(new IntellijInstallationSupplier(this.toolchainConfiguration));
            installationSuppliers.add(new JabbaInstallationSupplier(this.toolchainConfiguration));
            installationSuppliers.add(new SdkmanInstallationSupplier(this.toolchainConfiguration));
            installationSuppliers.add(new LinuxInstallationSupplier());
            installationSuppliers.add(new OsXInstallationSupplier(os, (OsXJavaHomeCommand)new DefaultOsXJavaHomeCommand(execHandleFactory)));
            installationSuppliers.add(new WindowsInstallationSupplier(windowsRegistry, os));
            CurrentBuildPlatform currentBuildPlatform = new CurrentBuildPlatform(systemInfo, os);
            DefaultFilePropertyFactory filePropertyFactory = new DefaultFilePropertyFactory(propertyHost, fileResolver, fileCollectionFactory);
            DefaultDecompressionCoordinator decompressionCoordinator = new DefaultDecompressionCoordinator(scopedCacheBuilderFactory);
            DefaultDeleter deleter = new DefaultDeleter(() -> ((Clock)clock).getCurrentTime(), arg_0 -> ((FileSystem)fileSystem).isSymlink(arg_0), os.isWindows());
            DefaultFileOperations fileOperations = new DefaultFileOperations(fileResolver, DirectInstantiator.INSTANCE, directoryFileTreeFactory, (FileHasher)new DefaultFileHasher((StreamHasher)new DefaultStreamHasher()), DefaultResourceHandler.Factory.from((FileResolver)fileResolver, null, (FileSystem)fileSystem, (TemporaryFileProvider)temporaryFileProvider, null), fileCollectionFactory, propertyFactory, fileSystem, PatternSet::new, (Deleter)deleter, documentationRegistry, DefaultTaskDependencyFactory.withNoAssociatedProject(), (ProviderFactory)new DefaultProviderFactory(), (DecompressionCoordinator)decompressionCoordinator, temporaryFileProvider);
            DefaultJdkCacheDirectory jdkCacheDirectory = new DefaultJdkCacheDirectory(gradleUserHomeDirProvider, (FileOperations)fileOperations, fileLockManager, (JvmMetadataDetector)new DefaultJvmMetadataDetector(execHandleFactory, (TemporaryFileProvider)gradleUserHomeTemporaryFileProvider), gradleUserHomeTemporaryFileProvider);
            DefaultJavaInstallationRegistry javaInstallationRegistry = new DefaultJavaInstallationRegistry(this.toolchainConfiguration, installationSuppliers, jvmMetadataDetector, null, OperatingSystem.current(), progressLoggerFactory, fileResolver, (JdkCacheDirectory)jdkCacheDirectory, new JvmInstallationProblemReporter());
            JavaToolchainHttpRedirectVerifierFactory redirectVerifierFactory = new JavaToolchainHttpRedirectVerifierFactory();
            HttpClientHelper.Factory httpClientHelperFactory = HttpClientHelper.Factory.createFactory((DocumentationRegistry)new DocumentationRegistry());
            DaemonToolchainExternalResourceFactory externalResourceFactory = new DaemonToolchainExternalResourceFactory(fileSystem, listenerManager, redirectVerifierFactory, httpClientHelperFactory, progressLoggerFactory, clock, operationIdFactory, this.buildProgressListener);
            SecureFileDownloader secureFileDownloader = new SecureFileDownloader((ExternalResourceFactory)externalResourceFactory);
            DaemonJavaToolchainProvisioningService javaToolchainProvisioningService = new DaemonJavaToolchainProvisioningService(secureFileDownloader, (JdkCacheDirectory)jdkCacheDirectory, currentBuildPlatform, this.toolchainDownloadUrlProvider, this.toolchainConfiguration.isDownloadEnabled(), progressLoggerFactory);
            return new JavaToolchainQueryService(jvmMetadataDetector, (FileFactory)filePropertyFactory, (JavaToolchainProvisioningService)javaToolchainProvisioningService, (JavaInstallationRegistry)javaInstallationRegistry, null);
        });
    }
}

