/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.clean.WhileConditionFolding;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\tJ\u001a\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/WhileConditionFolding;", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "getBody", "()Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "changed", "", "apply", "hasContinue", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "label", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
public final class WhileConditionFolding {
    @NotNull
    private final JsBlock body;
    private boolean changed;

    public WhileConditionFolding(@NotNull JsBlock body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this.body = body2;
    }

    @NotNull
    public final JsBlock getBody() {
        return this.body;
    }

    public final boolean apply() {
        this.body.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ WhileConditionFolding this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitLabel(JsLabel x) {
                JsStatement innerStatement;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = innerStatement = x.getStatement();
                if (jsStatement instanceof JsWhile) {
                    this.process((JsWhile)innerStatement, x.getName());
                } else if (jsStatement instanceof JsDoWhile) {
                    this.process((JsDoWhile)innerStatement, x.getName());
                } else {
                    super.visitLabel(x);
                }
            }

            public void visitWhile(JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.process(x, null);
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.process(x, null);
            }

            private final void process(JsWhile statement, JsName name2) {
                this.process(statement, name2, (Function1<? super JsStatement, ? extends JsStatement>)((Function1)arg_0 -> apply.1.process$lambda$0(this, arg_0)), (Function1<? super JsStatement, ? extends JsStatement>)((Function1)arg_0 -> apply.1.process$lambda$1(this, arg_0)), (Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function2)apply.1::process$lambda$2));
            }

            private final void process(JsDoWhile statement, JsName name2) {
                JsStatement jsStatement = statement.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getBody(...)");
                if (!WhileConditionFolding.access$hasContinue(this.this$0, jsStatement, name2)) {
                    this.process(statement, name2, (Function1<? super JsStatement, ? extends JsStatement>)((Function1)arg_0 -> apply.1.process$lambda$3(this, arg_0)), (Function1<? super JsStatement, ? extends JsStatement>)((Function1)arg_0 -> apply.1.process$lambda$4(this, arg_0)), (Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function2)apply.1::process$lambda$5));
                }
            }

            private final void process(JsWhile statement, JsName name2, Function1<? super JsStatement, ? extends JsStatement> find, Function1<? super JsStatement, ? extends JsStatement> remove, Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression> combine) {
                boolean optimized;
                statement.getBody().accept(this);
                do {
                    JsExpression jsExpression;
                    optimized = false;
                    JsStatement jsStatement = statement.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getBody(...)");
                    JsStatement first = (JsStatement)find.invoke((Object)jsStatement);
                    JsExpression condition = this.extractCondition(first, name2);
                    if (condition == null) continue;
                    JsStatement jsStatement2 = statement.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getBody(...)");
                    statement.setBody((JsStatement)remove.invoke((Object)jsStatement2));
                    JsExpression existingCondition = statement.getCondition();
                    if (JsBooleanLiteral.isTrue(existingCondition)) {
                        jsExpression = condition;
                    } else {
                        Intrinsics.checkNotNull((Object)existingCondition);
                        jsExpression = (JsExpression)combine.invoke((Object)existingCondition, (Object)condition);
                    }
                    statement.setCondition(jsExpression);
                    WhileConditionFolding.access$setChanged$p(this.this$0, true);
                    optimized = true;
                } while (optimized);
            }

            private final JsExpression extractCondition(JsStatement statement, JsName label) {
                JsExpression jsExpression;
                JsStatement jsStatement = statement;
                if (jsStatement instanceof JsBreak) {
                    JsNameRef jsNameRef = ((JsBreak)statement).getLabel();
                    JsName target = jsNameRef != null ? jsNameRef.getName() : null;
                    jsExpression = Intrinsics.areEqual((Object)label, (Object)target) ? new JsBooleanLiteral(false) : null;
                } else if (jsStatement instanceof JsIf) {
                    JsStatement jsStatement2 = ((JsIf)statement).getThenStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"getThenStatement(...)");
                    JsStatement then = jsStatement2;
                    if (((JsIf)statement).getElseStatement() == null) {
                        JsExpression result2;
                        JsExpression nextCondition = this.extractCondition(then, label);
                        jsExpression = result2 = nextCondition == null ? null : (JsBooleanLiteral.isFalse(nextCondition) ? JsAstUtils.notOptimized(((JsIf)statement).getIfExpression()) : (JsExpression)JsAstUtils.or(JsAstUtils.notOptimized(((JsIf)statement).getIfExpression()), nextCondition));
                    } else {
                        jsExpression = null;
                    }
                } else if (jsStatement instanceof JsBlock) {
                    if (((JsBlock)statement).getStatements().size() == 1) {
                        JsStatement jsStatement3 = ((JsBlock)statement).getStatements().get(0);
                        Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"get(...)");
                        jsExpression = this.extractCondition(jsStatement3, label);
                    } else {
                        jsExpression = null;
                    }
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }

            private final JsStatement first(JsStatement statement) {
                JsStatement jsStatement;
                if (statement instanceof JsBlock) {
                    List<JsStatement> list = ((JsBlock)statement).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                    jsStatement = (JsStatement)CollectionsKt.firstOrNull(list);
                    if (jsStatement == null) {
                        jsStatement = statement;
                    }
                } else {
                    jsStatement = statement;
                }
                return jsStatement;
            }

            private final JsBlock removeFirst(JsStatement statement) {
                JsBlock jsBlock;
                if (statement instanceof JsBlock) {
                    List<JsStatement> list = ((JsBlock)statement).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                    List<JsStatement> statements = list;
                    if (!((Collection)statements).isEmpty()) {
                        statements.remove(0);
                    }
                    jsBlock = (JsBlock)statement;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            private final JsStatement last(JsStatement statement) {
                JsStatement jsStatement;
                if (statement instanceof JsBlock) {
                    List<JsStatement> list = ((JsBlock)statement).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                    jsStatement = (JsStatement)CollectionsKt.lastOrNull(list);
                    if (jsStatement == null) {
                        jsStatement = statement;
                    }
                } else {
                    jsStatement = statement;
                }
                return jsStatement;
            }

            private final JsBlock removeLast(JsStatement statement) {
                JsBlock jsBlock;
                if (statement instanceof JsBlock) {
                    List<JsStatement> list = ((JsBlock)statement).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                    List<JsStatement> statements = list;
                    if (!((Collection)statements).isEmpty()) {
                        statements.remove(CollectionsKt.getLastIndex(statements));
                    }
                    jsBlock = (JsBlock)statement;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            private static final JsStatement process$lambda$0(apply.1 this$0, JsStatement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this$0.first(it);
            }

            private static final JsStatement process$lambda$1(apply.1 this$0, JsStatement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this$0.removeFirst(it);
            }

            private static final JsExpression process$lambda$2(JsExpression a, JsExpression b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                JsBinaryOperation jsBinaryOperation = JsAstUtils.and(a, b);
                Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"and(...)");
                return jsBinaryOperation;
            }

            private static final JsStatement process$lambda$3(apply.1 this$0, JsStatement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this$0.last(it);
            }

            private static final JsStatement process$lambda$4(apply.1 this$0, JsStatement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this$0.removeLast(it);
            }

            private static final JsExpression process$lambda$5(JsExpression a, JsExpression b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                JsBinaryOperation jsBinaryOperation = JsAstUtils.and(b, a);
                Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"and(...)");
                return jsBinaryOperation;
            }
        });
        return this.changed;
    }

    private final boolean hasContinue(JsStatement statement, JsName label) {
        Ref.BooleanRef found = new Ref.BooleanRef();
        statement.accept(new RecursiveJsVisitor(found, label){
            private int level;
            final /* synthetic */ Ref.BooleanRef $found;
            final /* synthetic */ JsName $label;
            {
                this.$found = $found;
                this.$label = $label;
            }

            public void visitContinue(JsContinue x) {
                JsName name2;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = name2 = jsNameRef != null ? jsNameRef.getName() : null;
                if (name2 == null) {
                    if (this.level == 0) {
                        this.$found.element = true;
                    }
                } else if (Intrinsics.areEqual((Object)name2, (Object)this.$label)) {
                    this.$found.element = true;
                }
            }

            public void visitFor(JsFor x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitFor(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitWhile(JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitDoWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitForIn(JsForIn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.level;
                this.level = n + 1;
                super.visitForIn(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            protected void visitElement(JsNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!this.$found.element) {
                    super.visitElement(node);
                }
            }
        });
        return found.element;
    }

    public static final /* synthetic */ boolean access$hasContinue(WhileConditionFolding $this, JsStatement statement, JsName label) {
        return $this.hasContinue(statement, label);
    }

    public static final /* synthetic */ void access$setChanged$p(WhileConditionFolding $this, boolean bl) {
        $this.changed = bl;
    }
}

