/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.TransformationChain;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class DefaultVariantDefinition
implements VariantDefinition {
    private final DefaultVariantDefinition previous;
    private final ImmutableAttributes attributes;
    private final TransformationChain transformationChain;
    private final TransformationStep transformationStep;

    public DefaultVariantDefinition(@Nullable DefaultVariantDefinition previous, ImmutableAttributes attributes, TransformationStep transformationStep) {
        this.previous = previous;
        this.attributes = attributes;
        this.transformationChain = new TransformationChain(previous == null ? null : previous.getTransformationChain(), transformationStep);
        this.transformationStep = transformationStep;
    }

    @Override
    public ImmutableAttributes getTargetAttributes() {
        return this.attributes;
    }

    @Override
    public TransformationChain getTransformationChain() {
        return this.transformationChain;
    }

    @Override
    public TransformationStep getTransformationStep() {
        return this.transformationStep;
    }

    @Override
    @Nullable
    public VariantDefinition getPrevious() {
        return this.previous;
    }

    private int getDepth() {
        return this.previous == null ? 1 : this.previous.getDepth() + 1;
    }

    public String toString() {
        if (this.previous != null) {
            return this.previous + " <- (" + this.getDepth() + ") " + this.transformationStep;
        }
        return "(" + this.getDepth() + ") " + this.transformationStep;
    }
}

