/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassIdWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilderKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinNameReferenceExpressionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeProjectionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001c\u0010\u000e\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0011\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J*\u0010\u0017\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\fH\u0002J0\u0010\u001d\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\n0\u001f0\fJ6\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\n0\u001f0\f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\fJ\u0018\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020#H\u0002J2\u0010(\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020 2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J4\u0010)\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0+J4\u0010,\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\f2\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u0010\t\u001a\u00020\nH\u0002J \u00106\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u00107\u001a\u00020\u0015*\u00020\nH\u0002J\f\u00108\u001a\u000209*\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder;", "", "c", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;)V", "createClassReferenceTypeStub", "", "parent", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl;", "type", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "annotations", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClassIdWithTarget;", "createDefinitelyNotNullTypeStub", "name", "Lorg/jetbrains/kotlin/name/FqName;", "createFunctionTypeStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isExtensionFunctionType", "", "isSuspend", "createTypeAnnotationStubs", "createTypeArgumentListStub", "typeStub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinUserTypeStub;", "typeArgumentProtoList", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "createTypeConstraintListStub", "protosForTypeConstraintList", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/Name;", "createTypeParameterListStub", "typeParameterProtoList", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "createTypeParameterModifierListStub", "typeParameterStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeParameterStubImpl;", "typeParameterProto", "createTypeParameterStub", "createTypeReferenceStub", "additionalAnnotations", "Lkotlin/Function0;", "createValueParameterListStub", "callableProto", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "parameters", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter;", "container", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "getTypeModifiersAsWritten", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "nullableTypeParent", "isDefaultUpperBound", "toProjectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument$Projection;", "decompiler-to-stubs"})
@SourceDebugExtension(value={"SMAP\nTypeClsStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n819#2:358\n847#2,2:359\n1549#2:361\n1620#2,3:362\n2624#2,3:365\n3190#2,10:368\n1855#2,2:378\n1549#2:380\n1620#2,3:381\n1#3:384\n*S KotlinDebug\n*F\n+ 1 TypeClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/TypeClsStubBuilder\n*L\n46#1:358\n46#1:359,2\n51#1:361\n51#1:362,3\n105#1:365,3\n107#1:368,10\n162#1:378,2\n302#1:380\n302#1:381,3\n*E\n"})
public final class TypeClsStubBuilder {
    @NotNull
    private final ClsStubBuilderContext c;

    public TypeClsStubBuilder(@NotNull ClsStubBuilderContext c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.c = c;
    }

    /*
     * WARNING - void declaration
     */
    public final void createTypeReferenceStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ProtoBuf.Type type2, @NotNull Function0<? extends List<ClassIdWithTarget>> additionalAnnotations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(additionalAnnotations, (String)"additionalAnnotations");
        ProtoBuf.Type abbreviatedType = ProtoTypeTableUtilKt.abbreviatedType(type2, this.c.getTypeTable());
        if (abbreviatedType != null) {
            this.createTypeReferenceStub(parent2, abbreviatedType, additionalAnnotations);
            return;
        }
        KotlinPlaceHolderStubImpl typeReference = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.TYPE_REFERENCE);
        Iterable $this$filterNot$iv = this.c.getComponents().getAnnotationLoader().loadTypeAnnotations(type2, this.c.getNameResolver());
        boolean $i$f$filterNot22 = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ClassId it = (ClassId)element$iv$iv;
            boolean bl = false;
            boolean isTopLevelClass = !it.isNestedClass();
            if (isTopLevelClass && TypeClsStubBuilderKt.access$getANNOTATIONS_NOT_LOADED_FOR_TYPES$p().contains(it.asSingleFqName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List annotations2 = (List)destination$iv$iv;
        Iterable $i$f$filterNot22 = annotations2;
        Collection collection = (Collection)additionalAnnotations.invoke();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassId bl = (ClassId)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(new ClassIdWithTarget((ClassId)it, null));
        }
        List allAnnotations = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
        if (type2.hasClassName() || type2.hasTypeAliasName()) {
            this.createClassReferenceTypeStub(typeReference, type2, allAnnotations);
        } else if (type2.hasTypeParameter()) {
            this.createTypeParameterStub(typeReference, type2, this.c.getTypeParameters().get(type2.getTypeParameter()), allAnnotations);
        } else if (type2.hasTypeParameterName()) {
            this.createTypeParameterStub(typeReference, type2, NameResolverUtilKt.getName(this.c.getNameResolver(), type2.getTypeParameterName()), allAnnotations);
        } else {
            FunctionsKt.doNothing();
        }
    }

    public static /* synthetic */ void createTypeReferenceStub$default(TypeClsStubBuilder typeClsStubBuilder, StubElement stubElement, ProtoBuf.Type type2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = createTypeReferenceStub.1.INSTANCE;
        }
        typeClsStubBuilder.createTypeReferenceStub(stubElement, type2, (Function0<? extends List<ClassIdWithTarget>>)function0);
    }

    private final KotlinStubBaseImpl<?> nullableTypeParent(KotlinStubBaseImpl<?> parent2, ProtoBuf.Type type2) {
        return type2.getNullable() ? (KotlinStubBaseImpl)new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.NULLABLE_TYPE) : parent2;
    }

    private final void createTypeParameterStub(KotlinStubBaseImpl<?> parent2, ProtoBuf.Type type2, Name name, List<ClassIdWithTarget> annotations2) {
        this.createTypeAnnotationStubs(parent2, type2, annotations2);
        Boolean bl = Flags.DEFINITELY_NOT_NULL_TYPE.get(type2.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"DEFINITELY_NOT_NULL_TYPE.get(type.flags)");
        if (bl.booleanValue()) {
            FqName fqName2 = FqName.topLevel(name);
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"topLevel(name)");
            this.createDefinitelyNotNullTypeStub(parent2, fqName2);
        } else {
            KotlinStubBaseImpl<?> nullableParentWrapper = this.nullableTypeParent(parent2, type2);
            ClassId classId = ClassId.topLevel(FqName.topLevel(name));
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName.topLevel(name))");
            ClsStubBuildingKt.createStubForTypeName$default(classId, nullableParentWrapper, null, 4, null);
        }
    }

    private final void createDefinitelyNotNullTypeStub(KotlinStubBaseImpl<?> parent2, FqName name) {
        KotlinPlaceHolderStubImpl intersectionType2 = new KotlinPlaceHolderStubImpl(parent2, KtStubElementTypes.INTERSECTION_TYPE);
        KotlinPlaceHolderStubImpl leftReference = new KotlinPlaceHolderStubImpl((StubElement)intersectionType2, KtStubElementTypes.TYPE_REFERENCE);
        ClassId classId = ClassId.topLevel(name);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(name)");
        ClsStubBuildingKt.createStubForTypeName$default(classId, leftReference, null, 4, null);
        KotlinPlaceHolderStubImpl rightReference = new KotlinPlaceHolderStubImpl((StubElement)intersectionType2, KtStubElementTypes.TYPE_REFERENCE);
        KotlinUserTypeStubImpl userType = new KotlinUserTypeStubImpl(rightReference);
        StubElement stubElement = userType;
        Name name2 = StandardNames.FqNames.any.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"any.shortName()");
        new KotlinNameReferenceExpressionStubImpl(stubElement, ClsStubBuildingKt.ref(name2));
    }

    /*
     * Unable to fully structure code
     */
    private final void createClassReferenceTypeStub(KotlinStubBaseImpl<?> parent, ProtoBuf.Type type, List<ClassIdWithTarget> annotations) {
        block12: {
            if (type.hasFlexibleTypeCapabilitiesId() && Intrinsics.areEqual((Object)(id = this.c.getNameResolver().getString(type.getFlexibleTypeCapabilitiesId())), (Object)"kotlin.DynamicType")) {
                new KotlinPlaceHolderStubImpl<T>(this.nullableTypeParent(parent, type), KtStubElementTypes.DYNAMIC_TYPE);
                return;
            }
            v0 = id = type.hasClassName() != false || type.hasTypeAliasName() != false;
            if (_Assertions.ENABLED && !id) {
                $i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1 = false;
                $i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1 = "Class reference stub must have either class or type alias name";
                throw new AssertionError((Object)$i$a$-assert-TypeClsStubBuilder$createClassReferenceTypeStub$1);
            }
            classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), type.hasClassName() != false ? type.getClassName() : type.getTypeAliasName());
            if (!FunctionTypesKt.isBuiltinFunctionClass(classId)) ** GOTO lbl-1000
            v1 = type.getArgumentList();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"type.argumentList");
            $this$none$iv = v1;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (ProtoBuf.Type.Argument)element$iv;
                    $i$a$-none-TypeClsStubBuilder$createClassReferenceTypeStub$shouldBuildAsFunctionType$1 = false;
                    if (!(it.getProjection() == ProtoBuf.Type.Argument.Projection.STAR)) continue;
                    v2 = false;
                    break block12;
                }
                v2 = true;
            }
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = shouldBuildAsFunctionType = false;
        }
        if (shouldBuildAsFunctionType) {
            $this$partition$iv = annotations;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (ClassIdWithTarget)element$iv;
                $i$a$-partition-TypeClsStubBuilder$createClassReferenceTypeStub$2 = false;
                if (Intrinsics.areEqual((Object)it.getClassId().asSingleFqName(), (Object)StandardNames.FqNames.extensionFunctionType)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            $this$none$iv = new Pair(first$iv, second$iv);
            extensionAnnotations = (List)$this$none$iv.component1();
            notExtensionAnnotations = (List)$this$none$iv.component2();
            isExtension = ((Collection)extensionAnnotations).isEmpty() == false;
            v4 = Flags.SUSPEND_TYPE.get(type.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"SUSPEND_TYPE.get(type.flags)");
            isSuspend = v4;
            if (isSuspend) {
                wrapper = this.nullableTypeParent(parent, type);
                this.createTypeAnnotationStubs(wrapper, type, notExtensionAnnotations);
                v5 = wrapper;
            } else {
                this.createTypeAnnotationStubs(parent, type, notExtensionAnnotations);
                v5 = this.nullableTypeParent(parent, type);
            }
            nullableWrapper = v5;
            this.createFunctionTypeStub((StubElement<? extends PsiElement>)nullableWrapper, type, isExtension, isSuspend);
            return;
        }
        this.createTypeAnnotationStubs(parent, type, annotations);
        outerTypeChain = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)type, (Function1)((Function1)new Function1<ProtoBuf.Type, ProtoBuf.Type>(this){
            final /* synthetic */ TypeClsStubBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ProtoBuf.Type invoke(@NotNull ProtoBuf.Type it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ProtoTypeTableUtilKt.outerType(it, TypeClsStubBuilder.access$getC$p(this.this$0).getTypeTable());
            }
        })));
        ClsStubBuildingKt.createStubForTypeName(classId, (StubElement<? extends PsiElement>)this.nullableTypeParent(parent, type), (Function2<? super KotlinUserTypeStub, ? super Integer, Unit>)((Function2)new Function2<KotlinUserTypeStub, Integer, Unit>((List<ProtoBuf.Type>)outerTypeChain, this){
            final /* synthetic */ List<ProtoBuf.Type> $outerTypeChain;
            final /* synthetic */ TypeClsStubBuilder this$0;
            {
                this.$outerTypeChain = $outerTypeChain;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull KotlinUserTypeStub userTypeStub, int index2) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)userTypeStub, (String)"userTypeStub");
                    ProtoBuf.Type type2 = (ProtoBuf.Type)CollectionsKt.getOrNull(this.$outerTypeChain, (int)index2);
                    if (type2 == null) break block0;
                    ProtoBuf.Type type3 = type2;
                    TypeClsStubBuilder typeClsStubBuilder = this.this$0;
                    ProtoBuf.Type it = type3;
                    boolean bl = false;
                    List<ProtoBuf.Type.Argument> list2 = it.getArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"it.argumentList");
                    TypeClsStubBuilder.access$createTypeArgumentListStub(typeClsStubBuilder, userTypeStub, list2);
                }
            }
        }));
    }

    private final void createTypeAnnotationStubs(KotlinStubBaseImpl<?> parent2, ProtoBuf.Type type2, List<ClassIdWithTarget> annotations2) {
        Set<KtModifierKeywordToken> typeModifiers = this.getTypeModifiersAsWritten(type2);
        if (annotations2.isEmpty() && typeModifiers.isEmpty()) {
            return;
        }
        long typeModifiersMask2 = ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, Boolean>)((Function1)new Function1<KtModifierKeywordToken, Boolean>(typeModifiers){
            final /* synthetic */ Set<KtModifierKeywordToken> $typeModifiers;
            {
                this.$typeModifiers = $typeModifiers;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtModifierKeywordToken it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$typeModifiers.contains(it);
            }
        }));
        KotlinModifierListStubImpl modifiersList = new KotlinModifierListStubImpl(parent2, typeModifiersMask2, KtStubElementTypes.MODIFIER_LIST);
        ClsStubBuildingKt.createTargetedAnnotationStubs(annotations2, modifiersList);
    }

    private final Set<KtModifierKeywordToken> getTypeModifiersAsWritten(ProtoBuf.Type type2) {
        if (!type2.hasClassName() && !type2.hasTypeAliasName()) {
            return SetsKt.emptySet();
        }
        HashSet<KtModifierKeywordToken> result2 = new HashSet<KtModifierKeywordToken>();
        Boolean bl = Flags.SUSPEND_TYPE.get(type2.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"SUSPEND_TYPE.get(type.flags)");
        if (bl.booleanValue()) {
            result2.add(KtTokens.SUSPEND_KEYWORD);
        }
        return result2;
    }

    private final void createTypeArgumentListStub(KotlinUserTypeStub typeStub, List<ProtoBuf.Type.Argument> typeArgumentProtoList) {
        if (typeArgumentProtoList.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl typeArgumentsListStub = new KotlinPlaceHolderStubImpl((StubElement)typeStub, KtStubElementTypes.TYPE_ARGUMENT_LIST);
        Iterable $this$forEach$iv = typeArgumentProtoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtoBuf.Type.Argument typeArgumentProto = (ProtoBuf.Type.Argument)element$iv;
            boolean bl = false;
            ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
            Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"typeArgumentProto.projection");
            KtProjectionKind projectionKind = this.toProjectionKind(projection);
            KotlinTypeProjectionStubImpl typeProjection = new KotlinTypeProjectionStubImpl((StubElement)typeArgumentsListStub, projectionKind.ordinal());
            if (projectionKind == KtProjectionKind.STAR) continue;
            KtSingleValueToken ktSingleValueToken = projectionKind.getToken();
            KtModifierKeywordToken modifierKeywordToken = ktSingleValueToken instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)ktSingleValueToken : null;
            ClsStubBuildingKt.createModifierListStub(typeProjection, CollectionsKt.listOfNotNull((Object)modifierKeywordToken));
            StubElement stubElement = typeProjection;
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type2);
            TypeClsStubBuilder.createTypeReferenceStub$default(this, stubElement, type2, null, 4, null);
        }
    }

    private final KtProjectionKind toProjectionKind(ProtoBuf.Type.Argument.Projection $this$toProjectionKind) {
        KtProjectionKind ktProjectionKind;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toProjectionKind.ordinal()]) {
            case 1: {
                ktProjectionKind = KtProjectionKind.IN;
                break;
            }
            case 2: {
                ktProjectionKind = KtProjectionKind.OUT;
                break;
            }
            case 3: {
                ktProjectionKind = KtProjectionKind.NONE;
                break;
            }
            case 4: {
                ktProjectionKind = KtProjectionKind.STAR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktProjectionKind;
    }

    private final void createFunctionTypeStub(StubElement<? extends PsiElement> parent2, ProtoBuf.Type type2, boolean isExtensionFunctionType, boolean isSuspend) {
        List<ProtoBuf.Type.Argument> typeArgumentList = type2.getArgumentList();
        KotlinPlaceHolderStubImpl functionType = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.FUNCTION_TYPE);
        if (isExtensionFunctionType) {
            KotlinPlaceHolderStubImpl functionTypeReceiverStub = new KotlinPlaceHolderStubImpl((StubElement)functionType, KtStubElementTypes.FUNCTION_TYPE_RECEIVER);
            Intrinsics.checkNotNullExpressionValue(typeArgumentList, (String)"typeArgumentList");
            Object object = CollectionsKt.first(typeArgumentList);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeArgumentList.first()");
            ProtoBuf.Type type3 = ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)object, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type3);
            ProtoBuf.Type receiverTypeProto = type3;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionTypeReceiverStub, receiverTypeProto, null, 4, null);
        }
        KotlinPlaceHolderStubImpl parameterList2 = new KotlinPlaceHolderStubImpl((StubElement)functionType, KtStubElementTypes.VALUE_PARAMETER_LIST);
        List<ProtoBuf.Type.Argument> typeArgumentsWithoutReceiverAndReturnType = typeArgumentList.subList(isExtensionFunctionType ? 1 : 0, typeArgumentList.size() - 1);
        ProtoBuf.Type suspendParameterType = null;
        Iterator<ProtoBuf.Type.Argument> iterator2 = typeArgumentsWithoutReceiverAndReturnType.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            ProtoBuf.Type.Argument argument2 = iterator2.next();
            if (isSuspend && index2 == typeArgumentsWithoutReceiverAndReturnType.size() - 1) {
                ProtoBuf.Type parameterType;
                Intrinsics.checkNotNullExpressionValue((Object)argument2, (String)"argument");
                Intrinsics.checkNotNull((Object)ProtoTypeTableUtilKt.type(argument2, this.c.getTypeTable()));
                if (parameterType.hasClassName() && parameterType.getArgumentCount() == 1) {
                    FqName fqName2;
                    boolean bl;
                    ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), parameterType.getClassName());
                    Intrinsics.checkNotNullExpressionValue((Object)classId.asSingleFqName(), (String)"classId.asSingleFqName()");
                    boolean bl2 = bl = Intrinsics.areEqual((Object)fqName2, (Object)new FqName("kotlin.coroutines.Continuation")) || Intrinsics.areEqual((Object)fqName2, (Object)new FqName("kotlin.coroutines.experimental.Continuation"));
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = "Last parameter type of suspend function must be Continuation, but it is " + fqName2;
                        throw new AssertionError((Object)string2);
                    }
                    suspendParameterType = parameterType;
                    continue;
                }
            }
            KotlinParameterStubImpl parameter = new KotlinParameterStubImpl(parameterList2, null, null, false, false, false);
            StubElement stubElement = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)argument2, (String)"argument");
            ProtoBuf.Type type4 = ProtoTypeTableUtilKt.type(argument2, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type4);
            TypeClsStubBuilder.createTypeReferenceStub$default(this, stubElement, type4, null, 4, null);
        }
        if (suspendParameterType == null) {
            Intrinsics.checkNotNullExpressionValue(typeArgumentList, (String)"typeArgumentList");
            Object object = CollectionsKt.last(typeArgumentList);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeArgumentList.last()");
            ProtoBuf.Type type5 = ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)object, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type5);
            ProtoBuf.Type returnType2 = type5;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionType, returnType2, null, 4, null);
        } else {
            ProtoBuf.Type.Argument argument3 = suspendParameterType.getArgument(0);
            Intrinsics.checkNotNullExpressionValue((Object)argument3, (String)"suspendParameterType.getArgument(0)");
            ProtoBuf.Type type6 = ProtoTypeTableUtilKt.type(argument3, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type6);
            ProtoBuf.Type continuationArgumentType = type6;
            TypeClsStubBuilder.createTypeReferenceStub$default(this, functionType, continuationArgumentType, null, 4, null);
        }
    }

    public final void createValueParameterListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull MessageLite callableProto, @NotNull List<ProtoBuf.ValueParameter> parameters2, @NotNull ProtoContainer container) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)callableProto, (String)"callableProto");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KotlinPlaceHolderStubImpl parameterListStub = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.VALUE_PARAMETER_LIST);
        Iterator<ProtoBuf.ValueParameter> iterator2 = parameters2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            List<ClassId> parameterAnnotations;
            int index2 = n++;
            ProtoBuf.ValueParameter valueParameterProto = iterator2.next();
            Name name = NameResolverUtilKt.getName(this.c.getNameResolver(), valueParameterProto.getName());
            StringRef stringRef = ClsStubBuildingKt.ref(name);
            KotlinParameterStubImpl parameterStub = new KotlinParameterStubImpl(parameterListStub, null, stringRef, false, false, false);
            ProtoBuf.Type varargElementType2 = ProtoTypeTableUtilKt.varargElementType(valueParameterProto, this.c.getTypeTable());
            ProtoBuf.Type type2 = varargElementType2;
            if (type2 == null) {
                type2 = ProtoTypeTableUtilKt.type(valueParameterProto, this.c.getTypeTable());
            }
            ProtoBuf.Type typeProto = type2;
            ArrayList<KtModifierKeywordToken> modifiers = new ArrayList<KtModifierKeywordToken>();
            if (varargElementType2 != null) {
                modifiers.add(KtTokens.VARARG_KEYWORD);
            }
            Boolean bl = Flags.IS_CROSSINLINE.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"IS_CROSSINLINE.get(valueParameterProto.flags)");
            if (bl.booleanValue()) {
                modifiers.add(KtTokens.CROSSINLINE_KEYWORD);
            }
            Boolean bl2 = Flags.IS_NOINLINE.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"IS_NOINLINE.get(valueParameterProto.flags)");
            if (bl2.booleanValue()) {
                modifiers.add(KtTokens.NOINLINE_KEYWORD);
            }
            KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStub(parameterStub, (Collection<KtModifierKeywordToken>)modifiers);
            Boolean bl3 = Flags.HAS_ANNOTATIONS.get(valueParameterProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"HAS_ANNOTATIONS.get(valueParameterProto.flags)");
            if (bl3.booleanValue() && !((Collection)(parameterAnnotations = this.c.getComponents().getAnnotationLoader().loadValueParameterAnnotations(container, callableProto, ClsStubBuildingKt.getAnnotatedCallableKind(callableProto), index2, valueParameterProto))).isEmpty()) {
                KotlinModifierListStubImpl kotlinModifierListStubImpl = modifierList2;
                if (kotlinModifierListStubImpl == null) {
                    kotlinModifierListStubImpl = ClsStubBuildingKt.createEmptyModifierListStub(parameterStub);
                }
                ClsStubBuildingKt.createAnnotationStubs(parameterAnnotations, kotlinModifierListStubImpl);
            }
            TypeClsStubBuilder.createTypeReferenceStub$default(this, parameterStub, typeProto, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Name, ProtoBuf.Type>> createTypeParameterListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtoList) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(typeParameterProtoList, (String)"typeParameterProtoList");
        if (typeParameterProtoList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KotlinPlaceHolderStubImpl typeParameterListStub = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.TYPE_PARAMETER_LIST);
        ArrayList protosForTypeConstraintList = new ArrayList();
        for (ProtoBuf.TypeParameter proto : typeParameterProtoList) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Name name = NameResolverUtilKt.getName(this.c.getNameResolver(), proto.getName());
            KotlinTypeParameterStubImpl typeParameterStub = new KotlinTypeParameterStubImpl(typeParameterListStub, ClsStubBuildingKt.ref(name), proto.getVariance() == ProtoBuf.TypeParameter.Variance.IN, proto.getVariance() == ProtoBuf.TypeParameter.Variance.OUT);
            this.createTypeParameterModifierListStub(typeParameterStub, proto);
            List<ProtoBuf.Type> upperBoundProtos = ProtoTypeTableUtilKt.upperBounds(proto, this.c.getTypeTable());
            if (!(!((Collection)upperBoundProtos).isEmpty())) continue;
            ProtoBuf.Type upperBound = (ProtoBuf.Type)CollectionsKt.first(upperBoundProtos);
            if (!this.isDefaultUpperBound(upperBound)) {
                TypeClsStubBuilder.createTypeReferenceStub$default(this, typeParameterStub, upperBound, null, 4, null);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)upperBoundProtos, (int)1);
            ArrayList arrayList = protosForTypeConstraintList;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)name, (Object)it));
            }
            arrayList.addAll((List)destination$iv$iv);
        }
        return protosForTypeConstraintList;
    }

    public final void createTypeConstraintListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull List<Pair<Name, ProtoBuf.Type>> protosForTypeConstraintList) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(protosForTypeConstraintList, (String)"protosForTypeConstraintList");
        if (protosForTypeConstraintList.isEmpty()) {
            return;
        }
        KotlinPlaceHolderStubImpl typeConstraintListStub = new KotlinPlaceHolderStubImpl((StubElement)parent2, KtStubElementTypes.TYPE_CONSTRAINT_LIST);
        for (Pair<Name, ProtoBuf.Type> pair : protosForTypeConstraintList) {
            Name name = (Name)pair.component1();
            ProtoBuf.Type type2 = (ProtoBuf.Type)pair.component2();
            KotlinPlaceHolderStubImpl typeConstraintStub = new KotlinPlaceHolderStubImpl((StubElement)typeConstraintListStub, KtStubElementTypes.TYPE_CONSTRAINT);
            new KotlinNameReferenceExpressionStubImpl((StubElement)typeConstraintStub, ClsStubBuildingKt.ref(name));
            TypeClsStubBuilder.createTypeReferenceStub$default(this, typeConstraintStub, type2, null, 4, null);
        }
    }

    private final void createTypeParameterModifierListStub(KotlinTypeParameterStubImpl typeParameterStub, ProtoBuf.TypeParameter typeParameterProto) {
        ArrayList<KtModifierKeywordToken> modifiers = new ArrayList<KtModifierKeywordToken>();
        ProtoBuf.TypeParameter.Variance variance = typeParameterProto.getVariance();
        switch (variance == null ? -1 : WhenMappings.$EnumSwitchMapping$1[variance.ordinal()]) {
            case 1: {
                modifiers.add(KtTokens.IN_KEYWORD);
                break;
            }
            case 2: {
                modifiers.add(KtTokens.OUT_KEYWORD);
            }
        }
        if (typeParameterProto.getReified()) {
            modifiers.add(KtTokens.REIFIED_KEYWORD);
        }
        KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStub(typeParameterStub, (Collection<KtModifierKeywordToken>)modifiers);
        List<ClassId> annotations2 = this.c.getComponents().getAnnotationLoader().loadTypeParameterAnnotations(typeParameterProto, this.c.getNameResolver());
        if (!((Collection)annotations2).isEmpty()) {
            KotlinModifierListStubImpl kotlinModifierListStubImpl = modifierList2;
            if (kotlinModifierListStubImpl == null) {
                kotlinModifierListStubImpl = ClsStubBuildingKt.createEmptyModifierListStub(typeParameterStub);
            }
            ClsStubBuildingKt.createAnnotationStubs(annotations2, kotlinModifierListStubImpl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefaultUpperBound(ProtoBuf.Type $this$isDefaultUpperBound) {
        if (!$this$isDefaultUpperBound.hasClassName()) return false;
        ClassId it = NameResolverUtilKt.getClassId(this.c.getNameResolver(), $this$isDefaultUpperBound.getClassName());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)StandardNames.FqNames.any, (Object)it.asSingleFqName().toUnsafe())) return false;
        if (!$this$isDefaultUpperBound.getNullable()) return false;
        return true;
    }

    public static final /* synthetic */ ClsStubBuilderContext access$getC$p(TypeClsStubBuilder $this) {
        return $this.c;
    }

    public static final /* synthetic */ void access$createTypeArgumentListStub(TypeClsStubBuilder $this, KotlinUserTypeStub typeStub, List typeArgumentProtoList) {
        $this.createTypeArgumentListStub(typeStub, typeArgumentProtoList);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProtoBuf.Type.Argument.Projection.values().length];
            try {
                nArray[ProtoBuf.Type.Argument.Projection.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Type.Argument.Projection.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.TypeParameter.Variance.values().length];
            try {
                nArray[ProtoBuf.TypeParameter.Variance.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

