/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionStatelessCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintInjector;
import org.jetbrains.kotlin.resolve.calls.inference.components.SimpleConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.tower.CallableReferenceKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolutionOldInferenceKt;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCall;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallImpl;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J \u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0016\u0010'\u001a\u00020\u00182\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0012\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionStatelessCallbacksImpl;", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionStatelessCallbacks;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "(Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)V", "createConstraintSystemForOverloadResolution", "Lorg/jetbrains/kotlin/resolve/calls/results/SimpleConstraintSystem;", "constraintInjector", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getScopeTowerForCallableReferenceArgument", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "getVariableCandidateIfInvoke", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "functionCall", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "isApplicableCallForBuilderInference", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isBuilderInferenceCall", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "isDescriptorFromSource", "isHiddenInResolution", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlinCall", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "kotlinCallArgument", "isInfixCall", "isOldIntersectionIsEmpty", "types", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "isOperatorCall", "isSuperExpression", "receiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "isSuperOrDelegatingConstructorCall", "frontend"})
public final class KotlinResolutionStatelessCallbacksImpl
implements KotlinResolutionStatelessCallbacks {
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;

    public KotlinResolutionStatelessCallbacksImpl(@NotNull DeprecationResolver deprecationResolver, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)deprecationResolver, (String)"deprecationResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        this.deprecationResolver = deprecationResolver;
        this.languageVersionSettings = languageVersionSettings2;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    @Override
    public boolean isDescriptorFromSource(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2) != null;
    }

    @Override
    public boolean isInfixCall(@NotNull KotlinCall kotlinCall) {
        Intrinsics.checkNotNullParameter((Object)kotlinCall, (String)"kotlinCall");
        return kotlinCall instanceof PSIKotlinCallImpl && CallResolverUtilKt.isInfixCall(((PSIKotlinCallImpl)kotlinCall).getPsiCall());
    }

    @Override
    public boolean isOperatorCall(@NotNull KotlinCall kotlinCall) {
        Intrinsics.checkNotNullParameter((Object)kotlinCall, (String)"kotlinCall");
        return kotlinCall instanceof PSIKotlinCallForInvoke || kotlinCall instanceof PSIKotlinCallImpl && CallResolverUtilKt.isConventionCall(((PSIKotlinCallImpl)kotlinCall).getPsiCall());
    }

    @Override
    public boolean isSuperOrDelegatingConstructorCall(@NotNull KotlinCall kotlinCall) {
        Intrinsics.checkNotNullParameter((Object)kotlinCall, (String)"kotlinCall");
        return kotlinCall instanceof PSIKotlinCallImpl && CallResolverUtilKt.isSuperOrDelegatingConstructorCall(((PSIKotlinCallImpl)kotlinCall).getPsiCall());
    }

    @Override
    public boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @NotNull KotlinCall kotlinCall, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)kotlinCall, (String)"kotlinCall");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        PSIKotlinCall pSIKotlinCall = kotlinCall instanceof PSIKotlinCall ? (PSIKotlinCall)kotlinCall : null;
        return DeprecationResolver.isHiddenInResolution$default(this.deprecationResolver, descriptor2, pSIKotlinCall != null ? pSIKotlinCall.getPsiCall() : null, (object = resolutionCallbacks instanceof KotlinResolutionCallbacksImpl ? (KotlinResolutionCallbacksImpl)resolutionCallbacks : null) != null && (object = ((KotlinResolutionCallbacksImpl)object).getTrace()) != null ? object.getBindingContext() : null, kotlinCall instanceof PSIKotlinCallImpl && NewResolutionOldInferenceKt.isCallWithSuperReceiver(((PSIKotlinCallImpl)kotlinCall).getPsiCall()), false, 16, null);
    }

    @Override
    public boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @NotNull KotlinCallArgument kotlinCallArgument, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)kotlinCallArgument, (String)"kotlinCallArgument");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        return this.deprecationResolver.isHiddenInResolution(descriptor2, NewCallArgumentsKt.getPsiExpression(NewCallArgumentsKt.getPsiCallArgument(kotlinCallArgument)), (object = resolutionCallbacks instanceof KotlinResolutionCallbacksImpl ? (KotlinResolutionCallbacksImpl)resolutionCallbacks : null) != null && (object = ((KotlinResolutionCallbacksImpl)object).getTrace()) != null ? object.getBindingContext() : null, false, false);
    }

    @Override
    public boolean isSuperExpression(@Nullable SimpleKotlinCallArgument receiver) {
        SimpleKotlinCallArgument simpleKotlinCallArgument = receiver;
        return (simpleKotlinCallArgument != null ? NewCallArgumentsKt.getPsiExpression(simpleKotlinCallArgument) : null) instanceof KtSuperExpression;
    }

    @Override
    @NotNull
    public ImplicitScopeTower getScopeTowerForCallableReferenceArgument(@NotNull CallableReferenceKotlinCallArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        return ((CallableReferenceKotlinCallArgumentImpl)argument2).getScopeTowerForResolution();
    }

    @Override
    @Nullable
    public ResolutionCandidate getVariableCandidateIfInvoke(@NotNull KotlinCall functionCall) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        PSIKotlinCallForInvoke pSIKotlinCallForInvoke = functionCall instanceof PSIKotlinCallForInvoke ? (PSIKotlinCallForInvoke)functionCall : null;
        return pSIKotlinCallForInvoke != null ? pSIKotlinCallForInvoke.getVariableCall() : null;
    }

    @Override
    public boolean isBuilderInferenceCall(@NotNull KotlinCallArgument argument2, @NotNull ValueParameterDescriptor parameter) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return BuilderInferenceUtilKt.isBuilderInferenceCall(parameter, NewCallArgumentsKt.getPsiCallArgument(argument2).getValueArgument(), this.languageVersionSettings);
    }

    @Override
    public boolean isApplicableCallForBuilderInference(@NotNull CallableDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        return BuilderInferenceUtilKt.isApplicableCallForBuilderInference(descriptor2, languageVersionSettings2);
    }

    @Override
    public boolean isOldIntersectionIsEmpty(@NotNull Collection<? extends KotlinType> types2) {
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        return TypeIntersector.intersectTypes(types2) == null;
    }

    @Override
    @NotNull
    public SimpleConstraintSystem createConstraintSystemForOverloadResolution(@NotNull ConstraintInjector constraintInjector, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)constraintInjector, (String)"constraintInjector");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        return new SimpleConstraintSystemImpl(constraintInjector, builtIns, this.kotlinTypeRefiner, this.languageVersionSettings);
    }
}

