/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.featurelifecycle.FeatureUsage;

public class DeprecatedFeatureUsage
extends FeatureUsage {
    private final String removalDetails;
    private final String advice;
    private final String contextualAdvice;
    private final Documentation documentation;
    private final Type type;

    public DeprecatedFeatureUsage(String summary, String removalDetails, @Nullable String advice, @Nullable String contextualAdvice, Documentation documentation, Type type, Class<?> calledFrom) {
        super(summary, calledFrom);
        this.removalDetails = (String)Preconditions.checkNotNull((Object)removalDetails);
        this.advice = advice;
        this.contextualAdvice = contextualAdvice;
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.documentation = (Documentation)Preconditions.checkNotNull((Object)documentation);
    }

    @VisibleForTesting
    DeprecatedFeatureUsage(DeprecatedFeatureUsage usage, Exception traceException) {
        super(usage.getSummary(), usage.getCalledFrom(), traceException);
        this.removalDetails = usage.removalDetails;
        this.advice = usage.advice;
        this.contextualAdvice = usage.contextualAdvice;
        this.documentation = usage.documentation;
        this.type = usage.type;
    }

    public String getRemovalDetails() {
        return this.removalDetails;
    }

    @Nullable
    public String getAdvice() {
        return this.advice;
    }

    @Nullable
    public String getContextualAdvice() {
        return this.contextualAdvice;
    }

    @Nullable
    public String getDocumentationUrl() {
        return this.documentation.documentationUrl();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String formattedMessage() {
        StringBuilder outputBuilder = new StringBuilder(this.getSummary());
        DeprecatedFeatureUsage.append(outputBuilder, this.removalDetails);
        DeprecatedFeatureUsage.append(outputBuilder, this.contextualAdvice);
        DeprecatedFeatureUsage.append(outputBuilder, this.advice);
        DeprecatedFeatureUsage.append(outputBuilder, this.documentation.consultDocumentationMessage());
        return outputBuilder.toString();
    }

    private static void append(StringBuilder outputBuilder, @Nullable String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            outputBuilder.append(" ").append(message);
        }
    }

    public static enum Type {
        USER_CODE_DIRECT,
        USER_CODE_INDIRECT,
        BUILD_INVOCATION;

    }
}

