/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.logging.LogLevel;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestContext;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.cli.converter.BuildLayoutConverter;
import org.gradle.launcher.cli.converter.InitialPropertiesConverter;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.configuration.InitialProperties;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.NotifyDaemonAboutChangedPathsClient;
import org.gradle.launcher.daemon.configuration.DaemonBuildOptions;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.process.internal.streams.SafeStreams;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.build.DefaultBuildEnvironment;
import org.gradle.tooling.internal.consumer.parameters.FailsafeBuildProgressListenerAdapter;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.internal.protocol.InternalPhasedAction;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.PhasedActionResultListener;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;
import org.gradle.tooling.internal.provider.ConnectionOperationParameters;
import org.gradle.tooling.internal.provider.DaemonBuildActionExecuter;
import org.gradle.tooling.internal.provider.FailsafePhasedActionResultListener;
import org.gradle.tooling.internal.provider.LoggingBridgingBuildActionExecuter;
import org.gradle.tooling.internal.provider.PhasedActionEventConsumer;
import org.gradle.tooling.internal.provider.ProviderStartParameterConverter;
import org.gradle.tooling.internal.provider.ShutdownCoordinator;
import org.gradle.tooling.internal.provider.StdInSwapExecuter;
import org.gradle.tooling.internal.provider.SystemPropertySetterExecuter;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.connection.ProviderConnectionParameters;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.test.ProviderInternalTestExecutionRequest;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderConnection.class);
    private final PayloadSerializer payloadSerializer;
    private final BuildLayoutFactory buildLayoutFactory;
    private final DaemonClientFactory daemonClientFactory;
    private final BuildActionExecuter<BuildActionParameters, BuildRequestContext> embeddedExecutor;
    private final ServiceRegistry sharedServices;
    private final JvmVersionDetector jvmVersionDetector;
    private final FileCollectionFactory fileCollectionFactory;
    private GradleVersion consumerVersion;

    public ProviderConnection(ServiceRegistry sharedServices, BuildLayoutFactory buildLayoutFactory, DaemonClientFactory daemonClientFactory, BuildActionExecuter<BuildActionParameters, BuildRequestContext> embeddedExecutor, PayloadSerializer payloadSerializer, JvmVersionDetector jvmVersionDetector, FileCollectionFactory fileCollectionFactory) {
        this.buildLayoutFactory = buildLayoutFactory;
        this.daemonClientFactory = daemonClientFactory;
        this.embeddedExecutor = embeddedExecutor;
        this.payloadSerializer = payloadSerializer;
        this.sharedServices = sharedServices;
        this.jvmVersionDetector = jvmVersionDetector;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public void configure(ProviderConnectionParameters parameters, GradleVersion consumerVersion) {
        this.consumerVersion = consumerVersion;
        LogLevel providerLogLevel = parameters.getVerboseLogging() ? LogLevel.DEBUG : LogLevel.INFO;
        LOGGER.debug("Configuring logging to level: {}", (Object)providerLogLevel);
        LoggingManagerInternal loggingManager = this.sharedServices.newInstance(LoggingManagerInternal.class);
        loggingManager.setLevelInternal(providerLogLevel);
        loggingManager.start();
    }

    public Object run(String modelName, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        List<String> tasks = providerParameters.getTasks();
        if (modelName.equals(ModelIdentifier.NULL_MODEL) && tasks == null) {
            throw new IllegalArgumentException("No model type or tasks specified.");
        }
        Parameters params = this.initParams(providerParameters);
        if (BuildEnvironment.class.getName().equals(modelName)) {
            if (tasks != null) {
                throw new IllegalArgumentException("Cannot run tasks and fetch the build environment model.");
            }
            return new DefaultBuildEnvironment(new DefaultBuildIdentifier(providerParameters.getProjectDir()), params.buildLayout.getGradleUserHomeDir(), GradleVersion.current().getVersion(), params.daemonParams.getEffectiveJvm().getJavaHome(), params.daemonParams.getEffectiveJvmArgs());
        }
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(providerParameters, params.buildLayout, params.properties);
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion);
        BuildModelAction action = new BuildModelAction(startParameter, modelName, tasks != null, listenerConfig.clientSubscriptions);
        return this.run(action, cancellationToken, listenerConfig, listenerConfig.buildEventConsumer, providerParameters, params);
    }

    public Object run(InternalBuildAction<?> clientAction, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        return this.runClientAction(clientAction, cancellationToken, providerParameters);
    }

    public Object run(InternalBuildActionVersion2<?> clientAction, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        return this.runClientAction(clientAction, cancellationToken, providerParameters);
    }

    public Object runClientAction(Object clientAction, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        List<String> tasks = providerParameters.getTasks();
        SerializedPayload serializedAction = this.payloadSerializer.serialize(clientAction);
        Parameters params = this.initParams(providerParameters);
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(providerParameters, params.buildLayout, params.properties);
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion);
        ClientProvidedBuildAction action = new ClientProvidedBuildAction(startParameter, serializedAction, tasks != null, listenerConfig.clientSubscriptions);
        return this.run(action, cancellationToken, listenerConfig, listenerConfig.buildEventConsumer, providerParameters, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runPhasedAction(InternalPhasedAction clientPhasedAction, PhasedActionResultListener resultListener, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        List<String> tasks = providerParameters.getTasks();
        SerializedPayload serializedAction = this.payloadSerializer.serialize(clientPhasedAction);
        Parameters params = this.initParams(providerParameters);
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(providerParameters, params.buildLayout, params.properties);
        FailsafePhasedActionResultListener failsafePhasedActionResultListener = new FailsafePhasedActionResultListener(resultListener);
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion);
        ClientProvidedPhasedAction action = new ClientProvidedPhasedAction(startParameter, serializedAction, tasks != null, listenerConfig.clientSubscriptions);
        try {
            Object object = this.run(action, cancellationToken, listenerConfig, new PhasedActionEventConsumer(failsafePhasedActionResultListener, this.payloadSerializer, listenerConfig.buildEventConsumer), providerParameters, params);
            return object;
        }
        finally {
            failsafePhasedActionResultListener.rethrowErrors();
        }
    }

    public Object runTests(ProviderInternalTestExecutionRequest testExecutionRequest, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        Parameters params = this.initParams(providerParameters);
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(providerParameters, params.buildLayout, params.properties);
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion);
        TestExecutionRequestAction action = TestExecutionRequestAction.create(listenerConfig.clientSubscriptions, startParameter, testExecutionRequest);
        return this.run(action, cancellationToken, listenerConfig, listenerConfig.buildEventConsumer, providerParameters, params);
    }

    public void notifyDaemonsAboutChangedPaths(List<String> changedPaths, ProviderOperationParameters providerParameters) {
        LoggingServiceRegistry loggingServices = LoggingServiceRegistry.newNestedLogging();
        Parameters params = this.initParams(providerParameters);
        ServiceRegistry clientServices = this.daemonClientFactory.createMessageDaemonServices((OutputEventListener)loggingServices.get(OutputEventListener.class), params.daemonParams);
        NotifyDaemonAboutChangedPathsClient client = clientServices.get(NotifyDaemonAboutChangedPathsClient.class);
        client.notifyDaemonsAboutChangedPaths(changedPaths);
    }

    public void stopWhenIdle(ProviderOperationParameters providerParameters) {
        LoggingServiceRegistry loggingServices = LoggingServiceRegistry.newNestedLogging();
        Parameters params = this.initParams(providerParameters);
        ServiceRegistry clientServices = this.daemonClientFactory.createMessageDaemonServices((OutputEventListener)loggingServices.get(OutputEventListener.class), params.daemonParams);
        ((ShutdownCoordinator)clientServices.find((Type)((Object)ShutdownCoordinator.class))).stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object run(BuildAction action, BuildCancellationToken cancellationToken, ProgressListenerConfiguration progressListenerConfiguration, BuildEventConsumer buildEventConsumer, ProviderOperationParameters providerParameters, Parameters parameters) {
        try {
            BuildActionExecuter<ConnectionOperationParameters, BuildRequestContext> executer = this.createExecuter(providerParameters, parameters);
            boolean interactive = providerParameters.getStandardInput() != null;
            DefaultBuildRequestContext buildRequestContext = new DefaultBuildRequestContext((BuildRequestMetaData)new DefaultBuildRequestMetaData(providerParameters.getStartTime(), interactive), cancellationToken, buildEventConsumer);
            BuildActionResult result = executer.execute(action, new ConnectionOperationParameters(parameters.daemonParams, parameters.tapiSystemProperties, providerParameters), (BuildRequestContext)buildRequestContext);
            this.throwFailure(result);
            Object object = this.payloadSerializer.deserialize(result.getResult());
            return object;
        }
        finally {
            progressListenerConfiguration.failsafeWrapper.rethrowErrors();
        }
    }

    private void throwFailure(BuildActionResult result) {
        if (result.getException() != null) {
            throw this.map(result, result.getException());
        }
        if (result.getFailure() != null) {
            throw this.map(result, (RuntimeException)this.payloadSerializer.deserialize(result.getFailure()));
        }
    }

    private RuntimeException map(BuildActionResult result, RuntimeException exception) {
        if (result.wasCancelled()) {
            throw new InternalBuildCancelledException((Throwable)exception);
        }
        if (exception instanceof InternalTestExecutionException || exception instanceof InternalBuildActionFailureException || exception instanceof InternalUnsupportedModelException) {
            return exception;
        }
        throw new BuildExceptionVersion1((Throwable)exception);
    }

    private BuildActionExecuter<ConnectionOperationParameters, BuildRequestContext> createExecuter(ProviderOperationParameters operationParameters, Parameters params) {
        BuildActionExecuter<BuildActionParameters, BuildRequestContext> executer;
        LoggingManagerInternal loggingManager;
        InputStream standardInput = operationParameters.getStandardInput();
        if (standardInput == null) {
            standardInput = SafeStreams.emptyInput();
        }
        if (Boolean.TRUE.equals(operationParameters.isEmbedded())) {
            loggingManager = this.sharedServices.getFactory(LoggingManagerInternal.class).create();
            loggingManager.captureSystemSources();
            executer = new SystemPropertySetterExecuter(new StdInSwapExecuter(standardInput, this.embeddedExecutor));
        } else {
            LoggingServiceRegistry loggingServices = LoggingServiceRegistry.newNestedLogging();
            loggingManager = (LoggingManagerInternal)loggingServices.getFactory(LoggingManagerInternal.class).create();
            ServiceRegistry clientServices = this.daemonClientFactory.createBuildClientServices((OutputEventListener)loggingServices.get(OutputEventListener.class), params.daemonParams, standardInput);
            executer = clientServices.get(DaemonClient.class);
        }
        return new LoggingBridgingBuildActionExecuter(new DaemonBuildActionExecuter(executer), loggingManager);
    }

    private Parameters initParams(ProviderOperationParameters operationParameters) {
        File javaHome;
        List<String> jvmArguments;
        CommandLineParser commandLineParser = new CommandLineParser();
        commandLineParser.allowUnknownOptions();
        commandLineParser.allowMixedSubcommandsAndOptions();
        InitialPropertiesConverter initialPropertiesConverter = new InitialPropertiesConverter();
        BuildLayoutConverter buildLayoutConverter = new BuildLayoutConverter();
        initialPropertiesConverter.configure(commandLineParser);
        buildLayoutConverter.configure(commandLineParser);
        ParsedCommandLine parsedCommandLine = commandLineParser.parse(operationParameters.getArguments() == null ? Collections.emptyList() : operationParameters.getArguments());
        InitialProperties initialProperties = initialPropertiesConverter.convert(parsedCommandLine);
        BuildLayoutResult buildLayoutResult = buildLayoutConverter.convert(initialProperties, parsedCommandLine, operationParameters.getProjectDir(), layout -> {
            if (operationParameters.getGradleUserHomeDir() != null) {
                layout.setGradleUserHomeDir(operationParameters.getGradleUserHomeDir());
            }
            layout.setProjectDir(operationParameters.getProjectDir());
        });
        AllProperties properties = new LayoutToPropertiesConverter(this.buildLayoutFactory).convert(initialProperties, buildLayoutResult);
        DaemonParameters daemonParams = new DaemonParameters(buildLayoutResult, this.fileCollectionFactory);
        new DaemonBuildOptions().propertiesConverter().convert(properties.getProperties(), (Object)daemonParams);
        if (operationParameters.getDaemonBaseDir() != null) {
            daemonParams.setBaseDir(operationParameters.getDaemonBaseDir());
        }
        if ((jvmArguments = operationParameters.getJvmArguments()) != null) {
            daemonParams.setJvmArgs(jvmArguments);
        }
        properties = properties.merge(daemonParams.getSystemProperties());
        Map<String, String> envVariables = operationParameters.getEnvironmentVariables(null);
        if (envVariables != null) {
            daemonParams.setEnvironmentVariables(envVariables);
        }
        if ((javaHome = operationParameters.getJavaHome()) != null) {
            daemonParams.setJvm(Jvm.forHome(javaHome));
        }
        daemonParams.applyDefaultsFor(this.jvmVersionDetector.getJavaVersion(daemonParams.getEffectiveJvm()));
        if (operationParameters.getDaemonMaxIdleTimeValue() != null && operationParameters.getDaemonMaxIdleTimeUnits() != null) {
            int idleTimeout = (int)operationParameters.getDaemonMaxIdleTimeUnits().toMillis(operationParameters.getDaemonMaxIdleTimeValue().intValue());
            daemonParams.setIdleTimeout(idleTimeout);
        }
        HashMap<String, String> effectiveSystemProperties = new HashMap<String, String>();
        Map<String, String> operationParametersSystemProperties = operationParameters.getSystemProperties(null);
        if (operationParametersSystemProperties != null) {
            effectiveSystemProperties.putAll(operationParametersSystemProperties);
            effectiveSystemProperties.putAll(daemonParams.getMutableAndImmutableSystemProperties());
        } else {
            GUtil.addToMap(effectiveSystemProperties, System.getProperties());
            effectiveSystemProperties.putAll(daemonParams.getMutableAndImmutableSystemProperties());
        }
        return new Parameters(daemonParams, buildLayoutResult, properties, effectiveSystemProperties);
    }

    @VisibleForTesting
    static final class ProgressListenerConfiguration {
        private static final Map<String, OperationType> OPERATION_TYPE_MAPPING = ImmutableMap.builderWithExpectedSize((int)OperationType.values().length).put((Object)"TEST_EXECUTION", (Object)OperationType.TEST).put((Object)"TASK_EXECUTION", (Object)OperationType.TASK).put((Object)"WORK_ITEM_EXECUTION", (Object)OperationType.WORK_ITEM).put((Object)"PROJECT_CONFIGURATION_EXECUTION", (Object)OperationType.PROJECT_CONFIGURATION).put((Object)"TRANSFORM_EXECUTION", (Object)OperationType.TRANSFORM).put((Object)"BUILD_EXECUTION", (Object)OperationType.GENERIC).put((Object)"TEST_OUTPUT", (Object)OperationType.TEST_OUTPUT).put((Object)"FILE_DOWNLOAD", (Object)OperationType.FILE_DOWNLOAD).put((Object)"BUILD_PHASE", (Object)OperationType.BUILD_PHASE).build();
        private final BuildEventSubscriptions clientSubscriptions;
        private final FailsafeBuildProgressListenerAdapter failsafeWrapper;
        private final BuildEventConsumer buildEventConsumer;

        ProgressListenerConfiguration(BuildEventSubscriptions clientSubscriptions, BuildEventConsumer buildEventConsumer, FailsafeBuildProgressListenerAdapter failsafeWrapper) {
            this.clientSubscriptions = clientSubscriptions;
            this.buildEventConsumer = buildEventConsumer;
            this.failsafeWrapper = failsafeWrapper;
        }

        @VisibleForTesting
        BuildEventSubscriptions getClientSubscriptions() {
            return this.clientSubscriptions;
        }

        @VisibleForTesting
        static ProgressListenerConfiguration from(ProviderOperationParameters providerParameters, GradleVersion consumerVersion) {
            Object buildEventConsumer;
            InternalBuildProgressListener buildProgressListener = providerParameters.getBuildProgressListener();
            Set<OperationType> operationTypes = ProgressListenerConfiguration.toOperationTypes(buildProgressListener, consumerVersion);
            BuildEventSubscriptions clientSubscriptions = new BuildEventSubscriptions(operationTypes);
            FailsafeBuildProgressListenerAdapter wrapper = new FailsafeBuildProgressListenerAdapter(buildProgressListener);
            BuildProgressListenerInvokingBuildEventConsumer buildProgressListenerInvokingBuildEventConsumer = buildEventConsumer = clientSubscriptions.isAnyOperationTypeRequested() ? new BuildProgressListenerInvokingBuildEventConsumer((InternalBuildProgressListener)wrapper) : new NoOpBuildEventConsumer();
            if (Boolean.TRUE.equals(providerParameters.isEmbedded())) {
                buildEventConsumer = new SynchronizedConsumer((BuildEventConsumer)buildEventConsumer);
            }
            return new ProgressListenerConfiguration(clientSubscriptions, (BuildEventConsumer)buildEventConsumer, wrapper);
        }

        private static Set<OperationType> toOperationTypes(InternalBuildProgressListener buildProgressListener, GradleVersion consumerVersion) {
            if (buildProgressListener != null) {
                EnumSet<OperationType> operationTypes = EnumSet.noneOf(OperationType.class);
                for (String operation : buildProgressListener.getSubscribedOperations()) {
                    if (!OPERATION_TYPE_MAPPING.containsKey(operation)) continue;
                    operationTypes.add(OPERATION_TYPE_MAPPING.get(operation));
                }
                if (consumerVersion.compareTo(GradleVersion.version((String)"5.1")) < 0 && operationTypes.contains(OperationType.GENERIC)) {
                    operationTypes.add(OperationType.PROJECT_CONFIGURATION);
                    operationTypes.add(OperationType.TRANSFORM);
                    operationTypes.add(OperationType.WORK_ITEM);
                }
                if (consumerVersion.compareTo(GradleVersion.version((String)"7.3")) < 0 && operationTypes.contains(OperationType.GENERIC)) {
                    operationTypes.add(OperationType.FILE_DOWNLOAD);
                }
                return operationTypes;
            }
            return Collections.emptySet();
        }

        private static class SynchronizedConsumer
        implements BuildEventConsumer {
            private final BuildEventConsumer delegate;

            public SynchronizedConsumer(BuildEventConsumer delegate) {
                this.delegate = delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatch(Object message) {
                SynchronizedConsumer synchronizedConsumer = this;
                synchronized (synchronizedConsumer) {
                    this.delegate.dispatch(message);
                }
            }
        }
    }

    private static final class BuildProgressListenerInvokingBuildEventConsumer
    implements BuildEventConsumer {
        private final InternalBuildProgressListener buildProgressListener;

        private BuildProgressListenerInvokingBuildEventConsumer(InternalBuildProgressListener buildProgressListener) {
            this.buildProgressListener = buildProgressListener;
        }

        public void dispatch(Object event) {
            if (event instanceof InternalProgressEvent) {
                this.buildProgressListener.onEvent(event);
            }
        }
    }

    private static class Parameters {
        final DaemonParameters daemonParams;
        final BuildLayoutResult buildLayout;
        final AllProperties properties;
        final Map<String, String> tapiSystemProperties;

        public Parameters(DaemonParameters daemonParams, BuildLayoutResult buildLayout, AllProperties properties, Map<String, String> tapiSystemProperties) {
            this.daemonParams = daemonParams;
            this.buildLayout = buildLayout;
            this.properties = properties;
            this.tapiSystemProperties = tapiSystemProperties;
        }
    }
}

