/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

public class BuildLayoutParametersBuildOptions
extends BuildOptionSet<BuildLayoutParameters> {
    private static List<BuildOption<? super BuildLayoutParameters>> options;

    public List<BuildOption<? super BuildLayoutParameters>> getAllOptions() {
        return options;
    }

    static {
        ArrayList<StringBuildOption> options = new ArrayList<StringBuildOption>();
        options.add(new GradleUserHomeOption());
        options.add(new ProjectDirOption());
        options.add(new SettingsFileOption());
        options.add(new BuildFileOption());
        BuildLayoutParametersBuildOptions.options = Collections.unmodifiableList(options);
    }

    @Deprecated
    public static class BuildFileOption
    extends StringBuildOption<BuildLayoutParameters> {
        public BuildFileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"build-file", (String)"b", (String)"Specify the build file. [deprecated]")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setBuildFile((File)resolver.transform(value));
        }
    }

    @Deprecated
    public static class SettingsFileOption
    extends StringBuildOption<BuildLayoutParameters> {
        public SettingsFileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"settings-file", (String)"c", (String)"Specify the settings file. [deprecated]")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setSettingsFile((File)resolver.transform(value));
        }
    }

    public static class ProjectDirOption
    extends StringBuildOption<BuildLayoutParameters> {
        public ProjectDirOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"project-dir", (String)"p", (String)"Specifies the start directory for Gradle. Defaults to current directory.")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            File projectDir = (File)resolver.transform(value);
            settings.setCurrentDir(projectDir);
            settings.setProjectDir(projectDir);
        }
    }

    public static class GradleUserHomeOption
    extends StringBuildOption<BuildLayoutParameters> {
        public GradleUserHomeOption() {
            super("gradle.user.home", new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"gradle-user-home", (String)"g", (String)"Specifies the Gradle user home directory. Defaults to ~/.gradle")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setGradleUserHomeDir((File)resolver.transform(value));
        }
    }
}

