/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.FinalizableValue;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder,
HoldsProjectState {
    private final DependencyMetaDataProvider metadataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final MetadataHolder holder;
    private final ProjectStateRegistry projectStateRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final Factory factory;

    private DefaultRootComponentMetadataBuilder(DependencyMetaDataProvider metadataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalConfigurationMetadataBuilder configurationMetadataBuilder, ConfigurationsProvider configurationsProvider, ProjectStateRegistry projectStateRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, Factory factory) {
        this.metadataProvider = metadataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.configurationMetadataBuilder = configurationMetadataBuilder;
        this.configurationsProvider = configurationsProvider;
        this.projectStateRegistry = projectStateRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.factory = factory;
        this.holder = new MetadataHolder();
    }

    @Override
    public LocalComponentMetadata toRootComponentMetaData() {
        Module module = this.metadataProvider.getModule();
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module);
        LocalComponentMetadata metadata = this.holder.tryCached(componentIdentifier);
        if (metadata == null) {
            metadata = this.buildRootComponentMetadata(module, componentIdentifier);
            this.holder.cachedValue = metadata;
        }
        return metadata;
    }

    private LocalComponentMetadata buildRootComponentMetadata(Module module, ComponentIdentifier componentIdentifier) {
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectComponentIdentifier projectId = module.getProjectId();
        if (projectId != null) {
            ProjectState projectState = this.projectStateRegistry.stateFor(projectId);
            if (!projectState.hasMutableState()) {
                throw new IllegalStateException("Thread should hold project lock for " + projectId);
            }
            return (LocalComponentMetadata)projectState.fromMutableState(project -> {
                AttributesSchemaInternal schema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
                return this.getRootComponentMetadata(module, componentIdentifier, moduleVersionIdentifier, schema, (ModelContainer<?>)projectState);
            });
        }
        return this.getRootComponentMetadata(module, componentIdentifier, moduleVersionIdentifier, EmptySchema.INSTANCE, (ModelContainer<?>)RootScriptDomainObjectContext.INSTANCE);
    }

    private LocalComponentMetadata getRootComponentMetadata(Module module, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, AttributesSchemaInternal schema, ModelContainer<?> model) {
        DefaultLocalComponentMetadata.ConfigurationsProviderMetadataFactory configurationMetadataFactory = new DefaultLocalComponentMetadata.ConfigurationsProviderMetadataFactory(this.configurationsProvider, this.configurationMetadataBuilder, model, this.calculatedValueContainerFactory);
        this.configurationsProvider.getAll().forEach(FinalizableValue::preventFromFurtherMutation);
        return new DefaultLocalComponentMetadata(moduleVersionIdentifier, componentIdentifier, module.getStatus(), schema, configurationMetadataFactory, null);
    }

    @Override
    public RootComponentMetadataBuilder withConfigurationsProvider(ConfigurationsProvider alternateProvider) {
        return this.factory.create(alternateProvider);
    }

    public MutationValidator getValidator() {
        return this.holder;
    }

    public void discardAll() {
        this.holder.discard();
    }

    public static class Factory {
        private final DependencyMetaDataProvider metaDataProvider;
        private final ComponentIdentifierFactory componentIdentifierFactory;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;
        private final ProjectStateRegistry projectStateRegistry;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;

        @Inject
        public Factory(DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalConfigurationMetadataBuilder configurationMetadataBuilder, ProjectStateRegistry projectStateRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.metaDataProvider = metaDataProvider;
            this.componentIdentifierFactory = componentIdentifierFactory;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.configurationMetadataBuilder = configurationMetadataBuilder;
            this.projectStateRegistry = projectStateRegistry;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        }

        public DefaultRootComponentMetadataBuilder create(ConfigurationsProvider configurationsProvider) {
            return new DefaultRootComponentMetadataBuilder(this.metaDataProvider, this.componentIdentifierFactory, this.moduleIdentifierFactory, this.configurationMetadataBuilder, configurationsProvider, this.projectStateRegistry, this.calculatedValueContainerFactory, this);
        }
    }

    private static class MetadataHolder
    implements MutationValidator {
        private LocalComponentMetadata cachedValue;

        private MetadataHolder() {
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            if ((type == MutationValidator.MutationType.DEPENDENCIES || type == MutationValidator.MutationType.ARTIFACTS || type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES || type == MutationValidator.MutationType.USAGE || type == MutationValidator.MutationType.HIERARCHY) && this.cachedValue != null) {
                this.cachedValue.reevaluate();
            }
        }

        LocalComponentMetadata tryCached(ComponentIdentifier id) {
            if (this.cachedValue != null) {
                if (this.cachedValue.getId().equals(id)) {
                    return this.cachedValue;
                }
                this.cachedValue = null;
            }
            return null;
        }

        public void discard() {
            this.cachedValue = null;
        }
    }
}

