/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.IvyPublishingAwareVariant;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactInternal;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.validation.PublicationErrorChecker;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.InvalidIvyPublicationException;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyConfigurationContainer;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.artifact.DefaultIvyArtifactSet;
import org.gradle.api.publish.ivy.internal.artifact.DerivedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.SingleOutputTaskIvyArtifact;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependencySet;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyExcludeRule;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyProjectDependency;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfigurationContainer;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.DefaultReadOnlyIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyArtifactInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.MutableIvyPublicationidentity;
import org.gradle.api.publish.ivy.internal.publisher.NormalizedIvyArtifact;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.GUtil;

public class DefaultIvyPublication
implements IvyPublicationInternal {
    private static final Logger LOG = Logging.getLogger(DefaultIvyPublication.class);
    private static final String API_VARIANT = "api";
    private static final String API_ELEMENTS_VARIANT = "apiElements";
    private static final String RUNTIME_VARIANT = "runtime";
    private static final String RUNTIME_ELEMENTS_VARIANT = "runtimeElements";
    @VisibleForTesting
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published ivy descriptor.";
    @VisibleForTesting
    public static final String PUBLICATION_WARNING_FOOTER = "These issues indicate information that is lost in the published 'ivy.xml' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Ivy.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.";
    private final String name;
    private final IvyModuleDescriptorSpecInternal descriptor;
    private final MutableIvyPublicationidentity publicationIdentity;
    private final IvyConfigurationContainer configurations;
    private final DefaultIvyArtifactSet mainArtifacts;
    private final PublicationArtifactSet<IvyArtifact> metadataArtifacts;
    private final PublicationArtifactSet<IvyArtifact> derivedArtifacts;
    private final PublicationArtifactSet<IvyArtifact> publishableArtifacts;
    private final DefaultIvyDependencySet ivyDependencies;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final PlatformSupport platformSupport;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final TaskDependencyFactory taskDependencyFactory;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final Set<String> silencedVariants = new HashSet<String>();
    private IvyArtifact ivyDescriptorArtifact;
    private TaskProvider<? extends Task> moduleDescriptorGenerator;
    private SingleOutputTaskIvyArtifact gradleModuleDescriptorArtifact;
    private SoftwareComponentInternal component;
    private final DocumentationRegistry documentationRegistry;
    private boolean alias;
    private final Set<IvyExcludeRule> globalExcludes = new LinkedHashSet<IvyExcludeRule>();
    private boolean populated;
    private boolean artifactsOverridden;
    private boolean versionMappingInUse = false;
    private boolean silenceAllPublicationWarnings;
    private boolean withBuildIdentifier = false;

    @Inject
    public DefaultIvyPublication(String name, Instantiator instantiator, ObjectFactory objectFactory, MutableIvyPublicationidentity publicationIdentity, NotationParser<Object, IvyArtifact> ivyArtifactNotationParser, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator, VersionMappingStrategyInternal versionMappingStrategy, PlatformSupport platformSupport, DocumentationRegistry documentationRegistry, TaskDependencyFactory taskDependencyFactory) {
        this.name = name;
        this.publicationIdentity = publicationIdentity;
        this.projectDependencyResolver = projectDependencyResolver;
        this.platformSupport = platformSupport;
        this.configurations = (IvyConfigurationContainer)instantiator.newInstance(DefaultIvyConfigurationContainer.class, new Object[]{instantiator, collectionCallbackActionDecorator});
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.versionMappingStrategy = versionMappingStrategy;
        this.mainArtifacts = (DefaultIvyArtifactSet)instantiator.newInstance(DefaultIvyArtifactSet.class, new Object[]{name, ivyArtifactNotationParser, fileCollectionFactory, collectionCallbackActionDecorator});
        this.metadataArtifacts = new DefaultPublicationArtifactSet(IvyArtifact.class, "metadata artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.derivedArtifacts = new DefaultPublicationArtifactSet(IvyArtifact.class, "derived artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.publishableArtifacts = new CompositePublicationArtifactSet(taskDependencyFactory, IvyArtifact.class, (PublicationArtifactSet[])Cast.uncheckedCast((Object)new PublicationArtifactSet[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts}));
        this.ivyDependencies = (DefaultIvyDependencySet)((Object)instantiator.newInstance(DefaultIvyDependencySet.class, new Object[]{collectionCallbackActionDecorator}));
        this.descriptor = (IvyModuleDescriptorSpecInternal)instantiator.newInstance(DefaultIvyModuleDescriptorSpec.class, new Object[]{this, instantiator, objectFactory});
        this.documentationRegistry = documentationRegistry;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void withoutBuildIdentifier() {
        this.withBuildIdentifier = false;
    }

    public void withBuildIdentifier() {
        this.withBuildIdentifier = true;
    }

    public boolean isPublishBuildId() {
        return this.withBuildIdentifier;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"Ivy publication", (String)this.name);
    }

    public boolean isLegacy() {
        return false;
    }

    @Nullable
    public SoftwareComponentInternal getComponent() {
        return this.component;
    }

    @Override
    public IvyModuleDescriptorSpecInternal getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setIvyDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        if (this.ivyDescriptorArtifact != null) {
            this.metadataArtifacts.remove((Object)this.ivyDescriptorArtifact);
        }
        this.ivyDescriptorArtifact = new SingleOutputTaskIvyArtifact(descriptorGenerator, this.publicationIdentity, "xml", "ivy", null, this.taskDependencyFactory);
        this.ivyDescriptorArtifact.setName("ivy");
        this.metadataArtifacts.add((Object)this.ivyDescriptorArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.gradleModuleDescriptorArtifact != null) {
            this.metadataArtifacts.remove((Object)this.gradleModuleDescriptorArtifact);
        }
        this.gradleModuleDescriptorArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.gradleModuleDescriptorArtifact = new SingleOutputTaskIvyArtifact(this.moduleDescriptorGenerator, this.publicationIdentity, "module", "json", null, this.taskDependencyFactory);
        this.metadataArtifacts.add((Object)this.gradleModuleDescriptorArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void descriptor(Action<? super IvyModuleDescriptorSpec> configure) {
        configure.execute((Object)this.descriptor);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Ivy publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (this.component == null) {
            return;
        }
        PublicationErrorChecker.checkForUnpublishableAttributes((SoftwareComponentInternal)this.component, (DocumentationRegistry)this.documentationRegistry);
        this.component.finalizeValue();
        PublicationWarningsCollector publicationWarningsCollector = new PublicationWarningsCollector(LOG, UNSUPPORTED_FEATURE, "", PUBLICATION_WARNING_FOOTER, "suppressIvyMetadataWarningsFor");
        Set variants = this.component.getUsages();
        this.populateConfigurations(variants);
        this.populateArtifacts(variants);
        this.populateDependencies(variants, publicationWarningsCollector);
        this.populateGlobalExcludes(variants);
        if (!this.silenceAllPublicationWarnings) {
            publicationWarningsCollector.complete(this.getDisplayName() + " ivy metadata", this.silencedVariants);
        }
    }

    private void populateConfigurations(Set<? extends SoftwareComponentVariant> variants) {
        IvyConfiguration defaultConfiguration = (IvyConfiguration)this.configurations.maybeCreate("default");
        for (SoftwareComponentVariant softwareComponentVariant : variants) {
            String conf = DefaultIvyPublication.mapVariantNameToIvyConfiguration(softwareComponentVariant.getName());
            this.configurations.maybeCreate(conf);
            if (!DefaultIvyPublication.defaultShouldExtend(softwareComponentVariant)) continue;
            defaultConfiguration.extend(conf);
        }
    }

    private static boolean defaultShouldExtend(SoftwareComponentVariant variant) {
        if (!(variant instanceof IvyPublishingAwareVariant)) {
            return true;
        }
        if (((IvyPublishingAwareVariant)variant).isOptional()) {
            return false;
        }
        return !DefaultIvyPublication.isJavaApiVariant(variant.getName());
    }

    private static boolean isJavaRuntimeVariant(String variantName) {
        return RUNTIME_VARIANT.equals(variantName) || RUNTIME_ELEMENTS_VARIANT.equals(variantName);
    }

    private static boolean isJavaApiVariant(String variantName) {
        return API_VARIANT.equals(variantName) || API_ELEMENTS_VARIANT.equals(variantName);
    }

    private void populateArtifacts(Set<? extends SoftwareComponentVariant> variants) {
        if (this.artifactsOverridden) {
            return;
        }
        HashMap seenArtifacts = Maps.newHashMap();
        for (SoftwareComponentVariant softwareComponentVariant : variants) {
            String conf = DefaultIvyPublication.mapVariantNameToIvyConfiguration(softwareComponentVariant.getName());
            for (PublishArtifact publishArtifact : softwareComponentVariant.getArtifacts()) {
                String key = DefaultIvyPublication.artifactKey(publishArtifact);
                IvyArtifact ivyArtifact = (IvyArtifact)seenArtifacts.get(key);
                if (ivyArtifact == null) {
                    ivyArtifact = this.artifact(publishArtifact);
                    ivyArtifact.setConf(conf);
                    seenArtifacts.put(key, ivyArtifact);
                    continue;
                }
                ivyArtifact.setConf(ivyArtifact.getConf() + "," + conf);
            }
        }
    }

    private static String artifactKey(PublishArtifact publishArtifact) {
        return publishArtifact.getName() + ":" + publishArtifact.getType() + ":" + publishArtifact.getExtension() + ":" + publishArtifact.getClassifier();
    }

    private void populateDependencies(Set<? extends SoftwareComponentVariant> variants, PublicationWarningsCollector publicationWarningsCollector) {
        for (SoftwareComponentVariant softwareComponentVariant : variants) {
            publicationWarningsCollector.newContext(softwareComponentVariant.getName());
            for (ModuleDependency dependency : softwareComponentVariant.getDependencies()) {
                String confMapping = DefaultIvyPublication.confMappingFor(softwareComponentVariant, dependency);
                if (!dependency.getAttributes().isEmpty()) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared with Gradle attributes", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                if (dependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)dependency, confMapping);
                    continue;
                }
                ExternalDependency externalDependency = (ExternalDependency)dependency;
                if (this.platformSupport.isTargetingPlatform((HasConfigurableAttributes)dependency)) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared as platform", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                if (!this.versionMappingInUse && externalDependency.getVersion() == null) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s declared without version", externalDependency.getGroup(), externalDependency.getName()));
                }
                this.addExternalDependency(externalDependency, confMapping, ((AttributeContainerInternal)softwareComponentVariant.getAttributes()).asImmutable());
            }
            if (!softwareComponentVariant.getDependencyConstraints().isEmpty()) {
                for (DependencyConstraint constraint : softwareComponentVariant.getDependencyConstraints()) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared as a dependency constraint", constraint.getGroup(), constraint.getName(), constraint.getVersion()));
                }
            }
            if (softwareComponentVariant.getCapabilities().isEmpty()) continue;
            for (Capability capability : softwareComponentVariant.getCapabilities()) {
                publicationWarningsCollector.addVariantUnsupported(String.format("Declares capability %s:%s:%s which cannot be mapped to Ivy", capability.getGroup(), capability.getName(), capability.getVersion()));
            }
        }
    }

    private void populateGlobalExcludes(Set<? extends SoftwareComponentVariant> variants) {
        for (SoftwareComponentVariant softwareComponentVariant : variants) {
            String conf = DefaultIvyPublication.mapVariantNameToIvyConfiguration(softwareComponentVariant.getName());
            for (ExcludeRule excludeRule : softwareComponentVariant.getGlobalExcludes()) {
                this.globalExcludes.add(new DefaultIvyExcludeRule(excludeRule, conf));
            }
        }
    }

    private static String confMappingFor(SoftwareComponentVariant variant, ModuleDependency dependency) {
        String conf = DefaultIvyPublication.mapVariantNameToIvyConfiguration(variant.getName());
        String confMappingTarget = DefaultIvyPublication.mapVariantNameToIvyConfiguration(dependency.getTargetConfiguration());
        if (confMappingTarget == null) {
            confMappingTarget = "default";
        }
        return conf + "->" + confMappingTarget;
    }

    private static String mapVariantNameToIvyConfiguration(String variantName) {
        if (DefaultIvyPublication.isJavaApiVariant(variantName)) {
            return "compile";
        }
        if (DefaultIvyPublication.isJavaRuntimeVariant(variantName)) {
            return RUNTIME_VARIANT;
        }
        return variantName;
    }

    private void addProjectDependency(ProjectDependency dependency, String confMapping) {
        ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
        DefaultIvyDependency moduleDep = new DefaultIvyDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), confMapping, dependency.isTransitive(), Collections.emptyList(), dependency.getExcludeRules());
        this.ivyDependencies.add(new DefaultIvyProjectDependency(moduleDep, dependency.getDependencyProject().getPath()));
    }

    private void addExternalDependency(ExternalDependency dependency, String confMapping, ImmutableAttributes attributes) {
        this.ivyDependencies.add(new DefaultIvyDependency(dependency, confMapping, attributes));
    }

    @Override
    public void configurations(Action<? super IvyConfigurationContainer> config) {
        this.populateFromComponent();
        config.execute((Object)this.configurations);
    }

    @Override
    public IvyConfigurationContainer getConfigurations() {
        this.populateFromComponent();
        return this.configurations;
    }

    @Override
    public IvyArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public IvyArtifact artifact(Object source, Action<? super IvyArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public DefaultIvyArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public String getOrganisation() {
        return this.publicationIdentity.getOrganisation();
    }

    @Override
    public void setOrganisation(String organisation) {
        this.publicationIdentity.setOrganisation(organisation);
    }

    @Override
    public String getModule() {
        return this.publicationIdentity.getModule();
    }

    @Override
    public void setModule(String module) {
        this.publicationIdentity.setModule(module);
    }

    @Override
    public String getRevision() {
        return this.publicationIdentity.getRevision();
    }

    @Override
    public void setRevision(String revision) {
        this.publicationIdentity.setRevision(revision);
    }

    public PublicationArtifactSet<IvyArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    public void allPublishableArtifacts(Action<? super IvyArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    public void whenPublishableArtifactRemoved(Action<? super IvyArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    public IvyArtifact addDerivedArtifact(IvyArtifact originalArtifact, PublicationInternal.DerivedArtifact fileProvider) {
        PublicationInternal.DerivedArtifact effectiveFileProvider = originalArtifact == this.gradleModuleDescriptorArtifact ? new GradleModuleDescriptorDerivedArtifact(fileProvider, this.gradleModuleDescriptorArtifact) : fileProvider;
        DerivedIvyArtifact artifact = new DerivedIvyArtifact(originalArtifact, effectiveFileProvider, this.taskDependencyFactory);
        this.derivedArtifacts.add((Object)artifact);
        return artifact;
    }

    public void removeDerivedArtifact(IvyArtifact artifact) {
        this.derivedArtifacts.remove((Object)artifact);
    }

    @Override
    public IvyPublicationIdentity getIdentity() {
        return this.publicationIdentity;
    }

    @Override
    public Set<IvyDependencyInternal> getDependencies() {
        this.populateFromComponent();
        return this.ivyDependencies;
    }

    @Override
    public IvyNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        Set<IvyArtifact> main = DefaultIvyPublication.linkedHashSetOf(DefaultIvyPublication.normalized(this.mainArtifacts.stream(), this::isValidArtifact));
        LinkedHashSet<IvyArtifact> all = new LinkedHashSet<IvyArtifact>(main);
        DefaultIvyPublication.normalized(Streams.concat((Stream[])new Stream[]{this.metadataArtifacts.stream(), this.derivedArtifacts.stream()}), this::isPublishableArtifact).forEach(all::add);
        return new IvyNormalizedPublication(this.name, this.getCoordinates(), main, DefaultIvyPublication.asReadOnlyIdentity(this.getIdentity()), this.getIvyDescriptorFile(), all);
    }

    private static <T> Set<T> linkedHashSetOf(Stream<T> stream) {
        LinkedHashSet set = new LinkedHashSet();
        stream.forEach(set::add);
        return set;
    }

    private static IvyPublicationIdentity asReadOnlyIdentity(IvyPublicationIdentity identity) {
        return new DefaultReadOnlyIvyPublicationIdentity(identity);
    }

    private boolean isValidArtifact(IvyArtifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile == null) {
            throw new InvalidIvyPublicationException(this.name, String.format("artifact file does not exist: '%s'", artifact));
        }
        if (!((IvyArtifactInternal)artifact).shouldBePublished()) {
            if (artifact.getClassifier() == null) {
                throw new IllegalStateException("Artifact " + artifact.getFile().getName() + " wasn't produced by this build.");
            }
            return false;
        }
        return true;
    }

    private static Stream<IvyArtifact> normalized(Stream<IvyArtifact> artifacts, Predicate<IvyArtifact> predicate) {
        return artifacts.filter(predicate).map(DefaultIvyPublication::normalizedArtifactFor);
    }

    private boolean isPublishableArtifact(IvyArtifact element) {
        if (!((PublicationArtifactInternal)element).shouldBePublished()) {
            return false;
        }
        if (this.gradleModuleDescriptorArtifact == element) {
            return this.gradleModuleDescriptorArtifact.isEnabled();
        }
        return true;
    }

    private static NormalizedIvyArtifact normalizedArtifactFor(IvyArtifact artifact) {
        return ((IvyArtifactInternal)artifact).asNormalisedArtifact();
    }

    @Override
    public boolean writeGradleMetadataMarker() {
        return this.canPublishModuleMetadata() && this.gradleModuleDescriptorArtifact != null && this.gradleModuleDescriptorArtifact.isEnabled();
    }

    private boolean canPublishModuleMetadata() {
        return this.getComponent() != null;
    }

    private File getIvyDescriptorFile() {
        if (this.ivyDescriptorArtifact == null) {
            throw new IllegalStateException("ivyDescriptorArtifact not set for publication");
        }
        return this.ivyDescriptorArtifact.getFile();
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)this.getOrganisation(), (String)this.getModule(), (String)this.getRevision());
    }

    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    public ImmutableAttributes getAttributes() {
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)this.getDescriptor().getStatus());
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        final String publishedUrl = this.getPublishedUrl(source);
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedUrl;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Override
    public void versionMapping(Action<? super VersionMappingStrategy> configureAction) {
        this.versionMappingInUse = true;
        configureAction.execute((Object)this.versionMappingStrategy);
    }

    @Override
    public void suppressIvyMetadataWarningsFor(String variantName) {
        this.silencedVariants.add(variantName);
    }

    @Override
    public void suppressAllIvyMetadataWarnings() {
        this.silenceAllPublicationWarnings = true;
    }

    public VersionMappingStrategyInternal getVersionMappingStrategy() {
        return this.versionMappingStrategy;
    }

    @Override
    public Set<IvyExcludeRule> getGlobalExcludes() {
        return this.globalExcludes;
    }

    private static class GradleModuleDescriptorDerivedArtifact
    implements PublicationInternal.DerivedArtifact {
        private final PublicationInternal.DerivedArtifact derivedArtifact;
        private final SingleOutputTaskIvyArtifact gradleModuleDescriptorArtifact;

        public GradleModuleDescriptorDerivedArtifact(PublicationInternal.DerivedArtifact derivedArtifact, SingleOutputTaskIvyArtifact gradleModuleDescriptorArtifact) {
            this.derivedArtifact = derivedArtifact;
            this.gradleModuleDescriptorArtifact = gradleModuleDescriptorArtifact;
        }

        @Nullable
        public File create() {
            return (File)this.derivedArtifact.create();
        }

        public boolean shouldBePublished() {
            return this.gradleModuleDescriptorArtifact.shouldBePublished() && this.derivedArtifact.shouldBePublished();
        }
    }
}

