/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"functionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getFunctionPattern", "()Ljava/util/regex/Pattern;", "functionTypeInterfacePackages", "", "", "getFunctionTypeInterfacePackages", "()Ljava/util/List;", "checkIsFunctionInterface", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "checkIsFunctionTypeInterfacePackageFqName", "fqName", "ir.serialization.common"})
public final class FunctionalInterfacesUtilsKt {
    private static final Pattern functionPattern = Pattern.compile("^K?(Suspend)?Function\\d+$");
    @NotNull
    private static final List<String> functionTypeInterfacePackages;

    public static final Pattern getFunctionPattern() {
        return functionPattern;
    }

    @NotNull
    public static final List<String> getFunctionTypeInterfacePackages() {
        return functionTypeInterfacePackages;
    }

    public static final boolean checkIsFunctionTypeInterfacePackageFqName(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return functionTypeInterfacePackages.contains(fqName2);
    }

    public static final boolean checkIsFunctionInterface(@Nullable IdSignature idSig) {
        IdSignature.CommonSignature publicSig;
        IdSignature idSignature = idSig;
        IdSignature.CommonSignature commonSignature = publicSig = idSignature != null ? idSignature.asPublic() : null;
        return publicSig != null && FunctionalInterfacesUtilsKt.checkIsFunctionTypeInterfacePackageFqName(publicSig.getPackageFqName()) && ((CharSequence)publicSig.getDeclarationFqName()).length() > 0 && functionPattern.matcher(publicSig.getFirstNameSegment()).find();
    }

    static {
        Object[] objectArray = new String[]{"kotlin", "kotlin.coroutines", "kotlin.reflect"};
        functionTypeInterfacePackages = CollectionsKt.listOf((Object[])objectArray);
    }
}

