/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010!\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020 H\u0002J \u0010*\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0012H\u0007J(\u0010*\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0007J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0002J\u001c\u00104\u001a\u00020\u0014*\u00020\u00162\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0006*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/codegen/intrinsics/TypeIntrinsics;", "", "()V", "BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY", "", "BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY_DESCRIPTOR", "kotlin.jvm.PlatformType", "INTRINSICS_CLASS", "IS_FUNCTON_OF_ARITY_DESCRIPTOR", "IS_FUNCTON_OF_ARITY_METHOD_NAME", "IS_MUTABLE_COLLECTION_METHOD_DESCRIPTOR", "KOTLIN_FUNCTION_INTERFACE_REGEX", "Lkotlin/text/Regex;", "KOTLIN_SUSPEND_FUNCTION_INTERFACE_REGEX", "MUTABLE_COLLECTION_TYPE_FQ_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "OBJECT_TYPE", "Lorg/jetbrains/org/objectweb/asm/Type;", "checkcast", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "asmType", "safe", "", "getAsMutableCollectionDescriptor", "getAsMutableCollectionMethodName", "getClassFqName", "getFunctionTypeArity", "", "getFunctionTypeArityByRegex", "regex", "getIsMutableCollectionMethodName", "getMutableCollectionMethodName", "prefix", "getSuspendFunctionTypeArity", "iconstNode", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value", "instanceOf", "boxedAsmType", "instanceofInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "typeIntrinsicNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "methodName", "methodDescriptor", "typeIntrinsic", "backend"})
public final class TypeIntrinsics {
    @NotNull
    public static final TypeIntrinsics INSTANCE = new TypeIntrinsics();
    @NotNull
    private static final String INTRINSICS_CLASS = "kotlin/jvm/internal/TypeIntrinsics";
    @NotNull
    private static final String IS_FUNCTON_OF_ARITY_METHOD_NAME = "isFunctionOfArity";
    private static final String IS_FUNCTON_OF_ARITY_DESCRIPTOR;
    @NotNull
    private static final Set<FqName> MUTABLE_COLLECTION_TYPE_FQ_NAMES;
    private static final String IS_MUTABLE_COLLECTION_METHOD_DESCRIPTOR;
    @NotNull
    private static final Regex KOTLIN_FUNCTION_INTERFACE_REGEX;
    @NotNull
    private static final Regex KOTLIN_SUSPEND_FUNCTION_INTERFACE_REGEX;
    private static final Type OBJECT_TYPE;
    @NotNull
    private static final String BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY;
    private static final String BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY_DESCRIPTOR;

    private TypeIntrinsics() {
    }

    @JvmStatic
    public static final void instanceOf(@NotNull InstructionAdapter v, @NotNull KotlinType kotlinType, @NotNull Type boxedAsmType) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkNotNullParameter((Object)boxedAsmType, (String)"boxedAsmType");
        int functionTypeArity = INSTANCE.getFunctionTypeArity(kotlinType);
        if (functionTypeArity >= 0) {
            v.iconst(functionTypeArity);
            String string2 = IS_FUNCTON_OF_ARITY_DESCRIPTOR;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IS_FUNCTON_OF_ARITY_DESCRIPTOR");
            INSTANCE.typeIntrinsic(v, IS_FUNCTON_OF_ARITY_METHOD_NAME, string2);
            return;
        }
        int suspendFunctionTypeArity = INSTANCE.getSuspendFunctionTypeArity(kotlinType);
        if (suspendFunctionTypeArity >= 0) {
            Label notSuspendLambda = new Label();
            Label end = new Label();
            InstructionAdapter $this$instanceOf_u24lambda_u240 = v;
            boolean bl = false;
            $this$instanceOf_u24lambda_u240.dup();
            $this$instanceOf_u24lambda_u240.instanceOf(AsmTypes.SUSPEND_FUNCTION_TYPE);
            $this$instanceOf_u24lambda_u240.ifeq(notSuspendLambda);
            $this$instanceOf_u24lambda_u240.iconst(suspendFunctionTypeArity + 1);
            String string3 = IS_FUNCTON_OF_ARITY_DESCRIPTOR;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IS_FUNCTON_OF_ARITY_DESCRIPTOR");
            INSTANCE.typeIntrinsic($this$instanceOf_u24lambda_u240, IS_FUNCTON_OF_ARITY_METHOD_NAME, string3);
            $this$instanceOf_u24lambda_u240.goTo(end);
            $this$instanceOf_u24lambda_u240.mark(notSuspendLambda);
            $this$instanceOf_u24lambda_u240.pop();
            $this$instanceOf_u24lambda_u240.iconst(0);
            $this$instanceOf_u24lambda_u240.mark(end);
            return;
        }
        String isMutableCollectionMethodName = INSTANCE.getIsMutableCollectionMethodName(kotlinType);
        if (isMutableCollectionMethodName != null) {
            String string4 = IS_MUTABLE_COLLECTION_METHOD_DESCRIPTOR;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IS_MUTABLE_COLLECTION_METHOD_DESCRIPTOR");
            INSTANCE.typeIntrinsic(v, isMutableCollectionMethodName, string4);
            return;
        }
        v.instanceOf(boxedAsmType);
    }

    private final AbstractInsnNode iconstNode(int value2) {
        return value2 >= -1 && value2 <= 5 ? (AbstractInsnNode)new InsnNode(3 + value2) : (value2 >= -128 && value2 <= 127 ? (AbstractInsnNode)new IntInsnNode(16, value2) : (value2 >= Short.MIN_VALUE && value2 <= Short.MAX_VALUE ? (AbstractInsnNode)new IntInsnNode(17, value2) : (AbstractInsnNode)new LdcInsnNode(new Integer(value2))));
    }

    @JvmStatic
    public static final void instanceOf(@NotNull TypeInsnNode instanceofInsn, @NotNull InsnList instructions, @NotNull KotlinType kotlinType, @NotNull Type asmType) {
        Intrinsics.checkNotNullParameter((Object)instanceofInsn, (String)"instanceofInsn");
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
        int functionTypeArity = INSTANCE.getFunctionTypeArity(kotlinType);
        if (functionTypeArity >= 0) {
            instructions.insertBefore((AbstractInsnNode)instanceofInsn, INSTANCE.iconstNode(functionTypeArity));
            AbstractInsnNode abstractInsnNode = instanceofInsn;
            String string2 = IS_FUNCTON_OF_ARITY_DESCRIPTOR;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IS_FUNCTON_OF_ARITY_DESCRIPTOR");
            instructions.insertBefore(abstractInsnNode, INSTANCE.typeIntrinsicNode(IS_FUNCTON_OF_ARITY_METHOD_NAME, string2));
            instructions.remove(instanceofInsn);
            return;
        }
        String isMutableCollectionMethodName = INSTANCE.getIsMutableCollectionMethodName(kotlinType);
        if (isMutableCollectionMethodName != null) {
            AbstractInsnNode abstractInsnNode = instanceofInsn;
            String string3 = IS_MUTABLE_COLLECTION_METHOD_DESCRIPTOR;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IS_MUTABLE_COLLECTION_METHOD_DESCRIPTOR");
            instructions.insertBefore(abstractInsnNode, INSTANCE.typeIntrinsicNode(isMutableCollectionMethodName, string3));
            instructions.remove(instanceofInsn);
            return;
        }
        instanceofInsn.desc = asmType.getInternalName();
    }

    @JvmStatic
    public static final void checkcast(@NotNull InstructionAdapter v, @NotNull KotlinType kotlinType, @NotNull Type asmType, boolean safe) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
        if (safe) {
            v.checkcast(asmType);
            return;
        }
        int functionTypeArity = INSTANCE.getFunctionTypeArity(kotlinType);
        if (functionTypeArity >= 0) {
            v.iconst(functionTypeArity);
            String string2 = BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY_DESCRIPTOR;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY_DESCRIPTOR");
            INSTANCE.typeIntrinsic(v, BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY, string2);
            v.checkcast(asmType);
            return;
        }
        String asMutableCollectionMethodName = INSTANCE.getAsMutableCollectionMethodName(kotlinType);
        if (asMutableCollectionMethodName != null) {
            INSTANCE.typeIntrinsic(v, asMutableCollectionMethodName, INSTANCE.getAsMutableCollectionDescriptor(asmType));
            return;
        }
        v.checkcast(asmType);
    }

    private final String getMutableCollectionMethodName(String prefix, KotlinType kotlinType) {
        String string2;
        FqName fqName2 = this.getClassFqName(kotlinType);
        if (fqName2 == null || !MUTABLE_COLLECTION_TYPE_FQ_NAMES.contains(fqName2)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)fqName2, (Object)StandardNames.FqNames.mutableMapEntry)) {
            string2 = "MutableMapEntry";
        } else {
            String string3 = fqName2.shortName().asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fqName.shortName().asString()");
        }
        String baseName = string2;
        return prefix + baseName;
    }

    private final String getIsMutableCollectionMethodName(KotlinType kotlinType) {
        return this.getMutableCollectionMethodName("is", kotlinType);
    }

    private final String getAsMutableCollectionMethodName(KotlinType kotlinType) {
        return this.getMutableCollectionMethodName("as", kotlinType);
    }

    private final FqName getClassFqName(KotlinType kotlinType) {
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(kotlinType);
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        return DescriptorUtils.getFqName(classDescriptor3).toSafe();
    }

    private final int getFunctionTypeArity(KotlinType kotlinType) {
        return this.getFunctionTypeArityByRegex(kotlinType, KOTLIN_FUNCTION_INTERFACE_REGEX);
    }

    private final int getFunctionTypeArityByRegex(KotlinType kotlinType, Regex regex) {
        FqName fqName2 = this.getClassFqName(kotlinType);
        if (fqName2 == null) {
            return -1;
        }
        FqName classFqName = fqName2;
        String string2 = classFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classFqName.asString()");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string2, (int)0, (int)2, null);
        if (matchResult == null) {
            return -1;
        }
        MatchResult match2 = matchResult;
        MatchGroup matchGroup = match2.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        Integer n = Integer.valueOf(matchGroup.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(match.groups[1]!!.value)");
        return ((Number)n).intValue();
    }

    private final int getSuspendFunctionTypeArity(KotlinType kotlinType) {
        return this.getFunctionTypeArityByRegex(kotlinType, KOTLIN_SUSPEND_FUNCTION_INTERFACE_REGEX);
    }

    private final MethodInsnNode typeIntrinsicNode(String methodName, String methodDescriptor) {
        return new MethodInsnNode(184, INTRINSICS_CLASS, methodName, methodDescriptor, false);
    }

    private final void typeIntrinsic(InstructionAdapter $this$typeIntrinsic, String methodName, String methodDescriptor) {
        $this$typeIntrinsic.invokestatic(INTRINSICS_CLASS, methodName, methodDescriptor, false);
    }

    private final String getAsMutableCollectionDescriptor(Type asmType) {
        Type[] typeArray = new Type[]{OBJECT_TYPE};
        String string2 = Type.getMethodDescriptor(asmType, typeArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodDescriptor(asmType, OBJECT_TYPE)");
        return string2;
    }

    static {
        Object[] objectArray = new Type[]{Type.getObjectType("java/lang/Object"), Type.INT_TYPE};
        IS_FUNCTON_OF_ARITY_DESCRIPTOR = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, (Type[])objectArray);
        objectArray = new FqName[]{StandardNames.FqNames.mutableIterator, StandardNames.FqNames.mutableIterable, StandardNames.FqNames.mutableCollection, StandardNames.FqNames.mutableList, StandardNames.FqNames.mutableListIterator, StandardNames.FqNames.mutableMap, StandardNames.FqNames.mutableSet, StandardNames.FqNames.mutableMapEntry};
        MUTABLE_COLLECTION_TYPE_FQ_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Type[]{Type.getObjectType("java/lang/Object")};
        IS_MUTABLE_COLLECTION_METHOD_DESCRIPTOR = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, (Type[])objectArray);
        KOTLIN_FUNCTION_INTERFACE_REGEX = new Regex("^kotlin\\.Function([0-9]+)$");
        KOTLIN_SUSPEND_FUNCTION_INTERFACE_REGEX = new Regex("^kotlin\\.coroutines\\.SuspendFunction([0-9]+)$");
        OBJECT_TYPE = Type.getObjectType("java/lang/Object");
        BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY = "beforeCheckcastToFunctionOfArity";
        objectArray = new Type[]{OBJECT_TYPE, Type.INT_TYPE};
        BEFORE_CHECKCAST_TO_FUNCTION_OF_ARITY_DESCRIPTOR = Type.getMethodDescriptor(OBJECT_TYPE, (Type[])objectArray);
    }
}

