/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirImportsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001c\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001d\u001a\u00020\u001e*\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u0016\u0010\"\u001a\u0004\u0018\u00010\u0018*\u00020#2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010$\u001a\u00020\u001e*\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAllUnderFromEnumEntry", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "checkCanBeImported", "checkConflictingImports", "imports", "", "checkDeprecatedImport", "checkOperatorRename", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getImportStatusOfCallableMembers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getImportStatusOfCallableMembersFromNonSingleton", "getImportStatusOfCallableMembersFromSingleton", "hasFunction", "", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "resolveToClass", "Lorg/jetbrains/kotlin/name/ClassId;", "resolvesToClass", "ImportStatus", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,252:1\n1855#2,2:253\n1747#2,3:257\n1477#2:267\n1502#2,3:268\n1505#2,3:278\n766#2:281\n857#2,2:282\n1855#2:284\n1855#2,2:285\n1856#2:287\n1747#2,2:288\n1749#2:291\n129#3:255\n35#3:290\n37#4:256\n45#5,7:260\n361#6,7:271\n*S KotlinDebug\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n*L\n29#1:253,2\n51#1:257,3\n107#1:267\n107#1:268,3\n107#1:278,3\n109#1:281\n109#1:282,2\n110#1:284\n111#1:285,2\n110#1:287\n126#1:288,2\n126#1:291\n51#1:255\n127#1:290\n51#1:256\n101#1:260,7\n107#1:271,7\n*E\n"})
public final class FirImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirImportsChecker INSTANCE = new FirImportsChecker();

    private FirImportsChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable $this$forEach$iv = declaration.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            if (firImport instanceof FirErrorImport) continue;
            if (firImport.isAllUnder()) {
                if (!(firImport instanceof FirResolvedImport)) {
                    INSTANCE.checkAllUnderFromEnumEntry(firImport, context, reporter);
                }
            } else {
                INSTANCE.checkCanBeImported(firImport, context, reporter);
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkOperatorRename((FirResolvedImport)firImport, context, reporter);
                }
            }
            INSTANCE.checkDeprecatedImport(firImport, context, reporter);
        }
        this.checkConflictingImports(declaration.getImports(), context, reporter);
    }

    private final void checkAllUnderFromEnumEntry(FirImport firImport, CheckerContext context, DiagnosticReporter reporter) {
        FqName fqName2 = firImport.getImportedFqName();
        if (fqName2 == null) {
            return;
        }
        FqName fqName3 = fqName2;
        if (fqName3.isRoot() || fqName3.parent().isRoot()) {
            return;
        }
        ClassId classId = ClassId.topLevel(fqName3.parent());
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(fqName.parent())");
        ClassId classId2 = classId;
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId2, context);
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
        FirClassSymbol $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(classSymbol);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getCallableId().getCallableName(), (Object)fqName3.shortName())) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                AbstractKtSourceElement abstractKtSourceElement = firImport.getSource();
                KtDiagnosticFactory1<Name> ktDiagnosticFactory1 = FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON();
                Name name = classSymbol.getClassId().getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classSymbol.classId.shortClassName");
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)name, (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    private final void checkCanBeImported(FirImport firImport, CheckerContext context, DiagnosticReporter reporter) {
        ClassId parentClassId;
        Name importedName;
        FqName importedFqName;
        block15: {
            block14: {
                FqName fqName2 = firImport.getImportedFqName();
                if (fqName2 == null) {
                    return;
                }
                importedFqName = fqName2;
                Name name = importedFqName.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"importedFqName.shortName()");
                importedName = name;
                if (importedName.isSpecial()) break block14;
                String string2 = importedName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"importedName.identifier");
                if (!(((CharSequence)string2).length() == 0)) break block15;
            }
            return;
        }
        FirSymbolProvider symbolProvider2 = FirSymbolProviderKt.getSymbolProvider(context.getSession());
        FirResolvedImport firResolvedImport = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        ClassId classId = parentClassId = firResolvedImport != null ? firResolvedImport.getResolvedParentClassId() : null;
        if (parentClassId != null) {
            FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(parentClassId, context);
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol parentClassSymbol = firRegularClassSymbol;
            ImportStatus status2 = this.getImportStatusOfCallableMembers(parentClassSymbol, context, importedName);
            if (WhenMappings.$EnumSwitchMapping$0[status2.ordinal()] == 1) {
                return;
            }
            ClassId classId2 = parentClassSymbol.getClassId().createNestedClassId(importedName);
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"parentClassSymbol.classI\u2026stedClassId(importedName)");
            ClassId classId3 = classId2;
            if (symbolProvider2.getClassLikeSymbolByClassId(classId3) != null) {
                return;
            }
            if (status2 == ImportStatus.UNRESOLVED) {
                AbstractKtSourceElement abstractKtSourceElement = firImport.getSource();
                KtDiagnosticFactory1<String> ktDiagnosticFactory1 = FirErrors.INSTANCE.getUNRESOLVED_IMPORT();
                String string3 = importedName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"importedName.asString()");
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)string3, (DiagnosticContext)context, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_BE_IMPORTED(), (Object)importedName, (DiagnosticContext)context, null, 16, null);
            }
            return;
        }
        ClassId classId4 = ClassId.topLevel(importedFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId4, (String)"topLevel(importedFqName)");
        if (this.resolveToClass(classId4, context) != null) {
            return;
        }
        FqName fqName3 = importedFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"importedFqName.parent()");
        if (!((Collection)symbolProvider2.getTopLevelCallableSymbols(fqName3, importedName)).isEmpty()) {
            return;
        }
        if (symbolProvider2.getPackage(importedFqName) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getPACKAGE_CANNOT_BE_IMPORTED(), (DiagnosticContext)context, null, 8, null);
        } else {
            AbstractKtSourceElement abstractKtSourceElement = firImport.getSource();
            KtDiagnosticFactory1<String> ktDiagnosticFactory1 = FirErrors.INSTANCE.getUNRESOLVED_IMPORT();
            String string4 = importedName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"importedName.asString()");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)string4, (DiagnosticContext)context, null, 16, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkConflictingImports(List<? extends FirImport> imports, CheckerContext context, DiagnosticReporter reporter) {
        var5_4 = imports;
        $i$f$filterIsInstanceWithChecker = false;
        result$iv = new ArrayList<E>();
        for (T element$iv : $this$filterIsInstanceWithChecker$iv) {
            if (!(element$iv instanceof FirResolvedImport)) continue;
            import = (FirResolvedImport)element$iv;
            $i$a$-filterIsInstanceWithChecker-FirImportsChecker$checkConflictingImports$interestingImports$1 = false;
            if (import.isAllUnder()) ** GOTO lbl-1000
            v0 = import.getImportedName();
            if (v0 != null && (v0 = (var12_17 = v0.getIdentifierOrNullIfSpecial())) != null) {
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"identifierOrNullIfSpecial");
                v1 = ((CharSequence)var12_17).length() > 0;
            } else {
                v1 = false;
            }
            if (v1 && FirImportsChecker.INSTANCE.resolvesToClass((FirResolvedImport)import, context)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            ((Collection)result$iv).add(element$iv);
        }
        interestingImports = result$iv;
        $this$filterIsInstanceWithChecker$iv = interestingImports;
        $i$f$groupBy = false;
        result$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (E element$iv$iv : $this$groupByTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-groupBy-FirImportsChecker$checkConflictingImports$1 = false;
            v3 = it.getAliasName();
            if (v3 == null) {
                v4 = it.getImportedName();
                v3 = v4;
                Intrinsics.checkNotNull((Object)v4);
            }
            key$iv$iv = v3;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v5 /* !! */  = answer$iv$iv$iv;
            } else {
                v5 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v5 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            $i$a$-filter-FirImportsChecker$checkConflictingImports$2 = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            conflicts = (List)element$iv;
            $i$a$-forEach-FirImportsChecker$checkConflictingImports$3 = false;
            $this$forEach$iv = conflicts;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (FirResolvedImport)element$iv;
                $i$a$-forEach-FirImportsChecker$checkConflictingImports$3$1 = false;
                v6 = it.getSource();
                v7 = FirErrors.INSTANCE.getCONFLICTING_IMPORT();
                v8 = it.getImportedName();
                Intrinsics.checkNotNull((Object)v8);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, v6, v7, (Object)v8, (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    private final void checkOperatorRename(FirResolvedImport firResolvedImport, CheckerContext context, DiagnosticReporter reporter) {
        boolean illegalRename2;
        block10: {
            boolean bl;
            Name name = firResolvedImport.getAliasName();
            if (name == null) {
                return;
            }
            Name alias = name;
            Name name2 = firResolvedImport.getImportedName();
            if (name2 == null) {
                return;
            }
            Name importedName = name2;
            if (!OperatorConventions.isConventionName(alias)) {
                return;
            }
            ClassId classId = firResolvedImport.getResolvedParentClassId();
            if (classId != null) {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId, context);
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol classFir = firRegularClassSymbol;
                bl = classFir.getClassKind().isSingleton() && this.hasFunction(classFir, context, importedName, (Function1<? super FirNamedFunctionSymbol, Boolean>)((Function1)checkOperatorRename.illegalRename.1.INSTANCE));
            } else {
                Iterable $this$any$iv = FirSymbolProviderKt.getSymbolProvider(context.getSession()).getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), importedName);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        FirCallableSymbol $this$isOperator$iv = it;
                        boolean $i$f$isOperator = false;
                        if (!$this$isOperator$iv.getResolvedStatus().isOperator()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = illegalRename2 = false;
                }
            }
        }
        if (illegalRename2) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firResolvedImport.getSource(), FirErrors.INSTANCE.getOPERATOR_RENAMED_ON_IMPORT(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean resolvesToClass(FirResolvedImport $this$resolvesToClass, CheckerContext context) {
        if ($this$resolvesToClass.getResolvedParentClassId() != null) {
            if ($this$resolvesToClass.isAllUnder()) {
                return true;
            }
            ClassId classId = $this$resolvesToClass.getResolvedParentClassId();
            Intrinsics.checkNotNull((Object)classId);
            ClassId parentClass = classId;
            FqName fqName2 = $this$resolvesToClass.getRelativeParentClassName();
            if (fqName2 == null) {
                return false;
            }
            FqName relativeClassName2 = fqName2;
            Name name = $this$resolvesToClass.getImportedName();
            if (name == null) {
                return false;
            }
            Name importedName = name;
            ClassId innerClassId = new ClassId(parentClass.getPackageFqName(), relativeClassName2.child(importedName), false);
            return this.resolveToClass(innerClassId, context) != null;
        }
        FqName fqName3 = $this$resolvesToClass.getImportedFqName();
        if (fqName3 == null) {
            return false;
        }
        FqName importedFqName = fqName3;
        if (importedFqName.isRoot()) {
            return false;
        }
        ClassId classId = ClassId.topLevel(importedFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(importedFqName)");
        ClassId importedClassId = classId;
        return this.resolveToClass(importedClassId, context) != null;
    }

    private final FirRegularClassSymbol resolveToClass(ClassId $this$resolveToClass, CheckerContext context) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context.getSession()).getClassLikeSymbolByClassId($this$resolveToClass);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = classSymbol;
        if (firClassLikeSymbol2 instanceof FirRegularClassSymbol) {
            firRegularClassSymbol = (FirRegularClassSymbol)classSymbol;
        } else if (firClassLikeSymbol2 instanceof FirTypeAliasSymbol) {
            firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(classSymbol, context.getSession());
        } else if (firClassLikeSymbol2 instanceof FirAnonymousObjectSymbol) {
            firRegularClassSymbol = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firRegularClassSymbol;
    }

    private final boolean hasFunction(FirRegularClassSymbol $this$hasFunction, CheckerContext context, Name name, Function1<? super FirNamedFunctionSymbol, Boolean> predicate) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(context.getSession(), $this$hasFunction).processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(result2, predicate){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ Function1<FirNamedFunctionSymbol, Boolean> $predicate;
            {
                this.$result = $result;
                this.$predicate = $predicate;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol sym) {
                Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                if (!this.$result.element) {
                    this.$result.element = (Boolean)this.$predicate.invoke((Object)sym);
                }
            }
        }));
        return result2.element;
    }

    private final ImportStatus getImportStatusOfCallableMembers(FirRegularClassSymbol $this$getImportStatusOfCallableMembers, CheckerContext context, Name name) {
        return $this$getImportStatusOfCallableMembers.getClassKind().isSingleton() ? this.getImportStatusOfCallableMembersFromSingleton($this$getImportStatusOfCallableMembers, context, name) : this.getImportStatusOfCallableMembersFromNonSingleton($this$getImportStatusOfCallableMembers, context, name);
    }

    private final ImportStatus getImportStatusOfCallableMembersFromSingleton(FirRegularClassSymbol $this$getImportStatusOfCallableMembersFromSingleton, CheckerContext context, Name name) {
        Object[] objectArray = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context.getSession(), $this$getImportStatusOfCallableMembersFromSingleton), FirHelpersKt.unsubstitutedScope($this$getImportStatusOfCallableMembersFromSingleton, context)};
        for (FirContainingNamesAwareScope scope2 : CollectionsKt.listOf((Object[])objectArray)) {
            Ref.BooleanRef found = new Ref.BooleanRef();
            scope2.processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(found){
                final /* synthetic */ Ref.BooleanRef $found;
                {
                    this.$found = $found;
                    super(1);
                }

                public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$found.element = true;
                }
            }));
            if (found.element) {
                return ImportStatus.OK;
            }
            scope2.processPropertiesByName(name, (Function1)new Function1<FirVariableSymbol<?>, Unit>(found){
                final /* synthetic */ Ref.BooleanRef $found;
                {
                    this.$found = $found;
                    super(1);
                }

                public final void invoke(@NotNull FirVariableSymbol<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.$found.element = true;
                }
            });
            if (!found.element) continue;
            return ImportStatus.OK;
        }
        return ImportStatus.UNRESOLVED;
    }

    private final ImportStatus getImportStatusOfCallableMembersFromNonSingleton(FirRegularClassSymbol $this$getImportStatusOfCallableMembersFromNonSingleton, CheckerContext context, Name name) {
        Ref.BooleanRef hasStatic = new Ref.BooleanRef();
        Ref.BooleanRef found = new Ref.BooleanRef();
        Object[] objectArray = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context.getSession(), $this$getImportStatusOfCallableMembersFromNonSingleton), ImplicitReceiverUtilsKt.staticScope((FirClass)$this$getImportStatusOfCallableMembersFromNonSingleton.getFir(), context.getSessionHolder()), FirHelpersKt.unsubstitutedScope($this$getImportStatusOfCallableMembersFromNonSingleton, context)};
        for (FirContainingNamesAwareScope scope2 : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            scope2.processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(hasStatic, found){
                final /* synthetic */ Ref.BooleanRef $hasStatic;
                final /* synthetic */ Ref.BooleanRef $found;
                {
                    this.$hasStatic = $hasStatic;
                    this.$found = $found;
                    super(1);
                }

                public final void invoke(@NotNull FirNamedFunctionSymbol sym) {
                    Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                    if (FirCallableSymbolKt.isStatic(sym)) {
                        this.$hasStatic.element = true;
                    }
                    this.$found.element = true;
                }
            }));
            if (hasStatic.element) {
                return ImportStatus.OK;
            }
            scope2.processPropertiesByName(name, (Function1)new Function1<FirVariableSymbol<?>, Unit>(hasStatic, found){
                final /* synthetic */ Ref.BooleanRef $hasStatic;
                final /* synthetic */ Ref.BooleanRef $found;
                {
                    this.$hasStatic = $hasStatic;
                    this.$found = $found;
                    super(1);
                }

                public final void invoke(@NotNull FirVariableSymbol<?> sym) {
                    Intrinsics.checkNotNullParameter(sym, (String)"sym");
                    if (FirCallableSymbolKt.isStatic((FirCallableSymbol)sym)) {
                        this.$hasStatic.element = true;
                    }
                    this.$found.element = true;
                }
            });
            if (!hasStatic.element) continue;
            return ImportStatus.OK;
        }
        return found.element ? ImportStatus.CANNOT_BE_IMPORTED : ImportStatus.UNRESOLVED;
    }

    private final void checkDeprecatedImport(FirImport firImport, CheckerContext context, DiagnosticReporter reporter) {
        FqName importedFqName;
        block7: {
            block6: {
                FqName fqName2 = firImport.getImportedFqName();
                if (fqName2 == null) {
                    return;
                }
                importedFqName = fqName2;
                if (importedFqName.isRoot()) break block6;
                String string2 = importedFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"importedFqName.shortName().asString()");
                if (!(((CharSequence)string2).length() == 0)) break block7;
            }
            return;
        }
        Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        if (object == null || (object = ((FirResolvedImport)object).getResolvedParentClassId()) == null) {
            ClassId classId = ClassId.topLevel(importedFqName);
            object = classId;
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(importedFqName)");
        }
        Object classId = object;
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass((ClassId)classId, context);
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol classLike = firRegularClassSymbol;
        FirDeprecationChecker.INSTANCE.reportDeprecationIfNeeded$checkers(firImport.getSource(), classLike, null, context, reporter);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "", "(Ljava/lang/String;I)V", "OK", "CANNOT_BE_IMPORTED", "UNRESOLVED", "checkers"})
    private static final class ImportStatus
    extends Enum<ImportStatus> {
        public static final /* enum */ ImportStatus OK = new ImportStatus();
        public static final /* enum */ ImportStatus CANNOT_BE_IMPORTED = new ImportStatus();
        public static final /* enum */ ImportStatus UNRESOLVED = new ImportStatus();
        private static final /* synthetic */ ImportStatus[] $VALUES;

        public static ImportStatus[] values() {
            return (ImportStatus[])$VALUES.clone();
        }

        public static ImportStatus valueOf(String value2) {
            return Enum.valueOf(ImportStatus.class, value2);
        }

        static {
            $VALUES = importStatusArray = new ImportStatus[]{ImportStatus.OK, ImportStatus.CANNOT_BE_IMPORTED, ImportStatus.UNRESOLVED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImportStatus.values().length];
            try {
                nArray[ImportStatus.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

