/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.hash.Hashing;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.archive.ZipCopyAction;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.UserHome.class)
public class ClasspathBuilder {
    private static final int BUFFER_SIZE = 8192;
    private final TemporaryFileProvider temporaryFileProvider;

    @Inject
    ClasspathBuilder(TemporaryFileProvider temporaryFileProvider) {
        this.temporaryFileProvider = temporaryFileProvider;
    }

    public void jar(File jarFile, Action action) {
        try {
            this.buildJar(jarFile, action);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Failed to create Jar file %s.", jarFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJar(File jarFile, Action action) throws IOException {
        File parentDir = jarFile.getParentFile();
        File tmpFile = this.temporaryFileProvider.createTemporaryFile(jarFile.getName(), ".tmp", new String[0]);
        try {
            Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
            try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile), 8192));){
                outputStream.setLevel(0);
                action.execute(new ZipEntryBuilder(outputStream));
            }
            Files.move(tmpFile.toPath(), jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile.toPath());
        }
    }

    private static class ZipEntryBuilder
    implements EntryBuilder {
        private final ZipArchiveOutputStream outputStream;
        private final Set<String> dirs = new HashSet<String>();

        public ZipEntryBuilder(ZipArchiveOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void put(String name, byte[] content, ClasspathEntryVisitor.Entry.CompressionMethod compressionMethod) throws IOException {
            this.maybeAddParent(name);
            ZipArchiveEntry zipEntry = this.newZipEntryWithFixedTime(name);
            this.configureCompression(zipEntry, compressionMethod, content);
            this.outputStream.setEncoding("UTF-8");
            this.outputStream.putArchiveEntry((ArchiveEntry)zipEntry);
            this.outputStream.write(content);
            this.outputStream.closeArchiveEntry();
        }

        private void maybeAddParent(String name) throws IOException {
            String dir = this.dir(name);
            if (dir != null && this.dirs.add(dir)) {
                this.maybeAddParent(dir);
                ZipArchiveEntry zipEntry = this.newZipEntryWithFixedTime(dir);
                this.outputStream.putArchiveEntry((ArchiveEntry)zipEntry);
                this.outputStream.closeArchiveEntry();
            }
        }

        @Nullable
        String dir(String name) {
            int pos = name.lastIndexOf(47);
            if (pos == name.length() - 1) {
                pos = name.lastIndexOf(47, pos - 1);
            }
            if (pos >= 0) {
                return name.substring(0, pos + 1);
            }
            return null;
        }

        private ZipArchiveEntry newZipEntryWithFixedTime(String name) {
            ZipArchiveEntry entry = new ZipArchiveEntry(name);
            entry.setTime(ZipCopyAction.CONSTANT_TIME_FOR_ZIP_ENTRIES);
            return entry;
        }

        private void configureCompression(ZipArchiveEntry entry, ClasspathEntryVisitor.Entry.CompressionMethod compressionMethod, byte[] contents) {
            if (ZipEntryBuilder.shouldCompress(compressionMethod)) {
                entry.setMethod(8);
            } else {
                entry.setMethod(0);
                entry.setSize((long)contents.length);
                entry.setCompressedSize((long)contents.length);
                entry.setCrc(ZipEntryBuilder.computeCrc32Of(contents));
            }
        }

        private static boolean shouldCompress(ClasspathEntryVisitor.Entry.CompressionMethod compressionMethod) {
            return compressionMethod != ClasspathEntryVisitor.Entry.CompressionMethod.STORED;
        }

        private static long computeCrc32Of(byte[] contents) {
            return Hashing.crc32().hashBytes(contents).padToLong();
        }
    }

    public static interface EntryBuilder {
        default public void put(String name, byte[] content) throws IOException {
            this.put(name, content, ClasspathEntryVisitor.Entry.CompressionMethod.UNDEFINED);
        }

        public void put(String var1, byte[] var2, ClasspathEntryVisitor.Entry.CompressionMethod var3) throws IOException;
    }

    public static interface Action {
        public void execute(EntryBuilder var1) throws IOException;
    }
}

