/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveOptimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;

class RootNode
extends NodeState
implements RootGraphNode {
    private final ResolveOptimizations resolveOptimizations;
    private final List<? extends DependencyMetadata> syntheticDependencies;

    RootNode(Long resultId, ComponentState moduleRevision, ResolvedConfigurationIdentifier id, ResolveState resolveState, List<? extends DependencyMetadata> syntheticDependencies, VariantGraphResolveMetadata configuration) {
        super(resultId, id, moduleRevision, resolveState, configuration, false);
        moduleRevision.setRoot();
        this.resolveOptimizations = resolveState.getResolveOptimizations();
        this.syntheticDependencies = syntheticDependencies;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
        return this.getMetadata().getFiles();
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    @Override
    public void deselect() {
    }

    @Override
    public LocalConfigurationGraphResolveMetadata getMetadata() {
        return (LocalConfigurationGraphResolveMetadata)super.getMetadata();
    }

    @Override
    public ResolveOptimizations getResolveOptimizations() {
        return this.resolveOptimizations;
    }

    @Override
    protected List<? extends DependencyMetadata> getAllDependencies() {
        List<? extends DependencyMetadata> superDependencies = super.getAllDependencies();
        if (this.syntheticDependencies.isEmpty()) {
            return superDependencies;
        }
        int expectedSize = superDependencies.size() + this.syntheticDependencies.size();
        ImmutableList.Builder allDependencies = ImmutableList.builderWithExpectedSize((int)expectedSize);
        allDependencies.addAll(superDependencies);
        allDependencies.addAll(this.syntheticDependencies);
        return allDependencies.build();
    }
}

