/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public abstract class DefaultWarPluginConvention
extends WarPluginConvention
implements HasPublicType {
    private String webAppDirName;
    private final Project project;

    @Inject
    public DefaultWarPluginConvention(Project project) {
        this.project = project;
        this.webAppDirName = "src/main/webapp";
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(WarPluginConvention.class);
    }

    @Override
    public File getWebAppDir() {
        DefaultWarPluginConvention.logDeprecation();
        return this.project.file((Object)this.webAppDirName);
    }

    @Override
    public String getWebAppDirName() {
        DefaultWarPluginConvention.logDeprecation();
        return this.webAppDirName;
    }

    @Override
    public void setWebAppDirName(String webAppDirName) {
        DefaultWarPluginConvention.logDeprecation();
        this.webAppDirName = webAppDirName;
    }

    @Override
    public Project getProject() {
        DefaultWarPluginConvention.logDeprecation();
        return this.project;
    }

    private static void logDeprecation() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(WarPluginConvention.class).willBeRemovedInGradle9().withUpgradeGuideSection(8, "war_convention_deprecation")).nagUser();
    }
}

