/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.io.AppendablePersistentMap;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;

@ApiStatus.Experimental
public interface PersistentMapBase<Key, Value> {
    @ApiStatus.OverrideOnly
    @NotNull
    public DataExternalizer<Value> getValuesExternalizer();

    default public void appendData(Key key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentMapBase.$$$reportNull$$$0(0);
        }
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        DataExternalizer<Value> dataExternalizer = this.getValuesExternalizer();
        Value oldValue = this.get(key);
        if (oldValue != null) {
            dataExternalizer.save(dos, oldValue);
        }
        appender.append(dos);
        dos.close();
        DataInputStream dis = new DataInputStream(bos.toInputStream());
        Value newValue2 = dataExternalizer.read(dis);
        dis.close();
        this.put(key, newValue2);
    }

    public boolean processExistingKeys(@NotNull Processor<? super Key> var1) throws IOException;

    public boolean processKeys(@NotNull Processor<? super Key> var1) throws IOException;

    public boolean containsKey(Key var1) throws IOException;

    public Value get(Key var1) throws IOException;

    public void put(Key var1, Value var2) throws IOException;

    public void remove(Key var1) throws IOException;

    public boolean isDirty();

    public void markDirty() throws IOException;

    public void force() throws IOException;

    public boolean isClosed();

    public void close() throws IOException;

    public void closeAndDelete() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appender", "org/jetbrains/kotlin/com/intellij/util/io/PersistentMapBase", "appendData"));
    }
}

